/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.pivot2cs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseDeclarationVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseReferenceVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CSConversion;
import org.eclipse.ocl.examples.xtext.base.utilities.CSI2PivotMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2CS
extends AbstractConversion {
    @NonNull
    private Map<EClass, Factory> factoryMap = new HashMap<EClass, Factory>();
    @NonNull
    protected final Map<? extends Resource, ? extends Resource> cs2pivotResourceMap;

    public Pivot2CS(@NonNull Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, @NonNull MetaModelManager metaModelManager) {
        super(metaModelManager);
        this.cs2pivotResourceMap = cs2pivotResourceMap;
    }

    public Pivot2CS(@NonNull Pivot2CS aConverter) {
        super(aConverter.metaModelManager);
        this.cs2pivotResourceMap = aConverter.cs2pivotResourceMap;
    }

    protected synchronized void addFactory(@NonNull Factory factory) {
        EClass[] eClassArray = factory.getEClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            this.factoryMap.put(eClass, factory);
            ++n2;
        }
    }

    @NonNull
    public BaseDeclarationVisitor createDefaultDeclarationVisitor(@NonNull Pivot2CSConversion conversion) {
        return new BaseDeclarationVisitor(conversion);
    }

    @NonNull
    public BaseReferenceVisitor createDefaultReferenceVisitor(@NonNull Pivot2CSConversion conversion) {
        return new BaseReferenceVisitor(conversion);
    }

    @NonNull
    public Collection<? extends Resource> getCSResources() {
        Set<? extends Resource> keySet = this.cs2pivotResourceMap.keySet();
        return keySet;
    }

    @Nullable
    public Factory getFactory(@NonNull EClass eClass) {
        return this.factoryMap.get(eClass);
    }

    @Nullable
    public Resource getPivotResource(@NonNull Resource csResource) {
        return this.cs2pivotResourceMap.get(csResource);
    }

    @NonNull
    public Collection<? extends Resource> getPivotResources() {
        Collection<? extends Resource> values = this.cs2pivotResourceMap.values();
        return values;
    }

    public void update() {
        Pivot2CSConversion conversion = new Pivot2CSConversion(this);
        Collection<? extends Resource> csResources = this.getCSResources();
        conversion.update(csResources);
        CSI2PivotMapping cs2PivotMapping = CSI2PivotMapping.getAdapter(this.metaModelManager);
        cs2PivotMapping.update(csResources);
    }

    public static interface Factory {
        @NonNull
        public BaseDeclarationVisitor createDeclarationVisitor(@NonNull Pivot2CSConversion var1);

        @NonNull
        public BaseReferenceVisitor createReferenceVisitor(@NonNull Pivot2CSConversion var1);

        @NonNull
        public EClass[] getEClasses();
    }
}

