/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scoping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.NullAttribution;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.scoping.IScopeView;
import org.eclipse.ocl.examples.xtext.base.scoping.QualifiedPath;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseScopeView
extends AbstractScope
implements IScopeView {
    private static final Logger logger = Logger.getLogger(BaseScopeView.class);
    @NonNull
    public static final IScopeView NULLSCOPEVIEW = new IScopeView(){

        public Iterable<IEObjectDescription> getAllElements() {
            return Collections.emptyList();
        }

        @NonNull
        public Attribution getAttribution() {
            return NullAttribution.INSTANCE;
        }

        public ElementCS getChild() {
            return null;
        }

        public EStructuralFeature getContainmentFeature() {
            return null;
        }

        public Iterable<IEObjectDescription> getElements(EObject object) {
            return Collections.emptyList();
        }

        public Iterable<IEObjectDescription> getElements(QualifiedName name) {
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public IScopeView getParent() {
            return NULLSCOPEVIEW;
        }

        @Override
        @NonNull
        public IScopeView getRoot() {
            return NULLSCOPEVIEW;
        }

        public IEObjectDescription getSingleElement(QualifiedName name) {
            return null;
        }

        public IEObjectDescription getSingleElement(EObject object) {
            return null;
        }

        public ElementCS getTarget() {
            return null;
        }

        public boolean isQualified() {
            return false;
        }
    };
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final ElementCS target;
    @Nullable
    protected final ElementCS child;
    @NonNull
    protected final EReference targetReference;
    protected final boolean isQualified;
    private Attribution attribution = null;

    @NonNull
    public static BaseScopeView getScopeView(@NonNull MetaModelManager metaModelManager, @NonNull ElementCS target, @NonNull EReference targetReference) {
        return new BaseScopeView(metaModelManager, target, null, targetReference, false);
    }

    @NonNull
    private static IScopeView getParent(@NonNull MetaModelManager metaModelManager, @NonNull ElementCS target, @NonNull EReference targetReference, boolean isQualified) {
        ElementCS csParent = target.getLogicalParent();
        if (csParent == null) {
            return NULLSCOPEVIEW;
        }
        return new BaseScopeView(metaModelManager, csParent, target, targetReference, isQualified);
    }

    protected BaseScopeView(@NonNull MetaModelManager metaModelManager, @NonNull ElementCS target, @Nullable ElementCS child, @NonNull EReference targetReference, boolean isQualified) {
        super((IScope)BaseScopeView.getParent(metaModelManager, target, targetReference, isQualified), false);
        this.metaModelManager = metaModelManager;
        this.target = target;
        this.child = child;
        this.targetReference = targetReference;
        this.isQualified = isQualified;
    }

    @NonNull
    public Attribution getAttribution() {
        Attribution attribution2 = this.attribution;
        if (attribution2 == null) {
            this.attribution = attribution2 = PivotUtil.getAttribution((EObject)this.target);
        }
        return attribution2;
    }

    public Iterable<IEObjectDescription> getAllElements() {
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, null);
        try {
            Attribution attribution = this.getAttribution();
            ScopeView aScope = attribution.computeLookup((EObject)this.target, environmentView, (ScopeView)this);
            if (aScope != null) {
                environmentView.computeLookups(aScope);
            }
        }
        catch (IllegalLibraryException illegalLibraryException) {
            // empty catch block
        }
        return this.getDescriptions(environmentView);
    }

    protected final Iterable<IEObjectDescription> getAllLocalElements() {
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, null);
        Attribution attribution = this.getAttribution();
        attribution.computeLookup((EObject)this.target, environmentView, (ScopeView)this);
        return this.getDescriptions(environmentView);
    }

    @Nullable
    public ElementCS getChild() {
        return this.child;
    }

    public EStructuralFeature getContainmentFeature() {
        return this.child != null ? this.child.eContainmentFeature() : this.targetReference;
    }

    @NonNull
    private Element getContextRoot(@NonNull Element context) {
        while (!(context instanceof Namespace) && !(context instanceof Type)) {
            EObject container = context.eContainer();
            if (!(container instanceof Element)) break;
            context = (Element)container;
        }
        return context;
    }

    @Nullable
    private IEObjectDescription getDescription(EnvironmentView environmentView) {
        int contentsSize = environmentView.getSize();
        if (contentsSize == 0) {
            return null;
        }
        if (contentsSize != 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + environmentView.getName() + "'"));
        }
        for (Map.Entry entry : environmentView.getEntries()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                value = values.get(values.size() - 1);
            }
            if (!(value instanceof EObject)) continue;
            return EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)value));
        }
        return null;
    }

    @NonNull
    private List<IEObjectDescription> getDescriptions(EnvironmentView environmentView) {
        ArrayList<IEObjectDescription> contents = new ArrayList<IEObjectDescription>();
        for (Map.Entry entry : environmentView.getEntries()) {
            Object values = entry.getValue();
            if (values instanceof EObject) {
                contents.add(EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)values)));
                continue;
            }
            if (!(values instanceof List)) continue;
            for (Object value : (List)values) {
                contents.add(EObjectDescription.create((String)((String)entry.getKey()), (EObject)((EObject)value)));
            }
        }
        return contents;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, name.toString());
        int size = environmentView.computeLookups((ScopeView)this);
        if (size <= 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(this.getDescription(environmentView));
        }
        List<IEObjectDescription> contents = this.getDescriptions(environmentView);
        return contents;
    }

    /*
     * Unable to fully structure code
     */
    public Iterable<IEObjectDescription> getElements(EObject object) {
        block11: {
            block14: {
                block13: {
                    block12: {
                        block10: {
                            descriptiveName = null;
                            if (this.targetReference != BaseCSTPackage.Literals.IMPORT_CS__NAMESPACE) break block10;
                            descriptiveName = this.getNonPivotURI(object);
                            break block11;
                        }
                        if (this.targetReference != BaseCSTPackage.Literals.MODEL_ELEMENT_REF_CS__ELEMENT) break block12;
                        descriptiveName = this.getNonPivotURI(object);
                        break block11;
                    }
                    if (this.targetReference != BaseCSTPackage.Literals.REFERENCE_CS__OPPOSITE) break block13;
                    descriptiveName = ((NamedElement)object).getName();
                    break block11;
                }
                if (this.targetReference != BaseCSTPackage.Literals.REFERENCE_CS__KEYS) break block14;
                descriptiveName = ((NamedElement)object).getName();
                break block11;
            }
            if (this.targetReference != BaseCSTPackage.Literals.TYPED_TYPE_REF_CS__TYPE || !(object instanceof Type)) ** GOTO lbl40
            if (object instanceof PrimitiveType) {
                descriptiveName = ((PrimitiveType)object).getName();
            } else {
                csRef = this.getTarget();
                while (csRef.eContainer() instanceof TypeRefCS || csRef.eContainer() instanceof TemplateParameterSubstitutionCS || csRef.eContainer() instanceof TemplateBindingCS) {
                    csRef = csRef.eContainer();
                }
                csContext = (ModelElementCS)csRef.eContainer();
                eResource = EcoreUtil.getRootContainer((EObject)csContext).eResource();
                if (eResource == null) {
                    return Collections.emptyList();
                }
                aliasAnalysis = AliasAnalysis.getAdapter(eResource, this.metaModelManager);
                context = csContext.getPivot();
                if (context == null) {
                    return Collections.emptyList();
                }
                context = this.getContextRoot(context);
                contextPath = new QualifiedPath(aliasAnalysis.getPath(context));
                objectPath = new QualifiedPath(aliasAnalysis.getPath((Element)object));
                qualifiedRelativeName = objectPath.deresolve(contextPath);
                objectDescription = EObjectDescription.create((QualifiedName)qualifiedRelativeName, (EObject)object);
                return Collections.singletonList(objectDescription);
lbl40:
                // 1 sources

                if (object instanceof NamedElement) {
                    csRef = this.getTarget();
                    while (csRef.eContainer() instanceof TypeRefCS || csRef.eContainer() instanceof TemplateParameterSubstitutionCS || csRef.eContainer() instanceof TemplateBindingCS) {
                        csRef = csRef.eContainer();
                    }
                    csContext = (Pivotable)csRef.eContainer();
                    eResource = csContext.eResource();
                    if (eResource == null) {
                        return Collections.emptyList();
                    }
                    aliasAnalysis = AliasAnalysis.getAdapter(eResource, this.metaModelManager);
                    context = csContext.getPivot();
                    if (context == null) {
                        return Collections.emptyList();
                    }
                    context = this.getContextRoot(context);
                    contextPath = new QualifiedPath(aliasAnalysis.getPath(context));
                    objectPath = new QualifiedPath(aliasAnalysis.getPath((Element)object));
                    qualifiedRelativeName = objectPath.deresolve(contextPath);
                    objectDescription = EObjectDescription.create((QualifiedName)qualifiedRelativeName, (EObject)object);
                    return Collections.singletonList(objectDescription);
                }
            }
        }
        if (descriptiveName != null) {
            objectDescription = EObjectDescription.create((String)descriptiveName, (EObject)object);
            return Collections.singletonList(objectDescription);
        }
        return super.getElements(object);
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @Nullable
    private String getNonPivotURI(@Nullable EObject object) {
        EObject target;
        URI uri = null;
        if (object == null) {
            return null;
        }
        if (object instanceof PivotObjectImpl && (target = ((PivotObjectImpl)object).getTarget()) != null) {
            uri = EcoreUtil.getURI((EObject)target);
        }
        if (uri == null) {
            uri = EcoreUtil.getURI((EObject)object);
        }
        if (uri == null) {
            return null;
        }
        if (PivotUtil.isPivotURI((URI)uri)) {
            uri = PivotUtil.getNonPivotURI((URI)uri);
        }
        return uri.toString();
    }

    @Override
    @NonNull
    public IScopeView getParent() {
        IScope parent = super.getParent();
        assert (parent instanceof IScopeView);
        return (IScopeView)parent;
    }

    @Override
    @NonNull
    public IScopeView getRoot() {
        IScopeView parent = this.getParent();
        if (parent == NULLSCOPEVIEW) {
            return this;
        }
        return parent.getRoot();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        if (object instanceof NamedElement) {
            return EObjectDescription.create((String)((NamedElement)object).getName(), (EObject)object);
        }
        return super.getSingleElement(object);
    }

    @Nullable
    public IEObjectDescription getSingleElement(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)this.targetReference, name.toString());
        int size = environmentView.computeLookups((ScopeView)this);
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return this.getDescription(environmentView);
        }
        return null;
    }

    @NonNull
    public final ElementCS getTarget() {
        return this.target;
    }

    public final boolean isQualified() {
        return this.isQualified;
    }

    public String toString() {
        ElementCS target = this.getTarget();
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(target.eClass().getName());
        EStructuralFeature containmentFeature2 = this.getContainmentFeature();
        if (containmentFeature2 != null) {
            s.append("::");
            s.append(containmentFeature2.getName());
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

