/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.manager.AbstractMetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS2PivotResourceAdapter
extends AbstractMetaModelManagerResourceAdapter<BaseCSResource> {
    @NonNull
    private final CS2Pivot converter;

    @Nullable
    public static CS2PivotResourceAdapter findAdapter(@NonNull BaseCSResource csResource) {
        return (CS2PivotResourceAdapter)((Object)PivotUtil.getAdapter(CS2PivotResourceAdapter.class, (Notifier)csResource));
    }

    @NonNull
    public static CS2PivotResourceAdapter getAdapter(@NonNull BaseCSResource csResource, @Nullable MetaModelManager metaModelManager) {
        EList eAdapters = csResource.eAdapters();
        CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.findAdapter(csResource);
        if (adapter == null) {
            if (metaModelManager == null) {
                ClassLoader classLoader;
                metaModelManager = PivotUtil.findMetaModelManager((Resource)csResource);
                if (metaModelManager == null) {
                    metaModelManager = csResource.createMetaModelManager();
                    ResourceSet csResourceSet = csResource.getResourceSet();
                    if (csResourceSet != null) {
                        MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)csResourceSet, (MetaModelManager)metaModelManager);
                    }
                }
                if ((classLoader = csResource.getClass().getClassLoader()) != null) {
                    metaModelManager.addClassLoader(classLoader);
                }
            }
            adapter = new CS2PivotResourceAdapter(csResource, metaModelManager);
            eAdapters.add(adapter);
        }
        return adapter;
    }

    public CS2PivotResourceAdapter(@NonNull BaseCSResource csResource, @NonNull MetaModelManager metaModelManager) {
        super((Resource)csResource, metaModelManager);
        Map<Resource, Resource> cs2pivotResourceMap = this.computeCS2PivotResourceMap((Resource)csResource, metaModelManager);
        this.converter = csResource.createCS2Pivot(cs2pivotResourceMap, metaModelManager);
    }

    @NonNull
    public Map<Resource, Resource> computeCS2PivotResourceMap(@NonNull Resource csResource, @NonNull MetaModelManager metaModelManager) {
        EList contents;
        ResourceSet pivotResourceSet = metaModelManager.getTarget();
        HashMap<Resource, Resource> cs2pivotResourceMap = new HashMap<Resource, Resource>();
        Resource acsResource = csResource;
        URI uri = acsResource.getURI();
        if (uri != null && (contents = acsResource.getContents()).size() > 0 && contents.get(0) instanceof ModelElementCS) {
            URI pivotURI = PivotUtil.getPivotURI((URI)uri);
            Resource pivotResource = pivotResourceSet.getResource(pivotURI, false);
            if (pivotResource == null) {
                pivotResource = pivotResourceSet.createResource(pivotURI, "org.eclipse.ocl.examples.pivot");
            }
            cs2pivotResourceMap.put(acsResource, pivotResource);
        }
        return cs2pivotResourceMap;
    }

    public CS2Pivot getConverter() {
        return this.converter;
    }

    public Resource getPivotResource(@NonNull BaseCSResource csResource) {
        return this.converter.getPivotResource((Resource)csResource);
    }

    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type) || type == CS2PivotResourceAdapter.class;
    }

    public void refreshPivotMappings(@NonNull IDiagnosticConsumer diagnosticsConsumer) throws Exception {
        try {
            this.converter.update(diagnosticsConsumer);
        }
        catch (Exception e) {
            this.dispose();
            throw e;
        }
    }
}

