/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSI2PivotMapping
extends AdapterImpl
implements MetaModelManagerListener {
    private Map<String, String> csURI2aliasMap = new HashMap<String, String>();
    private Map<String, Element> csi2pivot = new HashMap<String, Element>();
    private int nextAlias = 0;

    @NonNull
    public static CSI2PivotMapping getAdapter(@NonNull MetaModelManager metaModelManager) {
        CSI2PivotMapping adapter2;
        EList eAdapters = metaModelManager.getPivotResourceSet().eAdapters();
        for (CSI2PivotMapping adapter2 : eAdapters) {
            if (!(adapter2 instanceof CSI2PivotMapping)) continue;
            return adapter2;
        }
        adapter2 = new CSI2PivotMapping();
        eAdapters.add(adapter2);
        return adapter2;
    }

    private CSI2PivotMapping() {
    }

    public void clear() {
        this.csURI2aliasMap.clear();
        this.csi2pivot.clear();
    }

    public Set<String> computeCSIs(Collection<? extends Resource> csResources) {
        HashSet<String> map = new HashSet<String>();
        for (Resource resource : csResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ModelElementCS)) continue;
                ModelElementCS csElement = (ModelElementCS)eObject;
                String csURI = this.getCSI(csElement);
                map.add(csURI);
            }
        }
        return map;
    }

    public Element get(ModelElementCS csElement) {
        String csi = this.getCSI(csElement);
        return this.csi2pivot.get(csi);
    }

    private String getCSI(ModelElementCS csElement) {
        String csi = csElement.getCsi();
        if (csi == null) {
            Resource csResource = csElement.eResource();
            String csResourceURI = csResource.getURI().toString();
            String fragment = csResource.getURIFragment((EObject)csElement);
            String alias = this.csURI2aliasMap.get(csResourceURI);
            if (alias == null) {
                alias = Integer.toString(this.nextAlias++);
                this.csURI2aliasMap.put(csResourceURI, alias);
            }
            csi = String.valueOf(alias) + '#' + fragment;
            csElement.setCsi(csi);
        }
        return csi;
    }

    public Map<String, Element> getMapping() {
        return this.csi2pivot;
    }

    public boolean isAdapterForType(Object type) {
        return type == CSI2PivotMapping.class;
    }

    public void metaModelManagerDisposed(@NonNull MetaModelManager metaModelManager) {
        this.clear();
    }

    public void put(ModelElementCS csElement, Element pivotElement) {
        String csi = this.getCSI(csElement);
        this.csi2pivot.put(csi, pivotElement);
    }

    public void update(Collection<? extends Resource> csResources) {
        this.csi2pivot.clear();
        HashSet<String> deadURIs = new HashSet<String>(this.csURI2aliasMap.keySet());
        for (Resource resource : csResources) {
            deadURIs.remove(resource.getURI().toString());
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ModelElementCS)) continue;
                ModelElementCS csElement = (ModelElementCS)eObject;
                Element pivotElement = csElement.getPivot();
                this.put(csElement, pivotElement);
            }
        }
    }
}

