/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.command.ExceptionHandlerReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.ObjectNode;

public class ExceptionHandlerEditHelper
extends ElementEditHelper {
    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new ExceptionHandlerReorientCommand(req);
    }

    protected boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        if (source != null && !(source instanceof ActivityNode)) {
            return false;
        }
        return target == null || target instanceof ActivityNode;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target, RequestParameterUtils.getSourceView((IEditCommandRequest)req), RequestParameterUtils.getTargetView((IEditCommandRequest)req))) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            if (source != null && !(source instanceof ExecutableNode)) {
                return UnexecutableCommand.INSTANCE;
            }
            return IdentityCommand.INSTANCE;
        }
        ExecutableNode proposedContainer = this.deduceContainer(req);
        if (proposedContainer == null) {
            return UnexecutableCommand.INSTANCE;
        }
        req.setContainer((EObject)proposedContainer);
        return new CreateRelationshipCommand(req);
    }

    protected ExecutableNode deduceContainer(CreateRelationshipRequest req) {
        EObject element = req.getSource();
        while (element != null) {
            if (element instanceof ExecutableNode) {
                return (ExecutableNode)element;
            }
            element = element.eContainer();
        }
        return null;
    }

    protected ICommand getConfigureCommand(ConfigureRequest req) {
        ConfigureElementCommand configureCommand = new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                ExceptionHandler element = (ExceptionHandler)req.getElementToConfigure();
                if (req.getParameter("CreateRelationshipRequest.source") != null) {
                    element.setProtectedNode(ExceptionHandlerEditHelper.this.getSourceObject(req));
                }
                if (req.getParameter("CreateRelationshipRequest.target") != null) {
                    element.setExceptionInput(ExceptionHandlerEditHelper.this.getTargetObject(req));
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
        return CompositeCommand.compose((ICommand)configureCommand, (ICommand)super.getConfigureCommand(req));
    }

    protected ExecutableNode getSourceObject(ConfigureRequest req) {
        Object result = req.getParameter("CreateRelationshipRequest.source");
        if (result instanceof ExecutableNode) {
            return (ExecutableNode)result;
        }
        return null;
    }

    protected ObjectNode getTargetObject(ConfigureRequest req) {
        Object result = req.getParameter("CreateRelationshipRequest.target");
        if (result instanceof ObjectNode) {
            return (ObjectNode)result;
        }
        return null;
    }
}

