/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.builder;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingStrategy;

public class DefaultSplittingStrategy
extends SplittingStrategy {
    private int headingCount;
    private int firstHeadingSplit = 2;
    private int headingLevel;
    private int splitLevel = 1;
    private String id;
    private String label;
    private String target;
    private final Set<String> targets = new HashSet<String>();

    @Override
    public void heading(int level, String id, String label) {
        if (level <= 0) {
            return;
        }
        this.label = label;
        this.id = id;
        this.headingLevel = level;
        ++this.headingCount;
        if (this.isSplit()) {
            this.target = this.computeSplitTarget();
        }
    }

    @Override
    public String getSplitTarget() {
        return this.target;
    }

    protected String computeSplitTarget() {
        String candidate = null;
        if (candidate == null) {
            if (this.label != null && this.label.length() > 0) {
                candidate = this.label.replaceAll("[^a-zA-Z0-9]+", "-");
            }
            if (candidate == null || candidate.length() == 0) {
                candidate = this.id != null ? this.id : "h" + this.headingLevel + "p" + this.headingCount;
            }
        }
        String computedTarget = candidate;
        int seed = 1;
        while (!this.targets.add(computedTarget)) {
            computedTarget = String.valueOf(candidate) + ++seed;
        }
        return String.valueOf(computedTarget) + ".html";
    }

    @Override
    public boolean isSplit() {
        return this.headingCount >= this.firstHeadingSplit && this.splitLevel >= this.headingLevel;
    }

    public int getFirstHeadingSplit() {
        return this.firstHeadingSplit;
    }

    public void setFirstHeadingSplit(int firstHeadingSplit) {
        this.firstHeadingSplit = firstHeadingSplit;
    }

    public int getSplitLevel() {
        return this.splitLevel;
    }

    public void setSplitLevel(int splitLevel) {
        this.splitLevel = splitLevel;
    }
}

