/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.template;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTemplatesContentProvider
implements IStructuredContentProvider {
    private static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.uml.diagram.wizards.templates";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_UML_FILE = "file";
    private static final String ATTRIBUTE_NOTATION_FILE = "notation_file";
    private static final String ATTRIBUTE_DI_FILE = "di_file";
    private static final String ATTRIBUTE_LANGUAGE = "language";
    private ModelTemplateDescription[] myTemplateDescriptions;

    public void dispose() {
    }

    private ModelTemplateDescription[] getTemplatesDescription() {
        if (this.myTemplateDescriptions == null) {
            IExtension[] extensions;
            ArrayList<ModelTemplateDescription> templates = new ArrayList<ModelTemplateDescription>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtension[] iExtensionArray = extensions = registry.getExtensionPoint(EXTENSION_POINT_ID).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                templates.addAll(this.processExtension(extension));
                ++n2;
            }
            this.myTemplateDescriptions = templates.toArray(new ModelTemplateDescription[templates.size()]);
        }
        return this.myTemplateDescriptions;
    }

    private Collection<ModelTemplateDescription> processExtension(IExtension extension) {
        ArrayList<ModelTemplateDescription> templates = new ArrayList<ModelTemplateDescription>();
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            ModelTemplateDescription template = new ModelTemplateDescription(configElement.getAttribute(ATTRIBUTE_NAME), extension.getContributor().getName(), configElement.getAttribute(ATTRIBUTE_UML_FILE), configElement.getAttribute(ATTRIBUTE_NOTATION_FILE), configElement.getAttribute(ATTRIBUTE_DI_FILE));
            template.setLanguage(configElement.getAttribute(ATTRIBUTE_LANGUAGE));
            templates.add(template);
            ++n2;
        }
        return templates;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            ArrayList<ModelTemplateDescription> result = new ArrayList<ModelTemplateDescription>();
            Object[] objectArray = (Object[])inputElement;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                if (next instanceof String) {
                    String diagramCategory = (String)next;
                    ModelTemplateDescription[] modelTemplateDescriptionArray = this.getTemplatesDescription();
                    int n3 = modelTemplateDescriptionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ModelTemplateDescription template = modelTemplateDescriptionArray[n4];
                        if (diagramCategory == null || diagramCategory.equals(template.getLanguage())) {
                            result.add(template);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TableViewer) {
            ((TableViewer)viewer).add(this.getElements(null));
        }
    }
}

