/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractTaskHandler
extends AbstractHandler {
    protected boolean recurse;
    protected boolean singleTask;
    private boolean filterBasedOnActiveTaskList;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part;
        boolean processed;
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (!(processed = this.process(event, selection)) && (part = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof TaskEditor) {
            selection = new StructuredSelection((Object)((TaskEditor)part).getTaskEditorInput().getTask());
            processed = this.process(event, selection);
        }
        return null;
    }

    private boolean process(ExecutionEvent event, ISelection selection) throws ExecutionException {
        boolean processed = false;
        if (selection instanceof IStructuredSelection) {
            Object[] items = ((IStructuredSelection)selection).toArray();
            if (this.singleTask) {
                if (items.length == 1 && items[0] instanceof ITask) {
                    processed |= this.process(event, items[0], false);
                }
            } else {
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    processed |= this.process(event, item, this.recurse);
                    ++n2;
                }
            }
        }
        return processed;
    }

    private boolean process(ExecutionEvent event, Object item, boolean recurse) throws ExecutionException {
        if (!(item instanceof IRepositoryElement)) {
            item = Platform.getAdapterManager().getAdapter(item, ITask.class);
        }
        if (item instanceof ITask) {
            this.execute(event, (ITask)item);
            return true;
        }
        if (item instanceof ITaskContainer && (recurse || !(item instanceof AbstractTask))) {
            this.execute(event, (ITaskContainer)item);
            return true;
        }
        return false;
    }

    protected void execute(ExecutionEvent event, ITaskContainer item) throws ExecutionException {
        for (ITask task : item.getChildren()) {
            if (this.filterBasedOnActiveTaskList && !AbstractTaskHandler.isVisibleInTaskList(item, task)) continue;
            this.process(event, task, true);
        }
    }

    public static boolean isVisibleInTaskList(ITaskContainer item, ITask task) {
        TaskListView taskListView = TaskListView.getFromActivePerspective();
        if (taskListView == null) {
            return false;
        }
        Set<AbstractTaskListFilter> filters = taskListView.getFilters();
        for (AbstractTaskListFilter filter : filters) {
            if (filter.select(item, task)) continue;
            return false;
        }
        return true;
    }

    protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
    }

    public boolean getFilterBasedOnActiveTaskList() {
        return this.filterBasedOnActiveTaskList;
    }

    protected void setFilterBasedOnActiveTaskList(boolean filterBasedOnActiveTaskList) {
        this.filterBasedOnActiveTaskList = filterBasedOnActiveTaskList;
    }
}

