/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.xbase.typesystem.conformance.IRawTypeHelper;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndNonNullResult;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@NonNullByDefault
public class RawTypeHelper
implements IRawTypeHelper {
    @Inject
    private TypesFactory factory;

    @Override
    public List<JvmType> getAllRawTypes(LightweightTypeReference reference, ResourceSet resourceSet) {
        List<JvmType> result = new RawTypeImplementation(this.factory).getAllRawTypes(reference, resourceSet);
        return result;
    }

    @Override
    public LightweightTypeReference getRawTypeReference(LightweightTypeReference reference, ResourceSet resourceSet) {
        LightweightTypeReference result = new RawTypeReferenceImplementation(this.factory).getRawTypeReference(reference, resourceSet);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RawTypeImplementation
    extends TypeReferenceVisitorWithParameterAndNonNullResult<ResourceSet, List<JvmType>> {
        private final TypesFactory factory;
        private Set<JvmType> visited = Sets.newHashSetWithExpectedSize((int)2);

        @Inject
        public RawTypeImplementation(TypesFactory factory) {
            this.factory = factory;
        }

        public List<JvmType> getAllRawTypes(LightweightTypeReference reference, ResourceSet resourceSet) {
            List<JvmType> result = reference.accept(this, resourceSet);
            return result;
        }

        @Override
        protected List<JvmType> doVisitTypeReference(LightweightTypeReference reference, ResourceSet resourceSet) {
            return Collections.emptyList();
        }

        @Override
        protected List<JvmType> doVisitCompoundTypeReference(CompoundTypeReference reference, ResourceSet resourceSet) {
            List<LightweightTypeReference> components = reference.getMultiTypeComponents();
            if (components.isEmpty()) {
                throw new IllegalStateException("Components may not be empty");
            }
            return this.collectRawTypes(components, resourceSet);
        }

        @Override
        protected List<JvmType> doVisitSynonymTypeReference(CompoundTypeReference reference, ResourceSet resourceSet) {
            List<LightweightTypeReference> components = reference.getMultiTypeComponents();
            if (components.isEmpty()) {
                throw new IllegalStateException("Components may not be empty");
            }
            return components.get(components.size() - 1).accept(this, resourceSet);
        }

        protected List<JvmType> collectRawTypes(List<LightweightTypeReference> references, ResourceSet resourceSet) {
            ArrayList result = Lists.newArrayList();
            for (LightweightTypeReference component : references) {
                result.addAll((Collection)component.accept(this, resourceSet));
            }
            return result;
        }

        @Override
        protected List<JvmType> doVisitArrayTypeReference(ArrayTypeReference reference, ResourceSet resourceSet) {
            ArrayList result;
            LightweightTypeReference componentType = reference.getComponentType();
            if (!componentType.isResolved()) {
                result = this.createObjectReference(resourceSet);
            } else {
                List<JvmType> rawComponentTypes = componentType.accept(this, resourceSet);
                result = Lists.newArrayListWithCapacity((int)rawComponentTypes.size());
                for (JvmType rawComponentType : rawComponentTypes) {
                    if (rawComponentType.eIsProxy() || !(rawComponentType instanceof JvmComponentType)) continue;
                    JvmArrayType arrayType = ((JvmComponentType)rawComponentType).getArrayType();
                    if (arrayType == null) {
                        arrayType = this.factory.createJvmArrayType();
                        arrayType.setComponentType((JvmComponentType)rawComponentType);
                    }
                    result.add(arrayType);
                }
            }
            return result;
        }

        @Override
        protected List<JvmType> doVisitParameterizedTypeReference(ParameterizedTypeReference reference, ResourceSet resourceSet) {
            JvmType type = reference.getType();
            if (!type.eIsProxy()) {
                if (type instanceof JvmTypeParameter) {
                    return this.getRawTypesFromConstraints(reference.getOwner(), (JvmTypeParameter)type, resourceSet);
                }
                return Collections.singletonList(type);
            }
            return Collections.emptyList();
        }

        @Override
        protected List<JvmType> doVisitWildcardTypeReference(WildcardTypeReference reference, ResourceSet resourceSet) {
            if (reference.isUnbounded()) {
                return this.createObjectReference(resourceSet);
            }
            List<LightweightTypeReference> upperBounds = reference.getUpperBounds();
            if (upperBounds.isEmpty()) {
                throw new IllegalStateException("UpperBounds may not be empty");
            }
            return this.collectRawTypes(upperBounds, resourceSet);
        }

        @Override
        protected List<JvmType> doVisitUnboundTypeReference(UnboundTypeReference reference, ResourceSet resourceSet) {
            LightweightTypeReference resolvedTo;
            List<LightweightBoundTypeArgument> hints = reference.getAllHints();
            if (!hints.isEmpty() && reference.resolveWithHints(hints) && (resolvedTo = reference.getResolvedTo()) != null) {
                return resolvedTo.accept(this, resourceSet);
            }
            JvmTypeParameter typeParameter = reference.getTypeParameter();
            return this.getRawTypesFromConstraints(reference.getOwner(), typeParameter, resourceSet);
        }

        protected List<JvmType> getRawTypesFromConstraints(ITypeReferenceOwner owner, JvmTypeParameter typeParameter, ResourceSet resourceSet) {
            EList constraints;
            if (this.visited.add((JvmType)typeParameter) && !(constraints = typeParameter.getConstraints()).isEmpty()) {
                ArrayList result = Lists.newArrayList();
                OwnedConverter converter = new OwnedConverter(owner);
                for (JvmTypeConstraint constraint : constraints) {
                    if (!(constraint instanceof JvmUpperBound) || constraint.getTypeReference() == null) continue;
                    result.addAll((Collection)converter.toLightweightReference(constraint.getTypeReference()).accept(this, resourceSet));
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
            return this.createObjectReference(resourceSet);
        }

        protected List<JvmType> createObjectReference(ResourceSet resourceSet) {
            URI objectURI = new ClassURIHelper().getFullURI(Object.class);
            JvmGenericType objectType = this.factory.createJvmGenericType();
            ((InternalEObject)objectType).eSetProxyURI(objectURI);
            objectType = (JvmType)EcoreUtil.resolve((EObject)objectType, (ResourceSet)resourceSet);
            return Collections.singletonList(objectType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RawTypeReferenceImplementation
    extends TypeReferenceVisitorWithParameterAndNonNullResult<ResourceSet, LightweightTypeReference> {
        private final TypesFactory factory;
        private Set<JvmType> visited = Sets.newHashSetWithExpectedSize((int)2);

        @Inject
        public RawTypeReferenceImplementation(TypesFactory factory) {
            this.factory = factory;
        }

        public LightweightTypeReference getRawTypeReference(LightweightTypeReference reference, ResourceSet resourceSet) {
            LightweightTypeReference result = reference.accept(this, resourceSet);
            return result;
        }

        @Override
        protected LightweightTypeReference doVisitTypeReference(LightweightTypeReference reference, ResourceSet resourceSet) {
            return reference;
        }

        @Override
        protected LightweightTypeReference doVisitCompoundTypeReference(CompoundTypeReference reference, ResourceSet resourceSet) {
            if (reference.isRawType()) {
                return reference;
            }
            CompoundTypeReference result = new CompoundTypeReference(reference.getOwner(), reference.isSynonym());
            this.enhanceCompoundReference(reference.getMultiTypeComponents(), result, resourceSet);
            return result;
        }

        @Override
        protected LightweightTypeReference doVisitSynonymTypeReference(CompoundTypeReference reference, ResourceSet resourceSet) {
            if (reference.isRawType()) {
                return reference;
            }
            List<LightweightTypeReference> components = reference.getMultiTypeComponents();
            return components.get(components.size() - 1).accept(this, resourceSet);
        }

        protected void enhanceCompoundReference(List<LightweightTypeReference> references, CompoundTypeReference result, ResourceSet resourceSet) {
            if (references.isEmpty()) {
                throw new IllegalStateException("References may not be empty");
            }
            for (LightweightTypeReference component : references) {
                result.addComponent(component.accept(this, resourceSet));
            }
        }

        @Override
        protected ArrayTypeReference doVisitArrayTypeReference(ArrayTypeReference reference, ResourceSet resourceSet) {
            if (reference.isRawType()) {
                return reference;
            }
            LightweightTypeReference componentType = reference.getComponentType();
            LightweightTypeReference rawComponentType = componentType.accept(this, resourceSet);
            return new ArrayTypeReference(reference.getOwner(), rawComponentType);
        }

        @Override
        protected LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference, ResourceSet resourceSet) {
            JvmType type = reference.getType();
            if (reference.isRawType() && !(type instanceof JvmTypeParameter)) {
                return reference;
            }
            if (type instanceof JvmTypeParameter) {
                return this.getRawTypeFromConstraints(reference.getOwner(), (JvmTypeParameter)type, resourceSet);
            }
            return new ParameterizedTypeReference(reference.getOwner(), type);
        }

        @Override
        protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference, ResourceSet resourceSet) {
            if (reference.isUnbounded()) {
                return reference.getUpperBoundSubstitute();
            }
            if (reference.getUpperBounds().size() == 1) {
                return reference.getUpperBoundSubstitute().accept(this, resourceSet);
            }
            CompoundTypeReference result = new CompoundTypeReference(reference.getOwner(), false);
            this.enhanceCompoundReference(reference.getUpperBounds(), result, resourceSet);
            return result;
        }

        protected LightweightTypeReference getRawTypeFromConstraints(ITypeReferenceOwner owner, JvmTypeParameter typeParameter, ResourceSet resourceSet) {
            EList constraints;
            if (this.visited.add((JvmType)typeParameter) && !(constraints = typeParameter.getConstraints()).isEmpty()) {
                OwnedConverter converter = new OwnedConverter(owner);
                if (constraints.size() > 1) {
                    CompoundTypeReference result = new CompoundTypeReference(owner, false);
                    for (JvmTypeConstraint constraint : constraints) {
                        JvmTypeReference typeReference;
                        if (!(constraint instanceof JvmUpperBound) || (typeReference = constraint.getTypeReference()) == null) continue;
                        result.addComponent(converter.toLightweightReference(typeReference).accept(this, resourceSet));
                    }
                    return result;
                }
                JvmTypeReference typeReference = ((JvmTypeConstraint)constraints.get(0)).getTypeReference();
                if (typeReference != null) {
                    LightweightTypeReference result = converter.toLightweightReference(typeReference).accept(this, resourceSet);
                    return result;
                }
            }
            return this.createObjectReference(owner, resourceSet);
        }

        protected LightweightTypeReference createObjectReference(ITypeReferenceOwner owner, ResourceSet resourceSet) {
            URI objectURI = new ClassURIHelper().getFullURI(Object.class);
            JvmGenericType objectType = this.factory.createJvmGenericType();
            ((InternalEObject)objectType).eSetProxyURI(objectURI);
            objectType = (JvmType)EcoreUtil.resolve((EObject)objectType, (ResourceSet)resourceSet);
            return new ParameterizedTypeReference(owner, (JvmType)objectType);
        }
    }
}

