/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.location;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.internal.location.RepositoryLocation;
import org.eclipse.emf.cdo.location.IRepositoryLocation;
import org.eclipse.emf.cdo.location.IRepositoryLocationManager;
import org.eclipse.net4j.util.container.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryLocationManager
extends Container<IRepositoryLocation>
implements IRepositoryLocationManager {
    private List<RepositoryLocation> repositoryLocations = new ArrayList<RepositoryLocation>();

    public RepositoryLocationManager() {
        this.activate();
    }

    public RepositoryLocation[] getElements() {
        return this.getRepositoryLocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryLocation[] getRepositoryLocations() {
        List<RepositoryLocation> list = this.repositoryLocations;
        synchronized (list) {
            return this.repositoryLocations.toArray(new RepositoryLocation[this.repositoryLocations.size()]);
        }
    }

    @Override
    public RepositoryLocation addRepositoryLocation(String connectorType, String connectorDescription, String repositoryName) {
        RepositoryLocation location = new RepositoryLocation(this, connectorType, connectorDescription, repositoryName);
        return this.addRepositoryLocation(location);
    }

    @Override
    public RepositoryLocation addRepositoryLocation(InputStream in) throws IOException {
        RepositoryLocation location = new RepositoryLocation(this, in);
        return this.addRepositoryLocation(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryLocation addRepositoryLocation(RepositoryLocation location) {
        List<RepositoryLocation> list = this.repositoryLocations;
        synchronized (list) {
            int pos = this.repositoryLocations.indexOf(location);
            if (pos != -1) {
                return this.repositoryLocations.get(pos);
            }
            this.repositoryLocations.add(location);
        }
        this.fireElementAddedEvent(location);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryLocation(RepositoryLocation location) {
        boolean removed;
        List<RepositoryLocation> list = this.repositoryLocations;
        synchronized (list) {
            removed = this.repositoryLocations.remove(location);
        }
        if (removed) {
            this.fireElementRemovedEvent(location);
        }
    }
}

