/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.edit.policies;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.usecase.command.CustomSubjectClassifierCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.SubjectClassifierCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.policies.UseCaseDiagramItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.usecase.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;

public class CustomUseCaseDiagramItemSemanticEditPolicy
extends UseCaseDiagramItemSemanticEditPolicy {
    public static final String SUBJECT_SEMANTIC_HINT = "Subject_SemanticHint";
    ArrayList<IHintedType> possibleSubject = new ArrayList();

    public CustomUseCaseDiagramItemSemanticEditPolicy() {
        this.possibleSubject.add(UMLElementTypes.CLASS);
        this.possibleSubject.add(UMLElementTypes.INTERFACE);
        this.possibleSubject.add(UMLElementTypes.COMPONENT);
        this.possibleSubject.add(UMLElementTypes.DATA_TYPE);
        this.possibleSubject.add(UMLElementTypes.STATE_MACHINE);
        this.possibleSubject.add(UMLElementTypes.SIGNAL);
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        EObject containerElement = req.getContainer();
        if (org.eclipse.papyrus.uml.diagram.usecase.providers.UMLElementTypes.Classifier_2015 == req.getElementType()) {
            ArrayList<ICommand> executableCommandCreation = new ArrayList<ICommand>();
            ArrayList<IHintedType> executableHTypeCreation = new ArrayList<IHintedType>();
            String preferenceSemanticHint = UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getString(SUBJECT_SEMANTIC_HINT);
            IHintedType semanticHint = null;
            if (req.getParameter(SUBJECT_SEMANTIC_HINT) != null || preferenceSemanticHint != null) {
                semanticHint = req.getParameter(SUBJECT_SEMANTIC_HINT) != null ? (IHintedType)req.getParameter(SUBJECT_SEMANTIC_HINT) : (IHintedType)ElementTypeRegistry.getInstance().getType(preferenceSemanticHint);
            }
            if (semanticHint != null) {
                CreateElementRequest createElementRequest = new CreateElementRequest(containerElement, semanticHint);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)containerElement);
                ICommand createCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
                if (createCommand.canExecute()) {
                    executableCommandCreation.add(createCommand);
                    executableHTypeCreation.add(semanticHint);
                }
            } else {
                int i = 0;
                while (i < this.possibleSubject.size()) {
                    IHintedType currentHType = this.possibleSubject.get(i);
                    CreateElementRequest createElementRequest = new CreateElementRequest(containerElement, (IElementType)currentHType);
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)containerElement);
                    ICommand createCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
                    if (createCommand.canExecute()) {
                        executableCommandCreation.add(createCommand);
                        executableHTypeCreation.add(currentHType);
                    }
                    ++i;
                }
            }
            if (executableCommandCreation.size() == 1) {
                return new ICommandProxy((ICommand)executableCommandCreation.get(0));
            }
            if (executableCommandCreation.size() > 1) {
                return new ICommandProxy((ICommand)new CustomSubjectClassifierCreateCommandTN(req, containerElement, executableHTypeCreation));
            }
            return this.getGEFWrapper((ICommand)new SubjectClassifierCreateCommandTN(req));
        }
        return super.getCreateCommand(req);
    }
}

