/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import org.eclipse.jgit.lib.ObjectId;

public class Utils {
    private static final String EMPTY_STRING = "";
    private static final char CR_CHAR = '\r';
    private static final char LF_CHAR = '\n';

    public static String getShortObjectId(ObjectId id) {
        return id.abbreviate(6).name();
    }

    public static String normalizeLineEndings(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder result = new StringBuilder();
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) == '\r') {
                if (i + 1 < length) {
                    if (s.charAt(i + 1) == '\n') {
                        result.append('\n');
                        ++i;
                    } else {
                        result.append('\n');
                    }
                } else {
                    result.append('\n');
                }
            } else {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }
}

