/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.common.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidgetInternalUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.table.common.messages.Messages;
import org.eclipse.papyrus.uml.table.common.provider.SortedFeaturesContentProvider;
import org.eclipse.papyrus.uml.table.common.widget.FilteredCheckboxTree;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsToShowDialog
extends SelectionDialog {
    private final ILabelProvider labelProvider;
    private final SortedFeaturesContentProvider contentProvider;
    private static final int DIALOG_WIDTH = 1000;
    private static final int DIALOG_HEIGHT = 600;
    private final Collection<ETypedElement> directFeatures;
    private final Collection<ENamedElement> additionalFeatures;
    private final Collection<ETypedElement> initialSelection;
    private FilteredTree directFeaturesTree;
    private FilteredTree additionnalFeaturesTree;
    private ViewerFilter additionalContentFilter;
    private final Map<Column, Boolean> defaultColumnsAndVisiblity;

    public ColumnsToShowDialog(Shell parentShell, Map<Column, Boolean> defaultColumnsAndVisibility, Collection<ETypedElement> features, Collection<ENamedElement> additionalFeatures, Collection<ETypedElement> initialSelection, ILabelProvider labelProvider, IContentProvider contentProvider) {
        super(parentShell);
        this.setTitle(Messages.ColumnsToShowDialog_SelecColumnsToShow);
        this.directFeatures = features;
        this.additionalFeatures = additionalFeatures;
        this.labelProvider = labelProvider;
        this.contentProvider = (SortedFeaturesContentProvider)contentProvider;
        this.initialSelection = initialSelection;
        this.additionalContentFilter = new AdditionalContentsFilter(initialSelection);
        this.defaultColumnsAndVisiblity = defaultColumnsAndVisibility;
    }

    public void create() {
        super.create();
        Composite parent = new Composite((Composite)this.getDialogArea(), 0);
        GridLayout layout = new GridLayout(2, true);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite defaultColumnPane = new Composite(parent, 0);
        defaultColumnPane.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        defaultColumnPane.setLayoutData((Object)data);
        Composite selectorPane = new Composite(parent, 0);
        selectorPane.setLayout((Layout)new GridLayout(2, false));
        selectorPane.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite selectedPane = new Composite(parent, 0);
        selectedPane.setLayout((Layout)new GridLayout(2, false));
        selectedPane.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDefaultColumnsSection(defaultColumnPane);
        this.createDirectFeaturesSection(selectorPane);
        this.createAdditionalFeaturesSection(selectedPane);
        this.getShell().pack();
    }

    protected void createDefaultColumnsSection(Composite selectorPane) {
        Composite featureComposite = new Composite(selectorPane, 2048);
        featureComposite.setLayout((Layout)new GridLayout(3, false));
        featureComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(featureComposite, 0);
        label.setText("Default Columns");
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        for (final Column current : this.defaultColumnsAndVisiblity.keySet()) {
            Button button = new Button(featureComposite, 32);
            button.setText(NatTableWidgetInternalUtils.getColumnName((Column)current));
            button.setSelection(this.defaultColumnsAndVisiblity.get(current).booleanValue());
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnsToShowDialog.this.defaultColumnsAndVisiblity.put(current, (Boolean)ColumnsToShowDialog.this.defaultColumnsAndVisiblity.get(current) == false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    protected Composite createButtonPanel(Composite parent) {
        Composite buttonsPanel = new Composite(parent, 0);
        GridLayout buttonPanelLayout = new GridLayout(2, true);
        buttonPanelLayout.marginWidth = 0;
        buttonPanelLayout.marginHeight = 0;
        buttonsPanel.setLayout((Layout)buttonPanelLayout);
        buttonsPanel.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        return buttonsPanel;
    }

    protected void createDirectFeaturesSection(Composite parent) {
        Composite featureComposite = new Composite(parent, 2048);
        featureComposite.setLayout((Layout)new GridLayout(1, false));
        featureComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(featureComposite, 0);
        label.setText(Messages.ColumnsToShowDialog_DirectFeatures);
        this.directFeaturesTree = new FilteredCheckboxTree(featureComposite, 2852, new PatternFilter());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.directFeaturesTree);
        this.directFeaturesTree.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.directFeaturesTree.getViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.directFeaturesTree.getViewer().setInput(this.directFeatures);
        ((ContainerCheckedTreeViewer)this.directFeaturesTree.getViewer()).setCheckedElements(this.initialSelection.toArray());
        Composite buttonsPanel = this.createButtonPanel(featureComposite);
        Button selectAllFeaturesButton = new Button(buttonsPanel, 0);
        selectAllFeaturesButton.setText(Messages.ColumnsToShowDialog_SelectAll);
        selectAllFeaturesButton.setToolTipText(Messages.ColumnsToShowDialog_SelectAllAvailablesFeatures);
        selectAllFeaturesButton.setLayoutData((Object)new GridData(4, 4, true, true));
        selectAllFeaturesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToShowDialog.this.selectAllDirectFeatures();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deselectAllFeaturesButton = new Button(buttonsPanel, 0);
        deselectAllFeaturesButton.setText(Messages.ColumnsToShowDialog_DeselectedAll);
        deselectAllFeaturesButton.setToolTipText(Messages.ColumnsToShowDialog_DeselecteAllAvailableFeatures);
        deselectAllFeaturesButton.setLayoutData((Object)new GridData(4, 4, true, true));
        deselectAllFeaturesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToShowDialog.this.deselectAllDirectFeatures();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createAdditionalFeaturesSection(Composite facetPane) {
        Composite facetComposite = new Composite(facetPane, 2048);
        facetComposite.setLayout((Layout)new GridLayout(1, true));
        facetComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(facetComposite, 0);
        label.setText(Messages.ColumnsToShowDialog_AdditionalFeatures);
        this.additionnalFeaturesTree = new FilteredCheckboxTree(facetComposite, 2850, new PatternFilter());
        this.additionnalFeaturesTree.getViewer().expandAll();
        this.additionnalFeaturesTree.getViewer().addFilter(this.additionalContentFilter);
        this.additionnalFeaturesTree.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.additionnalFeaturesTree.getViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.additionnalFeaturesTree.getViewer().setInput(this.additionalFeatures);
        ((ContainerCheckedTreeViewer)this.additionnalFeaturesTree.getViewer()).setCheckedElements(this.initialSelection.toArray());
        Composite allButtonsPanel = new Composite(facetComposite, 0);
        GridLayout buttonPanelLayout = new GridLayout(2, true);
        buttonPanelLayout.marginWidth = 0;
        buttonPanelLayout.marginHeight = 0;
        allButtonsPanel.setLayout((Layout)buttonPanelLayout);
        allButtonsPanel.setLayoutData((Object)new GridData(4, 4, false, false));
        final Button showAdvancedContents = new Button(allButtonsPanel, 32);
        showAdvancedContents.setText(Messages.ColumnsToShowDialog_AdvancedMode);
        showAdvancedContents.setToolTipText(Messages.ColumnsToShowDialog_ShowAllPossibilities);
        showAdvancedContents.setLayoutData((Object)new GridData(4, 4, true, true));
        showAdvancedContents.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreePath[] treePaths = ColumnsToShowDialog.this.additionnalFeaturesTree.getViewer().getExpandedTreePaths();
                if (showAdvancedContents.getSelection()) {
                    ColumnsToShowDialog.this.additionnalFeaturesTree.getViewer().removeFilter(ColumnsToShowDialog.this.additionalContentFilter);
                } else {
                    ColumnsToShowDialog.this.additionnalFeaturesTree.getViewer().addFilter(ColumnsToShowDialog.this.additionalContentFilter);
                }
                ColumnsToShowDialog.this.additionnalFeaturesTree.getViewer().setExpandedTreePaths(treePaths);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite buttonsPanel = this.createButtonPanel(allButtonsPanel);
        Button selectAllAdditionalFeaturesButton = new Button(buttonsPanel, 0);
        selectAllAdditionalFeaturesButton.setText(Messages.ColumnsToShowDialog_SelectAll);
        selectAllAdditionalFeaturesButton.setToolTipText(Messages.ColumnsToShowDialog_SelectAllAvailableAdditionalFeatures);
        selectAllAdditionalFeaturesButton.setLayoutData((Object)new GridData(4, 4, true, true));
        selectAllAdditionalFeaturesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToShowDialog.this.selectAllAdditionalFeatures();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deselectAllAdditionalFeaturesButton = new Button(buttonsPanel, 0);
        deselectAllAdditionalFeaturesButton.setText(Messages.ColumnsToShowDialog_DeselectAll);
        deselectAllAdditionalFeaturesButton.setToolTipText(Messages.ColumnsToShowDialog_DeselectAllAvailableAdditionalFeatures);
        deselectAllAdditionalFeaturesButton.setLayoutData((Object)new GridData(4, 4, true, true));
        deselectAllAdditionalFeaturesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsToShowDialog.this.deselectAllAdditionalFeatures();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void selectAllAdditionalFeatures() {
        ContainerCheckedTreeViewer viewer = (ContainerCheckedTreeViewer)this.additionnalFeaturesTree.getViewer();
        for (ENamedElement current : this.additionalFeatures) {
            viewer.setSubtreeChecked((Object)current, true);
        }
    }

    protected void deselectAllAdditionalFeatures() {
        ContainerCheckedTreeViewer viewer = (ContainerCheckedTreeViewer)this.additionnalFeaturesTree.getViewer();
        for (ENamedElement current : this.additionalFeatures) {
            viewer.setSubtreeChecked((Object)current, false);
        }
    }

    protected void selectAllDirectFeatures() {
        ContainerCheckedTreeViewer viewer = (ContainerCheckedTreeViewer)this.directFeaturesTree.getViewer();
        for (ETypedElement current : this.directFeatures) {
            viewer.setSubtreeChecked((Object)current, true);
        }
    }

    protected void deselectAllDirectFeatures() {
        ContainerCheckedTreeViewer viewer = (ContainerCheckedTreeViewer)this.directFeaturesTree.getViewer();
        for (ETypedElement current : this.directFeatures) {
            viewer.setSubtreeChecked((Object)current, false);
        }
    }

    public void pressOk() {
        this.okPressed();
    }

    protected void okPressed() {
        Collection<ETypedElement> selectedFeatures = this.getAllChechedElements(this.directFeaturesTree);
        Collection<ETypedElement> selectedAdditionalFeatures = this.getAllChechedElements(this.additionnalFeaturesTree);
        ArrayList<Collection<ETypedElement>> result = new ArrayList<Collection<ETypedElement>>();
        result.add(selectedFeatures);
        result.add(selectedAdditionalFeatures);
        this.setResult(result);
        super.okPressed();
    }

    protected Collection<ETypedElement> getAllChechedElements(FilteredTree tree) {
        TreeItem[] items;
        HashSet<ETypedElement> checkedElements = new HashSet<ETypedElement>();
        TreeViewer viewer = tree.getViewer();
        TreeItem[] treeItemArray = items = viewer.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getChecked() && (data = treeItem.getData()) instanceof ETypedElement) {
                checkedElements.add((ETypedElement)data);
            }
            if (treeItem.getChecked() || treeItem.getGrayed()) {
                checkedElements.addAll(this.getAllCheckedSubItems(treeItem));
            }
            ++n2;
        }
        return checkedElements;
    }

    protected Collection<ETypedElement> getAllCheckedSubItems(TreeItem item) {
        HashSet<ETypedElement> checkedElements = new HashSet<ETypedElement>();
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem current = treeItemArray[n2];
            if (!current.getGrayed() && current.getChecked() && (data = current.getData()) instanceof ETypedElement) {
                checkedElements.add((ETypedElement)data);
            }
            checkedElements.addAll(this.getAllCheckedSubItems(current));
            ++n2;
        }
        return checkedElements;
    }

    public Object[] getResult() {
        return super.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AdditionalContentsFilter
    extends ViewerFilter {
        private final Collection<?> initialSelection;

        public AdditionalContentsFilter(Collection<?> iniCollection) {
            this.initialSelection = iniCollection;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StereotypeFacet facet;
            if (element instanceof StereotypeFacet) {
                facet = (StereotypeFacet)element;
                for (StereotypePropertyElement el : facet.getStereotypePropertyElements()) {
                    if (!this.initialSelection.contains(el)) continue;
                    return true;
                }
            }
            if (element instanceof StereotypePropertyElement && this.initialSelection.contains(element)) {
                return true;
            }
            if (element instanceof FacetSet || element instanceof Facet || element instanceof FacetStructuralFeature) {
                if (element instanceof FacetSet) {
                    FacetSet set = (FacetSet)element;
                    TreeIterator iter = set.eAllContents();
                    while (iter.hasNext()) {
                        Object current = iter.next();
                        if (!(current instanceof FacetSet) && !(current instanceof Facet) && !(current instanceof FacetStructuralFeature) || !this.select(viewer, null, current)) continue;
                        return true;
                    }
                } else if (element instanceof Facet) {
                    facet = (Facet)element;
                    for (StereotypePropertyElement el : facet.getEStructuralFeatures()) {
                        if (!this.initialSelection.contains(el) && !(el instanceof StereotypePropertyElement)) continue;
                        return true;
                    }
                } else if (element instanceof FacetStructuralFeature && (this.initialSelection.contains(element) || element instanceof StereotypePropertyElement)) {
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

