/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.common.handler;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.dialog.CommandCreationProgressMonitorDialog;
import org.eclipse.papyrus.infra.table.common.editor.AbstractNattableEditor;
import org.eclipse.papyrus.infra.table.common.exceptions.ErrorInPastePreparationException;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.table.common.Activator;
import org.eclipse.papyrus.uml.table.common.messages.Messages;
import org.eclipse.papyrus.uml.table.common.provider.IPasteInTableCommandProvider;
import org.eclipse.papyrus.uml.table.common.provider.PasteInPapyrusTableCommandProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteInTableHandler
extends AbstractHandler {
    private boolean useProgressMonitorDialog = true;
    private final IPasteInTableCommandProvider provider = new PasteInPapyrusTableCommandProvider();
    private NatTableWidget widget = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.widget = (NatTableWidget)this.getITableWidget();
        PapyrusTableInstance papyrusTable = this.getPapyrusTable();
        if (papyrusTable != null) {
            String contents = this.getClipboardContents();
            if (this.useProgressMonitorDialog) {
                return this.executeWithProgressMonitorDialog(papyrusTable, contents);
            }
            return this.executeWithoutProgressMonitorDialog(papyrusTable, contents);
        }
        return null;
    }

    protected Object executeWithProgressMonitorDialog(final PapyrusTableInstance pTable, final String contents) {
        int returnCode = 0;
        final CommandCreationProgressMonitorDialog commandCreationDialog = new CommandCreationProgressMonitorDialog(Display.getCurrent().getActiveShell());
        final ProgressMonitorDialog commandExecutionProgressMonitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        commandCreationDialog.getProgressMonitor().setTaskName(Messages.PasteInTableHandler_PasteCreation);
        try {
            commandCreationDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor cancelProvider) throws InvocationTargetException, InterruptedException {
                    try {
                        Command cmd = PasteInTableHandler.this.provider.getPasteFromFromStringCommand(pTable, cancelProvider, commandExecutionProgressMonitor, contents, (INatTableWidget)PasteInTableHandler.this.widget);
                        commandCreationDialog.setCreatedCommand(cmd);
                    }
                    catch (ErrorInPastePreparationException e) {
                        commandCreationDialog.setCaughtException((Exception)((Object)e));
                        commandCreationDialog.setCreatedCommand(null);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        Exception e = commandCreationDialog.getCaughtException();
        if (e != null) {
            if (e instanceof ErrorInPastePreparationException) {
                NotificationBuilder.createErrorPopup((String)e.getMessage()).run();
            }
            return null;
        }
        returnCode = commandCreationDialog.getReturnCode();
        Command createdCommand = commandCreationDialog.getCreatedCommand();
        if (returnCode == 0) {
            if (createdCommand != null) {
                if (createdCommand.canExecute()) {
                    this.getEditingDomain().getCommandStack().execute(createdCommand);
                    this.manageCommandResult(createdCommand.getResult());
                } else {
                    NotificationBuilder.createErrorPopup((String)Messages.PasteInTableHandler_ThePasteCommandCantBeExecuted);
                }
            }
        } else if (returnCode == 1) {
            NotificationBuilder.createInfoPopup((String)Messages.PasteInTableHandler_PasteCancelled).run();
        }
        return null;
    }

    protected Object executeWithoutProgressMonitorDialog(PapyrusTableInstance pTable, String clipboardContents) {
        Command createdCommand;
        try {
            createdCommand = this.provider.getPasteFromFromStringCommand(pTable, null, null, clipboardContents, (INatTableWidget)this.widget);
        }
        catch (ErrorInPastePreparationException e) {
            System.out.println(e.getMessage());
            return null;
        }
        this.getEditingDomain().getCommandStack().execute(createdCommand);
        this.manageCommandResult(createdCommand.getResult());
        return null;
    }

    private AbstractNattableEditor getCurrentTableEditor() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof IMultiDiagramEditor) {
            part = ((IMultiDiagramEditor)part).getActiveEditor();
        }
        if (part instanceof AbstractNattableEditor) {
            return (AbstractNattableEditor)part;
        }
        return null;
    }

    protected PapyrusTableInstance getPapyrusTable() {
        AbstractNattableEditor part = this.getCurrentTableEditor();
        if (part != null) {
            return (PapyrusTableInstance)part.getAdapter(PapyrusTableInstance.class);
        }
        return null;
    }

    private INatTableWidget getITableWidget() {
        INatTableWidgetProvider provider;
        AbstractNattableEditor editor = this.getCurrentTableEditor();
        if (editor != null && (provider = (INatTableWidgetProvider)editor.getAdapter(INatTableWidgetProvider.class)) != null) {
            return provider.getNatTableWidget();
        }
        return null;
    }

    private String getClipboardContents() {
        String bufferSystem = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                bufferSystem = clipboard.getData(DataFlavor.stringFlavor).toString();
            }
            catch (UnsupportedFlavorException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return bufferSystem;
    }

    public boolean isEnabled() {
        return this.provider.isPasteEnabled(this.getPapyrusTable(), this.getClipboardContents(), this.getITableWidget());
    }

    private TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain domain = null;
        ServicesRegistry serviceRegistry = null;
        try {
            serviceRegistry = ServiceUtilsForActionHandlers.getInstance().getServiceRegistry();
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
        }
        try {
            domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("Editing Domain not found", (Throwable)e);
        }
        return domain;
    }

    public void setWithProgressMonitorDialog(boolean useProgressMonitorDialog) {
        this.useProgressMonitorDialog = useProgressMonitorDialog;
    }

    private Collection<IStatus> getInterestingIStatus(Collection<?> result) {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        for (Object current : result) {
            if (!(current instanceof IStatus)) continue;
            status.add((IStatus)current);
        }
        return status;
    }

    private void manageCommandResult(Collection<?> commandResult) {
        Collection<IStatus> status = this.getInterestingIStatus(commandResult);
        for (IStatus iStatus : status) {
            int severity = iStatus.getSeverity();
            if (severity != 4 && severity != 2) continue;
            Activator.getDefault().getLog().log(iStatus);
        }
    }
}

