/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.common.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.papyrus.infra.emf.utils.ENamedElementComparator;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.ProfileFacetSet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.table.common.Activator;
import org.eclipse.papyrus.uml.table.common.handler.SelectColumnsHandler;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAdditionColumnsPopupUpHandler
extends SelectColumnsHandler {
    private Collection<ETypedElement> newAdditionalContentsSelection;

    public SelectAdditionColumnsPopupUpHandler() {
        NatTableWidget widget = this.getTableWidget();
        PapyrusTableInstance papyrusTable = this.getPapyrusTable();
        if (widget != null && papyrusTable != null) {
            super.initField(widget, papyrusTable);
        }
    }

    public void setNewSelectedAdditionalFeature(Collection<ETypedElement> newSelection) {
        this.newAdditionalContentsSelection = newSelection;
    }

    public final Collection<FacetStructuralFeature> getApplicableStereotypePropertyElements() {
        PapyrusTableInstance pTable = this.getPapyrusTable();
        TreeSet<FacetSet> allFacetSets = new TreeSet<FacetSet>((Comparator<FacetSet>)new ENamedElementComparator());
        allFacetSets.addAll(this.getFacetSetsUsedInTheTable());
        allFacetSets.addAll(this.getAllAdditionalContents());
        HashSet stes = new HashSet();
        for (EObject current : pTable.getTable().getElements()) {
            if (!(current instanceof Element)) continue;
            stes.addAll(((Element)current).getAppliedStereotypes());
        }
        HashSet<Stereotype> allStereotypes = new HashSet<Stereotype>();
        for (Stereotype current : stes) {
            allStereotypes.add(current);
            allStereotypes.addAll(StereotypeUtil.getAllSuperStereotypes((Stereotype)current));
        }
        TreeSet<String> steQN = new TreeSet<String>();
        for (Stereotype ste : stes) {
            steQN.add(ste.getQualifiedName());
        }
        ArrayList<FacetStructuralFeature> features = new ArrayList<FacetStructuralFeature>();
        for (ENamedElement eNamedElement : allFacetSets) {
            if (!(eNamedElement instanceof ProfileFacetSet)) continue;
            TreeIterator iter = eNamedElement.eAllContents();
            while (iter.hasNext()) {
                String QN;
                EObject current = (EObject)iter.next();
                if (!(current instanceof StereotypeFacet) || !steQN.contains(QN = ((StereotypeFacet)current).getStereotypeQualifiedName())) continue;
                features.addAll((Collection<FacetStructuralFeature>)((StereotypeFacet)current).getStereotypePropertyElements());
            }
        }
        return features;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain domain = this.getEditingDomain();
        Command cmd = this.getCreateDestroyAdditonalFeatureColumnsCommand(this.getPapyrusTable(), this.getTableWidget(), this.newAdditionalContentsSelection);
        domain.getCommandStack().execute(cmd);
        return null;
    }

    public void addContributionItems(MenuManager manager) {
        ContributionItem item = new ContributionItem(){

            public void fill(Menu menu, int index) {
                final Collection<ETypedElement> initialSelection = SelectAdditionColumnsPopupUpHandler.this.getInitialAdditionalFeatureSelected();
                for (final StereotypePropertyElement stereotypePropertyElement : SelectAdditionColumnsPopupUpHandler.this.getApplicableStereotypePropertyElements()) {
                    final MenuItem menuItem = new MenuItem(menu, 32);
                    menuItem.setText(stereotypePropertyElement.getPropertyQualifiedName());
                    if (initialSelection.contains(stereotypePropertyElement)) {
                        menuItem.setSelection(true);
                    }
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            boolean toAdd = menuItem.getSelection();
                            ArrayList<ETypedElement> newSelection = new ArrayList<ETypedElement>();
                            newSelection.addAll(initialSelection);
                            if (toAdd) {
                                newSelection.add((ETypedElement)stereotypePropertyElement);
                            } else {
                                newSelection.remove(stereotypePropertyElement);
                            }
                            SelectAdditionColumnsPopupUpHandler.this.setNewSelectedAdditionalFeature(newSelection);
                            try {
                                SelectAdditionColumnsPopupUpHandler.this.execute(new ExecutionEvent());
                            }
                            catch (ExecutionException e1) {
                                Activator.log.error((Throwable)e1);
                            }
                        }
                    });
                }
                boolean bl = menu.getItemCount() != 0;
                menu.setEnabled(bl);
            }
        };
        Menu menu = manager.getMenu();
        if (menu != null) {
            menu.setEnabled(false);
        }
        manager.add((IContributionItem)item);
    }
}

