/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BooleanLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvalidLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NullLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NumberLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.SelfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.StringLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.labeling.BaseLabelProvider;

public class EssentialOCLLabelProvider
extends BaseLabelProvider {
    @Inject
    public EssentialOCLLabelProvider(@NonNull AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected void appendTemplateParameter(@NonNull StringBuilder s, TemplateParameterCS templateParameter) {
        this.appendName(s, (NamedElementCS)templateParameter);
    }

    protected void appendType(@NonNull StringBuilder s, Type type) {
        if (type instanceof CollectionTypeCS) {
            this.appendName(s, (Nameable)((CollectionTypeCS)type));
            s.append("(");
            this.appendType(s, (TypeRefCS)((CollectionTypeCS)type).getOwnedType());
            s.append(")");
        } else if (type instanceof TupleTypeCS) {
            this.appendName(s, (Nameable)((TupleTypeCS)type));
            s.append("Tuple(");
            String prefix = "";
            for (TuplePartCS part : ((TupleTypeCS)type).getOwnedParts()) {
                s.append(prefix);
                this.appendName(s, (NamedElementCS)part);
                s.append(" : ");
                this.appendType(s, (TypeRefCS)part.getOwnedType());
                prefix = ", ";
            }
            s.append(")");
        } else if (!(type instanceof NameExpCS)) {
            super.appendType(s, type);
        }
    }

    protected String text(BooleanLiteralExpCS ele) {
        return String.valueOf(ele.getName());
    }

    protected String text(ExpCS ele) {
        return "<<" + ele.eClass().getName() + ">>";
    }

    protected String text(InvalidLiteralExpCS ele) {
        return "invalid";
    }

    protected String text(InvocationExpCS ele) {
        NamedElement namedElement = ele.getNamedElement();
        return String.valueOf(namedElement != null ? namedElement.getName() : null);
    }

    protected String text(NameExpCS ele) {
        return String.valueOf(ele.getPathName().toString());
    }

    protected String text(NavigatingArgCS ele) {
        return "<" + String.valueOf(ele.getRole()).toLowerCase() + ">";
    }

    protected String text(NestedExpCS ele) {
        return "(   )";
    }

    protected String text(NullLiteralExpCS ele) {
        return "null";
    }

    protected String text(NumberLiteralExpCS ele) {
        return String.valueOf(ele.getName());
    }

    protected String image(OperatorCS ele) {
        return "/org.eclipse.ocl.edit/icons/full/obj16/OperationCallExp.gif";
    }

    protected String text(OperatorCS ele) {
        return String.valueOf(ele.getName());
    }

    protected String image(SelfExpCS ele) {
        return "/org.eclipse.ocl.edit/icons/full/obj16/VariableExp.gif";
    }

    protected String text(SelfExpCS ele) {
        return "self";
    }

    protected String text(StringLiteralExpCS ele) {
        return String.valueOf(ele.getName());
    }
}

