/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.parser.util.CharTable;

public class CharArrayObjectMap<T>
extends CharTable {
    public static final CharArrayObjectMap<?> EMPTY_MAP = new CharArrayObjectMap<Object>(0){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public List<char[]> toList() {
            return Collections.emptyList();
        }

        @Override
        public Object put(char[] key, int start, int length, Object value) {
            throw new UnsupportedOperationException();
        }
    };
    private Object[] valueTable = new Object[this.capacity()];

    public static <T> CharArrayObjectMap<T> emptyMap() {
        return EMPTY_MAP;
    }

    public CharArrayObjectMap(int initialSize) {
        super(initialSize);
    }

    public T put(char[] key, int start, int length, T value) {
        int i = this.addIndex(key, start, length);
        Object oldvalue = this.valueTable[i];
        this.valueTable[i] = value;
        return (T)oldvalue;
    }

    public final T put(char[] key, T value) {
        return this.put(key, 0, key.length, value);
    }

    public final T get(char[] key, int start, int length) {
        int i = this.lookup(key, start, length);
        if (i >= 0) {
            return (T)this.valueTable[i];
        }
        return null;
    }

    public final T get(char[] key) {
        return this.get(key, 0, key.length);
    }

    public final T getAt(int i) {
        if (i < 0 || i > this.currEntry) {
            return null;
        }
        return (T)this.valueTable[i];
    }

    public final T remove(char[] key, int start, int length) {
        int i = this.lookup(key, start, length);
        if (i < 0) {
            return null;
        }
        Object value = this.valueTable[i];
        if (i < this.currEntry) {
            System.arraycopy(this.valueTable, i + 1, this.valueTable, i, this.currEntry - i);
        }
        this.valueTable[this.currEntry] = null;
        this.removeEntry(i);
        return (T)value;
    }

    @Override
    public Object clone() {
        CharArrayObjectMap newTable = (CharArrayObjectMap)super.clone();
        newTable.valueTable = new Object[this.capacity()];
        System.arraycopy(this.valueTable, 0, newTable.valueTable, 0, this.valueTable.length);
        return newTable;
    }

    @Override
    protected void resize(int size) {
        Object[] oldValueTable = this.valueTable;
        this.valueTable = new Object[size];
        System.arraycopy(oldValueTable, 0, this.valueTable, 0, oldValueTable.length);
        super.resize(size);
    }

    @Override
    public void clear() {
        super.clear();
        int i = 0;
        while (i < this.capacity()) {
            this.valueTable[i] = null;
            ++i;
        }
    }

    @Override
    protected int partition(Comparator<Object> c, int p, int r) {
        char[] x = this.keyTable[p];
        Object temp = null;
        int i = p;
        int j = r;
        while (true) {
            if (c.compare(this.keyTable[j], x) > 0) {
                --j;
                continue;
            }
            if (i < j) {
                while (c.compare(this.keyTable[i], x) < 0) {
                    ++i;
                }
            }
            if (i >= j) break;
            temp = this.keyTable[j];
            this.keyTable[j] = this.keyTable[i];
            this.keyTable[i] = temp;
            temp = this.valueTable[j];
            this.valueTable[j] = this.valueTable[i];
            this.valueTable[i] = temp;
        }
        return j;
    }

    public Object[] valueArray() {
        Object[] values = new Object[this.size()];
        System.arraycopy(this.valueTable, 0, values, 0, values.length);
        return values;
    }

    public Object[] valueArray(Class<?> clazz) {
        Object[] values = (Object[])Array.newInstance(clazz, this.size());
        System.arraycopy(this.valueTable, 0, values, 0, values.length);
        return values;
    }
}

