/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICMacroEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryNameKey;

public class SettingsSet {
    public static final int READ_ONLY = 1;
    public static final int WRITABLE = 2;
    private SettingLevel[] fLevels;

    public SettingsSet(int num) {
        this.fLevels = new SettingLevel[num];
        int i = 0;
        while (i < num) {
            this.fLevels[i] = new SettingLevel();
            ++i;
        }
    }

    public SettingLevel[] getLevels() {
        return (SettingLevel[])this.fLevels.clone();
    }

    public void adjustOverrideState() {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < this.fLevels.length) {
            SettingLevel level = this.fLevels[i];
            if (level.isOverrideSupported() && level.fOverrideSet != null) {
                set.addAll(level.fOverrideSet);
            }
            this.adjustOverrideState(this.fLevels[i], set);
            ++i;
        }
    }

    private void adjustOverrideState(SettingLevel level, Set<String> overridenSet) {
        EntryInfo[] entryInfoArray = level.getInfos();
        int n = entryInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryInfo info = entryInfoArray[n2];
            if (overridenSet.add(info.getEntry().getName())) {
                info.makeOverridden(false);
            } else {
                info.makeOverridden(true);
            }
            ++n2;
        }
    }

    public ICLanguageSettingEntry[] getEntries() {
        return this.getEntries(3);
    }

    public ICLanguageSettingEntry[] getEntries(int types) {
        this.adjustOverrideState();
        ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>();
        SettingLevel[] settingLevelArray = this.fLevels;
        int n = this.fLevels.length;
        int n2 = 0;
        while (n2 < n) {
            SettingLevel sl = settingLevelArray[n2];
            if (this.isCompatible(sl, types)) {
                this.getEntries(sl, entries);
            }
            ++n2;
        }
        return entries.toArray(new ICLanguageSettingEntry[entries.size()]);
    }

    private void getEntries(SettingLevel level, List<ICLanguageSettingEntry> list) {
        EntryInfo[] entryInfoArray = level.getInfos();
        int n = entryInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryInfo info = entryInfoArray[n2];
            if (!info.isOverridden()) {
                list.add(info.getEntry());
            }
            ++n2;
        }
    }

    private boolean isCompatible(SettingLevel level, int types) {
        if ((types & 1) == 0 && level.isReadOnly()) {
            return false;
        }
        return (types & 2) != 0 || level.isReadOnly();
    }

    private int getWritableLevelNum() {
        int i = 0;
        while (i < this.fLevels.length) {
            if (!this.fLevels[i].isReadOnly()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getOverrideLevelNum() {
        int i = 0;
        while (i < this.fLevels.length) {
            if (this.fLevels[i].isOverrideSupported()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void applyEntries(ICLanguageSettingEntry[] entries) {
        SettingLevel level;
        HashMap<EntryNameKey, Object[]> map = this.getEntryLevelMap(3);
        HashMap mapCopy = (HashMap)map.clone();
        Map[] clearedInfos = new Map[this.fLevels.length];
        int i = 0;
        while (i < this.fLevels.length) {
            if (!this.fLevels[i].isReadOnly()) {
                clearedInfos[i] = this.fLevels[i].clearAndGetMap();
            }
            ++i;
        }
        int writableLevel = this.getWritableLevelNum();
        int i2 = 0;
        while (i2 < entries.length) {
            int levelNum;
            Integer levelInteger;
            ICLanguageSettingEntry entry = entries[i2];
            EntryNameKey key = new EntryNameKey(entry);
            Object[] o = map.get(key);
            if (o != null && SettingsSet.valueMatches(entry, o[1])) {
                mapCopy.remove(key);
                levelInteger = (Integer)o[0];
                if (!entry.isBuiltIn()) {
                    levelInteger = null;
                }
            } else {
                levelInteger = null;
            }
            int n = levelNum = levelInteger != null ? levelInteger : writableLevel;
            if (levelNum >= 0 && !(level = this.fLevels[levelNum]).isReadOnly()) {
                EntryInfo info;
                Map clearedInfo = clearedInfos[levelNum];
                Object customInfo = null;
                if (clearedInfo != null && (info = (EntryInfo)clearedInfo.get(key)) != null && entry.equalsByContents(info.getEntry())) {
                    customInfo = info.getCustomInfo();
                }
                level.addEntry(entry, customInfo);
            }
            ++i2;
        }
        int overrideLevel = this.getOverrideLevelNum();
        if (overrideLevel >= 0 && (level = this.fLevels[overrideLevel]).isOverrideSupported() && !mapCopy.isEmpty()) {
            for (EntryNameKey enk : mapCopy.keySet()) {
                String str;
                ICSettingEntry e = enk.getEntry();
                if ((e.getFlags() & 1) == 0 || (str = e.getName()) == null) continue;
                level.addOverrideName(str);
            }
        }
        this.adjustOverrideState();
    }

    public HashMap<EntryNameKey, Object[]> getEntryLevelMap(int types) {
        HashMap<EntryNameKey, Object[]> map = new HashMap<EntryNameKey, Object[]>();
        int i = 0;
        while (i < this.fLevels.length) {
            if (this.isCompatible(this.fLevels[i], types)) {
                this.addLevelInfoToMap(this.fLevels[i], i, map);
            }
            ++i;
        }
        return map;
    }

    private void addLevelInfoToMap(SettingLevel level, int l, Map<EntryNameKey, Object[]> map) {
        EntryInfo[] entryInfoArray = level.getInfos();
        int n = entryInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryInfo info = entryInfoArray[n2];
            EntryNameKey key = info.getContentsKey();
            if (!map.containsKey(key)) {
                map.put(key, new Object[]{new Integer(l), info.getEntry()});
            }
            ++n2;
        }
    }

    private static boolean valueMatches(ICLanguageSettingEntry e, Object o) {
        if (!(e instanceof ICMacroEntry)) {
            return true;
        }
        if (!(o instanceof ICMacroEntry)) {
            return false;
        }
        String s1 = e.getValue();
        String s2 = ((ICMacroEntry)o).getValue();
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static class EntryInfo {
        private ICLanguageSettingEntry fEntry;
        private EntryNameKey fNameKey;
        private boolean fIsOverRidden;
        private Object fCustomInfo;

        private EntryInfo(ICLanguageSettingEntry entry, Object customInfo) {
            this.fEntry = entry;
            this.fCustomInfo = customInfo;
        }

        public EntryNameKey getContentsKey() {
            if (this.fNameKey == null) {
                this.fNameKey = new EntryNameKey(this.fEntry);
            }
            return this.fNameKey;
        }

        private void makeOverridden(boolean overridden) {
            this.fIsOverRidden = overridden;
        }

        public ICLanguageSettingEntry getEntry() {
            return this.fEntry;
        }

        public boolean isOverridden() {
            return this.fIsOverRidden;
        }

        public Object getCustomInfo() {
            return this.fCustomInfo;
        }
    }

    public class SettingLevel {
        private int fFlagsToSet;
        private int fFlagsToClear;
        private boolean fIsReadOnly;
        private boolean fIsOverrideSupported;
        private LinkedHashMap<EntryNameKey, EntryInfo> fEntries = new LinkedHashMap();
        HashSet<String> fOverrideSet;
        private Object fContext;

        private SettingLevel() {
        }

        public boolean isReadOnly() {
            return this.fIsReadOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.fIsReadOnly = readOnly;
        }

        public boolean isOverrideSupported() {
            return this.fIsOverrideSupported;
        }

        public void setOverrideSupported(boolean supported) {
            this.fIsOverrideSupported = supported;
        }

        public void setFlagsToSet(int flags) {
            this.fFlagsToSet = flags;
        }

        public boolean containsOverrideInfo() {
            return this.fOverrideSet != null;
        }

        public void setFlagsToClear(int flags) {
            this.fFlagsToClear = flags;
        }

        public int getFlagsToSet() {
            return this.fFlagsToSet;
        }

        public int getFlagsToClear() {
            return this.fFlagsToClear;
        }

        public int getFlags(int baseFlags) {
            return (baseFlags | this.fFlagsToSet) & ~this.fFlagsToClear;
        }

        public Set<String> getOverrideSet() {
            if (this.fOverrideSet != null) {
                return (HashSet)this.fOverrideSet.clone();
            }
            return new HashSet<String>();
        }

        public void addEntries(ICLanguageSettingEntry[] entries) {
            if (entries != null) {
                int i = 0;
                while (i < entries.length) {
                    this.addEntry(entries[i]);
                    ++i;
                }
            }
        }

        public void addEntries(List<ICLanguageSettingEntry> list) {
            for (ICLanguageSettingEntry se : list) {
                this.addEntry(se);
            }
        }

        public void addEntry(ICLanguageSettingEntry entry) {
            this.addEntry(entry, null);
        }

        public void addEntry(ICLanguageSettingEntry entry, Object customInfo) {
            entry = CDataUtil.createEntry(entry, this.fFlagsToSet, this.fFlagsToClear);
            EntryInfo info = new EntryInfo(entry, customInfo);
            this.fEntries.put(info.getContentsKey(), info);
        }

        public void addOverrideName(String name) {
            if (this.fOverrideSet == null) {
                this.fOverrideSet = new HashSet();
            }
            this.fOverrideSet.add(name);
        }

        public void addOverrideNameSet(Set<String> set) {
            if (set == null) {
                return;
            }
            if (this.fOverrideSet != null) {
                this.fOverrideSet.addAll(set);
            } else if (set.size() != 0) {
                this.fOverrideSet = new HashSet<String>(set);
            }
        }

        public void removeOverrideName(String name) {
            if (this.fOverrideSet == null) {
                return;
            }
            this.fOverrideSet.remove(name);
            if (this.fOverrideSet.size() == 0) {
                this.fOverrideSet = null;
            }
        }

        public void clear() {
            this.fEntries.clear();
            this.fOverrideSet = null;
        }

        public Map<EntryNameKey, EntryInfo> clearAndGetMap() {
            LinkedHashMap<EntryNameKey, EntryInfo> map = this.fEntries;
            this.fEntries = new LinkedHashMap();
            this.fOverrideSet = null;
            return map;
        }

        public EntryInfo[] getInfos() {
            return this.fEntries.values().toArray(new EntryInfo[this.fEntries.size()]);
        }

        public ICLanguageSettingEntry[] getEntries() {
            List<ICLanguageSettingEntry> list = this.getEntriesList(false);
            return list.toArray(new ICLanguageSettingEntry[list.size()]);
        }

        public ICLanguageSettingEntry[] getEntries(boolean includeOverridden) {
            List<ICLanguageSettingEntry> list = this.getEntriesList(includeOverridden);
            return list.toArray(new ICLanguageSettingEntry[list.size()]);
        }

        public List<ICLanguageSettingEntry> getEntriesList(boolean includeOverridden) {
            EntryInfo[] infos;
            ArrayList<ICLanguageSettingEntry> list = new ArrayList<ICLanguageSettingEntry>();
            EntryInfo[] entryInfoArray = infos = this.getInfos();
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                EntryInfo info = entryInfoArray[n2];
                if (includeOverridden || !info.isOverridden()) {
                    list.add(info.getEntry());
                }
                ++n2;
            }
            return list;
        }

        public Object getContext() {
            return this.fContext;
        }

        public void setContext(Object context) {
            this.fContext = context;
        }
    }
}

