/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScopeMapper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.core.runtime.CoreException;

public class CPPNamespaceScope
extends CPPScope
implements ICPPInternalNamespaceScope {
    private static final ICPPInternalNamespaceScope[] NO_NAMESPACE_SCOPES = new ICPPInternalNamespaceScope[0];
    private List<ICPPUsingDirective> fUsingDirectives;
    private boolean fIsInline;
    private boolean fIsInlineInitialized;
    private ICPPNamespaceScope[] fEnclosingNamespaceSet;
    private List<ICPPASTNamespaceDefinition> fInlineNamespaceDefinitions;
    private ICPPInternalNamespaceScope[] fInlineNamespaces;

    public CPPNamespaceScope(IASTNode physicalNode) {
        super(physicalNode);
    }

    @Override
    public EScopeKind getKind() {
        if (this.getPhysicalNode() instanceof IASTTranslationUnit) {
            return EScopeKind.eGlobal;
        }
        return EScopeKind.eNamespace;
    }

    @Override
    public ICPPUsingDirective[] getUsingDirectives() {
        this.initUsingDirectives();
        this.populateCache();
        return this.fUsingDirectives.toArray(new ICPPUsingDirective[this.fUsingDirectives.size()]);
    }

    private void initUsingDirectives() {
        if (this.fUsingDirectives == null) {
            this.fUsingDirectives = new ArrayList<ICPPUsingDirective>(1);
            ICPPInternalNamespaceScope[] iCPPInternalNamespaceScopeArray = this.getIndexInlineNamespaces();
            int n = iCPPInternalNamespaceScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPInternalNamespaceScope inline = iCPPInternalNamespaceScopeArray[n2];
                if (!(inline instanceof CPPNamespaceScope)) {
                    this.fUsingDirectives.add(new CPPScopeMapper.InlineNamespaceDirective(this, inline));
                }
                ++n2;
            }
        }
    }

    @Override
    public void addUsingDirective(ICPPUsingDirective directive) {
        this.initUsingDirectives();
        this.fUsingDirectives.add(directive);
    }

    @Override
    public IName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof ICPPASTNamespaceDefinition) {
            return ((ICPPASTNamespaceDefinition)node).getName();
        }
        return null;
    }

    public IScope findNamespaceScope(IIndexScope scope) {
        final String[] qname = CPPVisitor.getQualifiedName(scope.getScopeBinding());
        final IScope[] result = new IScope[1];
        ASTVisitor visitor = new ASTVisitor(){
            private int depth = 0;
            {
                this.shouldVisitDeclarations = true;
                this.shouldVisitNamespaces = true;
            }

            @Override
            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof ICPPASTLinkageSpecification) {
                    return 3;
                }
                return 1;
            }

            @Override
            public int visit(ICPPASTNamespaceDefinition namespace) {
                String name = namespace.getName().toString();
                if (name.length() == 0) {
                    return 3;
                }
                if (qname[this.depth].equals(name)) {
                    if (++this.depth == qname.length) {
                        result[0] = namespace.getScope();
                        return 2;
                    }
                    return 3;
                }
                return 1;
            }

            @Override
            public int leave(ICPPASTNamespaceDefinition namespace) {
                if (namespace.getName().getLookupKey().length > 0) {
                    --this.depth;
                }
                return 3;
            }
        };
        this.getPhysicalNode().accept(visitor);
        return result[0];
    }

    @Override
    public void addName(IASTName name) {
        if (name instanceof ICPPASTQualifiedName && !this.canDenoteNamespaceMember((ICPPASTQualifiedName)name)) {
            return;
        }
        super.addName(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canDenoteNamespaceMember(ICPPASTQualifiedName name) {
        IScope scope = this;
        IASTName[] segments = name.getNames();
        try {
            int i = segments.length - 1;
            while (true) {
                if (--i < 0) {
                    if (name.isFullyQualified() && scope != null) {
                        return ASTInternal.getPhysicalNodeOfScope(scope) instanceof IASTTranslationUnit;
                    }
                    return true;
                }
                if (scope == null) {
                    return false;
                }
                IName scopeName = scope.getScopeName();
                if (scopeName == null) {
                    return false;
                }
                IASTName segmentName = segments[i];
                if (segmentName instanceof ICPPASTTemplateId || !CharArrayUtils.equals(scopeName.getSimpleID(), segmentName.getSimpleID())) {
                    return false;
                }
                scope = scope.getParent();
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    @Override
    public boolean isInlineNamepace() {
        if (!this.fIsInlineInitialized) {
            this.fIsInline = this.computeIsInline();
            this.fIsInlineInitialized = true;
        }
        return this.fIsInline;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean computeIsInline() {
        IASTNode node = this.getPhysicalNode();
        if (!(node instanceof ICPPASTNamespaceDefinition)) {
            return false;
        }
        if (((ICPPASTNamespaceDefinition)node).isInline()) {
            return true;
        }
        IASTTranslationUnit tu = node.getTranslationUnit();
        if (tu == null) return false;
        IIndex index = tu.getIndex();
        IIndexFileSet fileSet = tu.getASTFileSet();
        if (index == null) return false;
        if (fileSet == null) return false;
        fileSet = fileSet.invert();
        ICPPNamespace nsBinding = this.getNamespaceIndexBinding(index);
        if (nsBinding == null) return false;
        if (!nsBinding.isInline()) return false;
        try {
            IIndexName[] names;
            IIndexName[] iIndexNameArray = names = index.findDefinitions(nsBinding);
            int n = names.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IIndexName name = iIndexNameArray[n2];
                if (name.isInlineNamespaceDefinition() && fileSet.contains(name.getFile())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return false;
    }

    @Override
    public ICPPNamespaceScope[] getEnclosingNamespaceSet() {
        if (this.fEnclosingNamespaceSet == null) {
            this.fEnclosingNamespaceSet = CPPNamespaceScope.computeEnclosingNamespaceSet(this);
            return this.fEnclosingNamespaceSet;
        }
        return this.fEnclosingNamespaceSet;
    }

    @Override
    public ICPPInternalNamespaceScope[] getInlineNamespaces() {
        if (this.getKind() == EScopeKind.eLocal) {
            return NO_NAMESPACE_SCOPES;
        }
        if (this.fInlineNamespaces == null) {
            this.fInlineNamespaces = this.computeInlineNamespaces();
        }
        return this.fInlineNamespaces;
    }

    ICPPInternalNamespaceScope[] computeInlineNamespaces() {
        this.populateCache();
        HashSet<ICPPInternalNamespaceScope> result = null;
        if (this.fInlineNamespaceDefinitions != null) {
            result = new HashSet<ICPPInternalNamespaceScope>(this.fInlineNamespaceDefinitions.size());
            for (ICPPASTNamespaceDefinition nsdef : this.fInlineNamespaceDefinitions) {
                IScope scope = nsdef.getScope();
                if (!(scope instanceof ICPPInternalNamespaceScope)) continue;
                result.add((ICPPInternalNamespaceScope)scope);
            }
        }
        ICPPInternalNamespaceScope[] iCPPInternalNamespaceScopeArray = this.getIndexInlineNamespaces();
        int n = iCPPInternalNamespaceScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPInternalNamespaceScope inline = iCPPInternalNamespaceScopeArray[n2];
            if (result == null) {
                result = new HashSet();
            }
            result.add(inline);
            ++n2;
        }
        if (result == null) {
            return NO_NAMESPACE_SCOPES;
        }
        return result.toArray(new ICPPInternalNamespaceScope[result.size()]);
    }

    private ICPPInternalNamespaceScope[] getIndexInlineNamespaces() {
        IASTTranslationUnit tu = this.getPhysicalNode().getTranslationUnit();
        if (tu instanceof CPPASTTranslationUnit) {
            CPPASTTranslationUnit cpptu = (CPPASTTranslationUnit)tu;
            IIndex index = tu.getIndex();
            if (index != null) {
                IScope[] inlineScopes = null;
                ICPPNamespace namespace = this.getNamespaceIndexBinding(index);
                try {
                    if (namespace != null) {
                        ICPPNamespaceScope scope = namespace.getNamespaceScope();
                        inlineScopes = scope.getInlineNamespaces();
                    } else if (this.getKind() == EScopeKind.eGlobal) {
                        inlineScopes = index.getInlineNamespaces();
                    }
                }
                catch (CoreException coreException) {}
                if (inlineScopes != null) {
                    ArrayList<ICPPInternalNamespaceScope> result = null;
                    ICPPNamespaceScope[] iCPPNamespaceScopeArray = inlineScopes;
                    int n = inlineScopes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IScope scope = iCPPNamespaceScopeArray[n2];
                        if (scope instanceof IIndexScope) {
                            scope = cpptu.mapToASTScope((IIndexScope)scope);
                        }
                        if (scope instanceof ICPPInternalNamespaceScope) {
                            if (result == null) {
                                result = new ArrayList<ICPPInternalNamespaceScope>();
                            }
                            result.add((ICPPInternalNamespaceScope)scope);
                        }
                        ++n2;
                    }
                    if (result != null) {
                        return result.toArray(new ICPPInternalNamespaceScope[result.size()]);
                    }
                }
            }
        }
        return NO_NAMESPACE_SCOPES;
    }

    public void addInlineNamespace(ICPPASTNamespaceDefinition nsDef) {
        if (this.fInlineNamespaceDefinitions == null) {
            this.fInlineNamespaceDefinitions = new ArrayList<ICPPASTNamespaceDefinition>();
        }
        this.fInlineNamespaceDefinitions.add(nsDef);
    }

    public static ICPPNamespaceScope[] computeEnclosingNamespaceSet(ICPPInternalNamespaceScope nsScope) {
        if (nsScope.isInlineNamepace()) {
            try {
                IScope parent = nsScope.getParent();
                if (parent instanceof ICPPInternalNamespaceScope) {
                    return ((ICPPInternalNamespaceScope)parent).getEnclosingNamespaceSet();
                }
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        HashSet<ICPPInternalNamespaceScope> result = new HashSet<ICPPInternalNamespaceScope>();
        result.add(nsScope);
        CPPNamespaceScope.addInlineNamespaces(nsScope, result);
        return result.toArray(new ICPPNamespaceScope[result.size()]);
    }

    private static void addInlineNamespaces(ICPPInternalNamespaceScope nsScope, Set<ICPPInternalNamespaceScope> result) {
        ICPPInternalNamespaceScope[] inlineNss;
        ICPPInternalNamespaceScope[] iCPPInternalNamespaceScopeArray = inlineNss = nsScope.getInlineNamespaces();
        int n = inlineNss.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPInternalNamespaceScope inlineNs = iCPPInternalNamespaceScopeArray[n2];
            if (result.add(inlineNs)) {
                CPPNamespaceScope.addInlineNamespaces(inlineNs, result);
            }
            ++n2;
        }
    }
}

