/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CreateElementInTUOperation;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IProject;

public class CreateIncludeOperation
extends CreateElementInTUOperation {
    protected String fIncludeName;
    protected boolean fIsStandard;

    public CreateIncludeOperation(String includeName, boolean isStd, ITranslationUnit parentElement) {
        super(parentElement);
        this.fIsStandard = isStd;
        this.fIncludeName = includeName;
    }

    @Override
    protected ICElement generateResultHandle() {
        return this.getTranslationUnit().getInclude(this.fIncludeName);
    }

    @Override
    public String getMainTaskName() {
        return "operation.createIncludeProgress";
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            ITranslationUnit cu = this.getTranslationUnit();
            IInclude[] includes = cu.getIncludes();
            if (includes.length > 0) {
                this.createAfter(includes[includes.length - 1]);
                return;
            }
        }
        catch (CModelException cModelException) {}
    }

    @Override
    public ICModelStatus verify() {
        ICModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IProject project = this.getParentElement().getCProject().getProject();
        if (CConventions.validateIncludeName(project, this.fIncludeName).getSeverity() == 4) {
            return new CModelStatus(983, this.fIncludeName);
        }
        return CModelStatus.VERIFIED_OK;
    }

    @Override
    protected String generateElement(ITranslationUnit unit) throws CModelException {
        StringBuffer sb = new StringBuffer();
        sb.append("#include ");
        if (this.fIsStandard) {
            sb.append('<');
        } else {
            sb.append('\"');
        }
        sb.append(this.fIncludeName);
        if (this.fIsStandard) {
            sb.append('>');
        } else {
            sb.append('\"');
        }
        sb.append(Util.LINE_SEPARATOR);
        return sb.toString();
    }
}

