/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class GitHubImages {
    private static final String NAME_PREFIX = "org.eclipse.mylyn.github.ui";
    private static final String ICONS_PATH = "icons/";
    private static final String PATH_OBJ = "icons/obj16/";
    private static ImageRegistry manager;
    public static final String GITHUB_LOGO_OBJ = "org.eclipse.mylyn.github.uiOBJ_GITHUB_LOGO";
    public static final String GITHUB_ISSUE_LABEL_OBJ = "org.eclipse.mylyn.github.uiOBJ_GITHUB_ISSUE_LABEL";
    public static final String GITHUB_ADD_OBJ = "org.eclipse.mylyn.github.uiGITHUB_ADD_OBJ";
    public static final String GITHUB_CHECKALL_OBJ = "org.eclipse.mylyn.github.uiGITHUB_CHECKALL_OBJ";
    public static final String GITHUB_UNCHECKALL_OBJ = "org.eclipse.mylyn.github.uiGITHUB_UNCHECKALL_OBJ";
    public static final String GITHUB_ORG = "org.eclipse.mylyn.github.uiGITHUB_ORG";
    public static final ImageDescriptor DESC_GITHUB_LOGO;
    public static final ImageDescriptor DESC_GITHUB_ISSUE_LABEL;
    public static final ImageDescriptor DESC_GITHUB_ADD;
    public static final ImageDescriptor DESC_GITHUB_CHECKALL;
    public static final ImageDescriptor DESC_GITHUB_UNCHECKALL;
    public static final ImageDescriptor DESC_GITHUB_ORG;

    static {
        DESC_GITHUB_LOGO = GitHubImages.create(PATH_OBJ, "github.png");
        DESC_GITHUB_ISSUE_LABEL = GitHubImages.create(PATH_OBJ, "issue_label.png");
        DESC_GITHUB_ADD = GitHubImages.create(PATH_OBJ, "add.png");
        DESC_GITHUB_CHECKALL = GitHubImages.create(PATH_OBJ, "checkall.gif");
        DESC_GITHUB_UNCHECKALL = GitHubImages.create(PATH_OBJ, "uncheckall.gif");
        DESC_GITHUB_ORG = GitHubImages.create(PATH_OBJ, "org.png");
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)GitHubImages.makeImageURL(prefix, name));
    }

    public static Image get(String key) {
        if (manager == null) {
            GitHubImages.initialize();
        }
        return manager.get(key);
    }

    private static final void initialize() {
        manager = new ImageRegistry();
        GitHubImages.manage(GITHUB_LOGO_OBJ, DESC_GITHUB_LOGO);
        GitHubImages.manage(GITHUB_ISSUE_LABEL_OBJ, DESC_GITHUB_ISSUE_LABEL);
        GitHubImages.manage(GITHUB_ADD_OBJ, DESC_GITHUB_ADD);
        GitHubImages.manage(GITHUB_CHECKALL_OBJ, DESC_GITHUB_CHECKALL);
        GitHubImages.manage(GITHUB_UNCHECKALL_OBJ, DESC_GITHUB_UNCHECKALL);
        GitHubImages.manage(GITHUB_ORG, DESC_GITHUB_ORG);
    }

    private static URL makeImageURL(String prefix, String name) {
        String path = "$nl$/" + prefix + name;
        Bundle bundle = Platform.getBundle((String)NAME_PREFIX);
        return FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
    }

    private static Image manage(String key, ImageDescriptor desc) {
        Image image = desc.createImage();
        manager.put(key, image);
        return image;
    }
}

