/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.ids.TypeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainParameterTypes {
    @NonNull
    public static final DomainParameterTypes EMPTY_LIST = new DomainParameterTypes(new DomainType[0]);
    @NonNull
    private final ParametersId parametersId;
    @NonNull
    private final DomainType[] parameterTypes;
    private final int hashCode;
    private List<DomainParameter> parameters = null;

    public DomainParameterTypes(DomainType ... parameterTypes) {
        this.parametersId = IdManager.getParametersId(parameterTypes);
        this.parameterTypes = parameterTypes;
        this.hashCode = this.parametersId.hashCode() + 2457;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DomainParameterTypes)) {
            return false;
        }
        DomainParameterTypes that = (DomainParameterTypes)obj;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        DomainType[] thoseParameters = that.parameterTypes;
        if (this.parameterTypes.length != thoseParameters.length) {
            return false;
        }
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (!this.parameterTypes[i].equals(thoseParameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NonNull
    public DomainType get(int index) {
        DomainType parameterType = this.parameterTypes[index];
        assert (parameterType != null);
        return parameterType;
    }

    @NonNull
    public DomainType[] get() {
        return this.parameterTypes;
    }

    @NonNull
    public ParametersId getParametersId() {
        return this.parametersId;
    }

    @NonNull
    public List<? extends DomainTypedElement> getParameters() {
        List<DomainParameter> parameters2 = this.parameters;
        if (parameters2 == null) {
            this.parameters = parameters2 = new ArrayList<DomainParameter>();
            int i = 0;
            while (i < this.parameterTypes.length) {
                DomainType type = this.parameterTypes[i];
                parameters2.add(new DomainParameter("_" + i, type));
                ++i;
            }
        }
        return parameters2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int size() {
        return this.parameterTypes.length;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.parameterTypes[i].toString());
            ++i;
        }
        s.append(')');
        return s.toString();
    }

    public static final class DomainParameter
    implements DomainTypedElement {
        @NonNull
        protected final String name;
        @NonNull
        protected final DomainType type;

        public DomainParameter(@NonNull String name, @NonNull DomainType type) {
            this.name = name;
            this.type = type;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public DomainType getType() {
            return this.type;
        }

        @NonNull
        public TypeId getTypeId() {
            return this.type.getTypeId();
        }
    }
}

