/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.ids.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainTemplateParameter;
import org.eclipse.ocl.examples.domain.ids.BindingsId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.TemplateBinding;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.impl.AbstractTypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateBindingImpl
extends AbstractTypeId
implements TemplateBinding {
    private DomainTemplateParameter templateParameter;
    private TemplateParameterId templateParameterId;

    public TemplateBindingImpl(@NonNull DomainTemplateParameter templateParameter) {
        this.templateParameter = templateParameter;
    }

    @Override
    @Nullable
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTemplateBinding(this);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        String string = String.valueOf(this.templateParameter != null ? this.templateParameter : this.templateParameterId);
        assert (string != null);
        return string;
    }

    @Override
    @NonNull
    public DomainTemplateParameter getTemplateParameter() {
        return DomainUtil.nonNullState(this.templateParameter);
    }

    @Override
    public int hashCode() {
        return this.templateParameter.hashCode();
    }

    @Override
    public void install(@NonNull TemplateParameterId templateParameterId) {
        this.templateParameterId = templateParameterId;
        this.templateParameter = null;
    }

    @Override
    @NonNull
    public TypeId specialize(@NonNull BindingsId templateBindings) {
        int index = this.templateParameterId.getIndex();
        ElementId templateBinding = (ElementId)templateBindings.get(index);
        if (templateBinding instanceof TemplateBinding) {
            return new TemplateBindingImpl(((TemplateBinding)templateBinding).getTemplateParameter());
        }
        assert (templateBinding != null);
        return (TypeId)templateBinding;
    }
}

