/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.notify.impl.SingletonAdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.compatibility.EMF_2_9;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneProjectMap
extends SingletonAdapterImpl {
    private Map<File, Exception> exceptionMap = null;
    private Map<String, IProjectDescriptor.Internal> project2descriptor = null;
    protected boolean initializedGenModelLocationMap = false;
    protected boolean initializedPlatformResourceMap = false;

    @Nullable
    public static StandaloneProjectMap findAdapter(@NonNull ResourceSet resourceSet) {
        return (StandaloneProjectMap)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), StandaloneProjectMap.class);
    }

    @NonNull
    public static StandaloneProjectMap getAdapter(@NonNull ResourceSet resourceSet) {
        StandaloneProjectMap adapter = StandaloneProjectMap.findAdapter(resourceSet);
        if (adapter == null) {
            adapter = new StandaloneProjectMap();
            resourceSet.eAdapters().add((Object)adapter);
            adapter.initializeResourceSet(resourceSet);
        }
        return adapter;
    }

    @NonNull
    public static EPackage.Registry getPackageRegistry(@Nullable ResourceSet resourceSet) {
        if (resourceSet == null) {
            EPackage.Registry globalRegistry = EPackage.Registry.INSTANCE;
            return globalRegistry;
        }
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        return packageRegistry;
    }

    public static Resource.Factory.Registry getResourceFactoryRegistry(@Nullable ResourceSet resourceSet) {
        return resourceSet != null ? resourceSet.getResourceFactoryRegistry() : Resource.Factory.Registry.INSTANCE;
    }

    public static URIConverter getURIConverter(@Nullable ResourceSet resourceSet) {
        return resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
    }

    public static Map<URI, URI> getURIMap(@Nullable ResourceSet resourceSet) {
        return resourceSet != null ? resourceSet.getURIConverter().getURIMap() : URIConverter.URI_MAP;
    }

    public static void initStatics() {
        new GenModelEcorePackageHandler(null);
        new PluginGenModelHandler(null);
    }

    public static void initializeURIResourceMap(@Nullable ResourceSet resourceSet) {
        ResourceSetImpl resourceSetImpl;
        Map uriResourceMap;
        if (resourceSet instanceof ResourceSetImpl && (uriResourceMap = (resourceSetImpl = (ResourceSetImpl)resourceSet).getURIResourceMap()) == null) {
            resourceSetImpl.setURIResourceMap(new HashMap());
        }
    }

    protected IProjectDescriptor.Internal createProjectDescriptor(String projectName, URI locationURI) {
        return new ProjectDescriptor(projectName, locationURI);
    }

    public IProjectDescriptor getProjectDescriptor(String projectName) {
        return this.getProjectDescriptors().get(projectName);
    }

    protected IProjectDescriptor.Internal getProjectDescriptorInternal(URI platformURI) {
        String projectName = platformURI.segment(1);
        this.getProjectDescriptors();
        IProjectDescriptor.Internal projectDescriptor = this.project2descriptor.get(projectName);
        if (projectDescriptor == null) {
            URI locationURI = platformURI.trimSegments(platformURI.segmentCount() - 2).appendSegment("");
            projectDescriptor = this.createProjectDescriptor(projectName, locationURI);
            this.project2descriptor.put(projectName, projectDescriptor);
        }
        return projectDescriptor;
    }

    public Map<File, Exception> getExceptionMap() {
        return this.exceptionMap;
    }

    public URI getLocation(String projectName) {
        IProjectDescriptor projectDescriptor = this.getProjectDescriptors().get(projectName);
        if (projectDescriptor == null) {
            return null;
        }
        return projectDescriptor.getLocationURI();
    }

    protected synchronized Map<String, ? extends IProjectDescriptor> getProjectDescriptors() {
        if (this.project2descriptor == null) {
            this.project2descriptor = new HashMap<String, IProjectDescriptor.Internal>();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                this.scanClassPath(this.project2descriptor, factory.newSAXParser());
            }
            catch (Exception e) {
                this.logException(null, e);
                return null;
            }
        }
        return this.project2descriptor;
    }

    public synchronized void initializeGenModelLocationMap(boolean force) {
        if (force || !this.initializedGenModelLocationMap) {
            this.initializedGenModelLocationMap = true;
            this.getProjectDescriptors();
            for (IProjectDescriptor iProjectDescriptor : this.project2descriptor.values()) {
                iProjectDescriptor.initializeGenModelLocationMap();
            }
        }
    }

    public synchronized void initializePackageRegistry(ResourceSet resourceSet) {
        EPackage.Registry packageRegistry = StandaloneProjectMap.getPackageRegistry(resourceSet);
        this.getProjectDescriptors();
        for (IProjectDescriptor iProjectDescriptor : this.project2descriptor.values()) {
            Collection<IPackageDescriptor> packageDescriptors = iProjectDescriptor.getPackageDescriptors();
            if (packageDescriptors == null) continue;
            for (IPackageDescriptor packageDescriptor : packageDescriptors) {
                iProjectDescriptor.initializePackageRegistration(packageRegistry, packageDescriptor);
            }
        }
    }

    public synchronized void initializePlatformResourceMap(boolean force) {
        if (force || !this.initializedPlatformResourceMap) {
            this.initializedPlatformResourceMap = true;
            this.getProjectDescriptors();
            for (IProjectDescriptor iProjectDescriptor : this.project2descriptor.values()) {
                iProjectDescriptor.initializePlatformResourceMap();
            }
        }
    }

    public void initializeResourceSet(ResourceSet resourceSet) {
        StandaloneProjectMap.initializeURIResourceMap(resourceSet);
        this.initializePlatformResourceMap(false);
        this.initializeURIMap(resourceSet);
        this.initializeGenModelLocationMap(false);
        this.initializePackageRegistry(resourceSet);
    }

    public synchronized void initializeURIMap(ResourceSet resourceSet) {
        this.getProjectDescriptors();
        Map<URI, URI> uriMap = StandaloneProjectMap.getURIMap(resourceSet);
        for (String project : this.project2descriptor.keySet()) {
            IProjectDescriptor projectDescriptor = this.project2descriptor.get(project);
            projectDescriptor.initializeURIMap(uriMap);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(StandaloneProjectMap.class);
    }

    protected void logException(File file, Exception e) {
        if (this.exceptionMap == null) {
            this.exceptionMap = new HashMap<File, Exception>();
        }
        this.exceptionMap.put(file, e);
    }

    protected IProjectDescriptor registerBundle(File file, SAXParser saxParser) {
        block11: {
            Manifest manifest;
            JarFile jarFile;
            block10: {
                jarFile = new JarFile(file);
                manifest = jarFile.getManifest();
                if (manifest != null) break block10;
                return null;
            }
            try {
                IProjectDescriptor.Internal projectDescriptor;
                String project = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (project == null) break block11;
                int indexOf = project.indexOf(59);
                if (indexOf > 0) {
                    project = project.substring(0, indexOf);
                }
                if ((projectDescriptor = this.project2descriptor.get(project)) != null) {
                    return projectDescriptor;
                }
                String path = "archive:" + file.toURI() + "!/";
                URI locationURI = URI.createURI((String)path);
                projectDescriptor = this.createProjectDescriptor(project, locationURI);
                this.project2descriptor.put(project, projectDescriptor);
                ZipEntry entry = jarFile.getEntry("plugin.xml");
                if (entry != null) {
                    InputStream inputStream = jarFile.getInputStream(entry);
                    try {
                        PluginGenModelHandler pluginGenModelHandler = new PluginGenModelHandler(jarFile, projectDescriptor);
                        saxParser.parse(inputStream, (DefaultHandler)pluginGenModelHandler);
                        pluginGenModelHandler.scanContents(saxParser);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                return projectDescriptor;
            }
            catch (ZipException e) {
                this.logException(file, (Exception)new WrappedException("Could not open Jar file " + file.getAbsolutePath() + ".", (Exception)e));
            }
            catch (Exception e) {
                this.logException(file, e);
            }
        }
        return null;
    }

    protected IProjectDescriptor.Internal registerProject(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            String project = document.getDocumentElement().getElementsByTagName("name").item(0).getTextContent();
            URI locationURI = URI.createFileURI((String)(String.valueOf(file.getParentFile().getCanonicalPath()) + File.separator));
            IProjectDescriptor.Internal projectDescriptor = this.createProjectDescriptor(project, locationURI);
            this.project2descriptor.put(project, projectDescriptor);
            IProjectDescriptor.Internal internal = projectDescriptor;
            return internal;
        }
        catch (Exception e) {
            this.logException(file, (Exception)new WrappedException("Couldn't read " + file, e));
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void scanClassPath(Map<String, IProjectDescriptor.Internal> projectDescriptors, SAXParser saxParser) {
        String property = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        if (property != null) {
            String[] entries;
            String[] stringArray = entries = property.split(separator);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                File fileEntry = new File(entry);
                try {
                    File plugIn;
                    IProjectDescriptor.Internal projectDescriptor;
                    File parentFile;
                    File dotProject;
                    File f = fileEntry.getCanonicalFile();
                    if (f.getPath().endsWith(".jar")) {
                        this.registerBundle(f, saxParser);
                    } else if (!this.scanFolder(f, saxParser, new HashSet<String>(), 0) && (dotProject = new File(parentFile = f.getParentFile(), ".project")).exists() && (projectDescriptor = this.registerProject(dotProject)) != null && (plugIn = new File(parentFile, "plugin.xml")).exists()) {
                        PluginGenModelHandler pluginGenModelHandler = new PluginGenModelHandler(projectDescriptor);
                        saxParser.parse(plugIn, (DefaultHandler)pluginGenModelHandler);
                        pluginGenModelHandler.scanContents(saxParser);
                    }
                }
                catch (Exception e) {
                    this.logException(fileEntry, e);
                }
                ++n2;
            }
        }
    }

    protected boolean scanFolder(File f, SAXParser saxParser, Set<String> alreadyVisited, int depth) {
        try {
            if (!alreadyVisited.add(f.getCanonicalPath())) {
                return true;
            }
        }
        catch (Exception e) {
            this.logException(f, e);
            return true;
        }
        File[] files = f.listFiles();
        boolean containsProject = false;
        File dotProject = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists() && file.isDirectory() && depth < 2 && !file.getName().startsWith(".")) {
                    containsProject |= this.scanFolder(file, saxParser, alreadyVisited, depth + 1);
                } else if (".project".equals(file.getName())) {
                    dotProject = file;
                } else if (file.getName().endsWith(".jar")) {
                    this.registerBundle(file, saxParser);
                }
                ++n2;
            }
        }
        if (!containsProject && dotProject != null) {
            this.registerProject(dotProject);
        }
        return containsProject || dotProject != null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.project2descriptor != null) {
            ArrayList<String> projectNames = new ArrayList<String>(this.project2descriptor.keySet());
            Collections.sort(projectNames);
            for (String projectName : projectNames) {
                if (s.length() > 0) {
                    s.append("\n");
                }
                s.append(projectName);
                s.append(" => ");
                s.append(this.project2descriptor.get(projectName).getLocationURI());
            }
        }
        return s.toString();
    }

    protected static class GenModelEcorePackageHandler
    extends DefaultHandler {
        public static final String genmodelTag = "genmodel:GenModel";
        public static final String genPackagesTag = "genPackages";
        public static final String ecorePackageTag = "ecorePackage";
        public static final String ecorePackageAttribute = "ecorePackage";
        public static final String hrefAttribute = "href";
        protected final IPackageDescriptor.Internal packageDescriptor;
        private int genmodelCount = 0;
        private int genPackagesCount = 0;
        private int ecorePackageCount = 0;

        public GenModelEcorePackageHandler(IPackageDescriptor.Internal packageDescriptor) {
            this.packageDescriptor = packageDescriptor;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.genmodelCount == 1) {
                if (genmodelTag.equals(qName)) {
                    --this.genmodelCount;
                }
                if (this.genPackagesCount == 1) {
                    if (genPackagesTag.equals(qName)) {
                        --this.genPackagesCount;
                    }
                    if (this.ecorePackageCount == 1 && "ecorePackage".equals(qName)) {
                        --this.ecorePackageCount;
                    }
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.genmodelCount == 0) {
                if (genmodelTag.equals(qName)) {
                    ++this.genmodelCount;
                }
            } else if (this.genmodelCount == 1) {
                if (this.genPackagesCount == 0 && genPackagesTag.equals(qName)) {
                    ++this.genPackagesCount;
                    String ecorePackage = attributes.getValue("ecorePackage");
                    if (ecorePackage != null) {
                        this.packageDescriptor.addEcorePackage(ecorePackage);
                    }
                } else if (this.genPackagesCount == 1 && "ecorePackage".equals(qName)) {
                    ++this.ecorePackageCount;
                    String ecorePackage = attributes.getValue(hrefAttribute);
                    this.packageDescriptor.addEcorePackage(ecorePackage);
                }
            }
        }
    }

    public static interface IPackageDescriptor
    extends EPackage.Descriptor {
        public URI getEcoreModelURI();

        public URI getGenModelURI();

        public URI getNsURI();

        public IProjectDescriptor getProjectDescriptor();

        public void setUseModel(boolean var1, EPackage.Registry var2);

        public void setUseModelAndPackage(EPackage var1, EPackage.Registry var2);

        public void setUsePackage(EPackage var1, EPackage.Registry var2);

        public void unload(EPackage.Registry var1);

        public static interface Internal
        extends IPackageDescriptor {
            public void addEcorePackage(String var1);

            public GenModelEcorePackageHandler createGenModelEcorePackageHandler();

            public void setClassName(String var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IProjectDescriptor {
        public URI getLocationURI();

        public URI getLocationURI(String var1);

        public File getLocationFile(String var1);

        public URI getPlatformPluginURI();

        public URI getPlatformPluginURI(String var1);

        public URI getPlatformResourceURI();

        public URI getPlatformResourceURI(String var1);

        public IPackageDescriptor getPackageDescriptor(URI var1);

        public Collection<IPackageDescriptor> getPackageDescriptors();

        public void initializeGenModelLocationMap();

        public void initializePackageRegistration(EPackage.Registry var1, IPackageDescriptor var2);

        public void initializePlatformResourceMap();

        public void initializeURIMap(Map<URI, URI> var1);

        public void useModelsAndPackages(Resource var1);

        public void usePackages(Resource var1);

        public static interface Internal
        extends IProjectDescriptor {
            public IPackageDescriptor.Internal createPackageDescriptor(URI var1, URI var2);
        }
    }

    public static final class PackageDescriptor
    implements IPackageDescriptor.Internal {
        protected final IProjectDescriptor projectDescriptor;
        protected final URI nsURI;
        protected final URI genModelURI;
        protected String className = null;
        private URI ecorePackageURI = null;
        private boolean useModel = false;
        private EPackage ePackage = null;

        public PackageDescriptor(IProjectDescriptor projectDescriptor, URI nsURI, URI genModelURI) {
            this.projectDescriptor = projectDescriptor;
            this.nsURI = nsURI;
            this.genModelURI = genModelURI;
        }

        public void addEcorePackage(String ecorePackage) {
            URI uri = URI.createURI((String)ecorePackage);
            URI locationURI = this.projectDescriptor.getLocationURI();
            URI absoluteGenModelURI = this.genModelURI.resolve(locationURI);
            URI absolutePackageURI = uri.resolve(absoluteGenModelURI);
            this.ecorePackageURI = absolutePackageURI.deresolve(locationURI, true, true, true);
        }

        public GenModelEcorePackageHandler createGenModelEcorePackageHandler() {
            return new GenModelEcorePackageHandler(this);
        }

        public EFactory getEFactory() {
            return null;
        }

        public EPackage getEPackage() {
            if (this.ePackage == null) {
                if (this.useModel) {
                    URI uri = this.ecorePackageURI.resolve(this.projectDescriptor.getLocationURI());
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    this.ePackage = (EPackage)resourceSet.getEObject(uri, true);
                    EcoreUtil.resolveAll((ResourceSet)resourceSet);
                    resourceSet.getResources().clear();
                } else if (this.className != null) {
                    try {
                        Class<?> javaClass = Class.forName(this.className);
                        Field field = javaClass.getField("eINSTANCE");
                        this.ePackage = (EPackage)field.get(null);
                    }
                    catch (ClassNotFoundException e) {
                        throw new WrappedException((Exception)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new WrappedException((Exception)e);
                    }
                    catch (NoSuchFieldException e) {
                        throw new WrappedException((Exception)e);
                    }
                } else {
                    Object object = EPackage.Registry.INSTANCE.get((Object)this.nsURI.toString());
                    if (object instanceof EPackage) {
                        this.ePackage = (EPackage)object;
                    } else if (object instanceof EPackage.Descriptor) {
                        this.ePackage = ((EPackage.Descriptor)object).getEPackage();
                    }
                }
            }
            return this.ePackage;
        }

        public URI getEcoreModelURI() {
            return this.ecorePackageURI != null ? this.ecorePackageURI.trimFragment() : null;
        }

        public URI getGenModelURI() {
            return this.genModelURI;
        }

        public URI getNsURI() {
            return this.nsURI;
        }

        public IProjectDescriptor getProjectDescriptor() {
            return this.projectDescriptor;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setUseModel(boolean useModel, EPackage.Registry packageRegistry) {
            if (packageRegistry == null) {
                packageRegistry = StandaloneProjectMap.getPackageRegistry(null);
            }
            this.useModel = useModel;
            String nsURIString = this.nsURI.toString();
            if (packageRegistry.get((Object)nsURIString) != this) {
                packageRegistry.put((Object)nsURIString, (Object)this);
            }
            URI resourceURI = this.projectDescriptor.getPlatformResourceURI();
            URI pluginURI = this.projectDescriptor.getPlatformPluginURI();
            URI ecoreURI = this.ecorePackageURI.trimFragment();
            String ecorePackageResourceURIString = ecoreURI.resolve(resourceURI).toString();
            String ecorePackagePluginURIString = ecoreURI.resolve(pluginURI).toString();
            if (packageRegistry.get((Object)ecorePackageResourceURIString) != this) {
                packageRegistry.put((Object)ecorePackageResourceURIString, (Object)this);
            }
            if (packageRegistry.get((Object)ecorePackagePluginURIString) != this) {
                packageRegistry.put((Object)ecorePackagePluginURIString, (Object)this);
            }
        }

        public void setUseModelAndPackage(final EPackage ePackage, EPackage.Registry packageRegistry) {
            if (packageRegistry == null) {
                packageRegistry = StandaloneProjectMap.getPackageRegistry(null);
            }
            this.ePackage = null;
            this.useModel = true;
            String nsURIString = this.nsURI.toString();
            packageRegistry.put((Object)nsURIString, (Object)new EPackage.Descriptor(){

                public EPackage getEPackage() {
                    return ePackage;
                }

                public EFactory getEFactory() {
                    return null;
                }
            });
            URI resourceURI = this.projectDescriptor.getPlatformResourceURI();
            URI pluginURI = this.projectDescriptor.getPlatformPluginURI();
            URI ecoreURI = this.ecorePackageURI.trimFragment();
            String ecorePackageResourceURIString = ecoreURI.resolve(resourceURI).toString();
            String ecorePackagePluginURIString = ecoreURI.resolve(pluginURI).toString();
            if (packageRegistry.get((Object)ecorePackageResourceURIString) != this) {
                packageRegistry.put((Object)ecorePackageResourceURIString, (Object)this);
            }
            if (packageRegistry.get((Object)ecorePackagePluginURIString) != this) {
                packageRegistry.put((Object)ecorePackagePluginURIString, (Object)this);
            }
        }

        public void setUsePackage(EPackage ePackage, EPackage.Registry packageRegistry) {
            if (packageRegistry == null) {
                packageRegistry = StandaloneProjectMap.getPackageRegistry(null);
            }
            this.ePackage = ePackage;
            this.useModel = false;
            String nsURIString = this.nsURI.toString();
            if (packageRegistry.get((Object)nsURIString) != this) {
                packageRegistry.put((Object)nsURIString, (Object)this);
            }
            URI resourceURI = this.projectDescriptor.getPlatformResourceURI();
            URI pluginURI = this.projectDescriptor.getPlatformPluginURI();
            URI ecoreURI = this.ecorePackageURI.trimFragment();
            String ecorePackageResourceURIString = ecoreURI.resolve(resourceURI).toString();
            String ecorePackagePluginURIString = ecoreURI.resolve(pluginURI).toString();
            if (packageRegistry.get((Object)ecorePackageResourceURIString) != this) {
                packageRegistry.put((Object)ecorePackageResourceURIString, (Object)this);
            }
            if (packageRegistry.get((Object)ecorePackagePluginURIString) != this) {
                packageRegistry.put((Object)ecorePackagePluginURIString, (Object)this);
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.nsURI);
            s.append(" => ");
            s.append(this.className);
            if (this.genModelURI != null) {
                s.append(", ");
                s.append(this.genModelURI);
            }
            if (this.ecorePackageURI != null) {
                s.append(", ");
                s.append(this.ecorePackageURI);
            }
            return s.toString();
        }

        public void unload(EPackage.Registry packageRegistry) {
            this.ePackage = null;
            packageRegistry.put((Object)this.nsURI.toString(), (Object)this);
            URI resourceURI = this.projectDescriptor.getPlatformResourceURI();
            URI pluginURI = this.projectDescriptor.getPlatformPluginURI();
            URI ecoreURI = this.ecorePackageURI.trimFragment();
            packageRegistry.put((Object)ecoreURI.resolve(resourceURI).toString(), (Object)this);
            packageRegistry.put((Object)ecoreURI.resolve(pluginURI).toString(), (Object)this);
        }
    }

    protected static class PluginGenModelHandler
    extends DefaultHandler {
        public static final String pluginTag = "plugin";
        public static final String extensionTag = "extension";
        public static final String pointTag = "point";
        public static final String packageTag = "package";
        public static final String extensionPointAttribute = "org.eclipse.emf.ecore.generated_package";
        public static final String uriAttribute = "uri";
        public static final String classAttribute = "class";
        public static final String genModelAttribute = "genModel";
        protected final JarFile jarFile;
        protected final IProjectDescriptor.Internal projectDescriptor;
        private int pluginCount = 0;
        private int extensionCount = 0;
        private boolean inPoint = false;
        private int packageCount = 0;
        private Map<String, GenModelEcorePackageHandler> genModelEcorePackageHandlers = new HashMap<String, GenModelEcorePackageHandler>();

        public PluginGenModelHandler(IProjectDescriptor.Internal projectDescriptor) {
            this.jarFile = null;
            this.projectDescriptor = projectDescriptor;
        }

        public PluginGenModelHandler(JarFile jarFile, IProjectDescriptor.Internal projectDescriptor) {
            this.jarFile = jarFile;
            this.projectDescriptor = projectDescriptor;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.pluginCount == 1) {
                if (pluginTag.equals(qName)) {
                    --this.pluginCount;
                }
                if (this.extensionCount == 1) {
                    if (extensionTag.equals(qName)) {
                        --this.extensionCount;
                    }
                    if (this.packageCount == 1 && packageTag.equals(qName)) {
                        --this.packageCount;
                    }
                }
            }
        }

        public void scanContents(SAXParser saxParser) throws SAXParseException {
            for (String genModel : this.genModelEcorePackageHandlers.keySet()) {
                GenModelEcorePackageHandler genModelEcorePackageHandler = this.genModelEcorePackageHandlers.get(genModel);
                URI locationURI = this.projectDescriptor.getLocationURI();
                URI genModelURI = URI.createURI((String)genModel).resolve(locationURI);
                InputStream inputStream = null;
                try {
                    try {
                        if (this.jarFile != null) {
                            ZipEntry entry = this.jarFile.getEntry(genModel);
                            if (entry != null) {
                                inputStream = this.jarFile.getInputStream(entry);
                            }
                        } else {
                            inputStream = new FileInputStream(genModelURI.toString().substring(5));
                        }
                        if (inputStream == null) continue;
                        saxParser.parse(inputStream, (DefaultHandler)genModelEcorePackageHandler);
                    }
                    catch (Exception e) {
                        throw new SAXParseException("Failed to parse " + locationURI, null, e);
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.pluginCount == 0) {
                if (pluginTag.equals(qName)) {
                    ++this.pluginCount;
                }
            } else if (this.pluginCount == 1) {
                if (this.extensionCount == 0 && extensionTag.equals(qName)) {
                    ++this.extensionCount;
                    this.inPoint = extensionPointAttribute.equals(attributes.getValue(pointTag));
                } else if (this.extensionCount == 1 && this.inPoint && this.packageCount == 0 && packageTag.equals(qName)) {
                    ++this.packageCount;
                    String className = attributes.getValue(classAttribute);
                    URI nsURI = URI.createURI((String)attributes.getValue(uriAttribute));
                    String genModel = attributes.getValue(genModelAttribute);
                    if (genModel != null) {
                        URI locationURI = this.projectDescriptor.getLocationURI();
                        URI absoluteGenModelURI = URI.createURI((String)genModel).resolve(locationURI);
                        URI projectGenModelURI = absoluteGenModelURI.deresolve(locationURI, true, true, true);
                        IPackageDescriptor.Internal packageDescriptor = (IPackageDescriptor.Internal)this.projectDescriptor.getPackageDescriptor(nsURI);
                        if (packageDescriptor == null) {
                            packageDescriptor = this.projectDescriptor.createPackageDescriptor(nsURI, projectGenModelURI);
                        }
                        packageDescriptor.setClassName(className);
                        GenModelEcorePackageHandler genModelEcorePackageHandler = packageDescriptor.createGenModelEcorePackageHandler();
                        this.genModelEcorePackageHandlers.put(genModel, genModelEcorePackageHandler);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectDescriptor
    implements IProjectDescriptor.Internal {
        protected final String name;
        protected final URI locationURI;
        private Map<URI, IPackageDescriptor> nsURI2packageDescriptor = null;

        public ProjectDescriptor(String name, URI locationURI) {
            this.name = name;
            this.locationURI = locationURI;
        }

        @Override
        public IPackageDescriptor.Internal createPackageDescriptor(URI nsURI, URI genModelURI) {
            PackageDescriptor packageDescriptor = new PackageDescriptor(this, nsURI, genModelURI);
            if (this.nsURI2packageDescriptor == null) {
                this.nsURI2packageDescriptor = new HashMap<URI, IPackageDescriptor>();
            }
            this.nsURI2packageDescriptor.put(nsURI, packageDescriptor);
            return packageDescriptor;
        }

        @Override
        public URI getLocationURI() {
            return this.locationURI;
        }

        @Override
        public URI getLocationURI(String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.locationURI);
        }

        @Override
        public File getLocationFile(String projectRelativeFileName) {
            return new File(this.getLocationURI(projectRelativeFileName).toFileString());
        }

        public String getName() {
            return this.name;
        }

        @Override
        public IPackageDescriptor getPackageDescriptor(URI nsURI) {
            return this.nsURI2packageDescriptor != null ? this.nsURI2packageDescriptor.get(nsURI) : null;
        }

        @Override
        public Collection<IPackageDescriptor> getPackageDescriptors() {
            return this.nsURI2packageDescriptor != null ? this.nsURI2packageDescriptor.values() : null;
        }

        @Override
        public URI getPlatformPluginURI() {
            return URI.createPlatformPluginURI((String)("/" + this.name + "/"), (boolean)true);
        }

        @Override
        public URI getPlatformPluginURI(String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.getPlatformPluginURI());
        }

        @Override
        public URI getPlatformResourceURI() {
            return URI.createPlatformResourceURI((String)("/" + this.name + "/"), (boolean)true);
        }

        @Override
        public URI getPlatformResourceURI(String projectRelativeFileName) {
            return URI.createURI((String)projectRelativeFileName).resolve(this.getPlatformResourceURI());
        }

        public void installEcoreModel(ResourceSet resourceSet, URI nsURI) {
            IPackageDescriptor packageDescriptor = this.getPackageDescriptor(nsURI);
            if (packageDescriptor != null) {
                EPackage.Registry packageRegistry = StandaloneProjectMap.getPackageRegistry(resourceSet);
                URI ecoreModelURI = packageDescriptor.getEcoreModelURI();
                URI resourceURI = this.getPlatformResourceURI();
                URI pluginURI = this.getPlatformPluginURI();
                URI ecorePackageResourceURI = ecoreModelURI.resolve(resourceURI);
                URI ecorePackagePluginURI = ecoreModelURI.resolve(pluginURI);
                packageRegistry.remove((Object)ecorePackageResourceURI.toString());
                packageRegistry.remove((Object)ecorePackagePluginURI.toString());
                packageRegistry.remove((Object)nsURI.toString());
                URI modelURI = ecoreModelURI.resolve(this.locationURI);
                Map<URI, URI> uriMap = StandaloneProjectMap.getURIMap(resourceSet);
                uriMap.put(resourceURI, modelURI);
                uriMap.put(pluginURI, modelURI);
                uriMap.put(nsURI, modelURI);
            }
        }

        @Override
        public void initializeGenModelLocationMap() {
            Collection<IPackageDescriptor> packageDescriptors = this.getPackageDescriptors();
            if (packageDescriptors != null) {
                Map<String, URI> ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(false);
                for (IPackageDescriptor packageDescriptor : packageDescriptors) {
                    URI nsURI = packageDescriptor.getNsURI();
                    URI genModelURI = packageDescriptor.getGenModelURI();
                    ePackageNsURIToGenModelLocationMap.put(nsURI.toString(), genModelURI.resolve(this.locationURI));
                }
            }
        }

        @Override
        public void initializePackageRegistration(EPackage.Registry packageRegistry, IPackageDescriptor packageDescriptor) {
            URI ecoreModelURI = packageDescriptor.getEcoreModelURI();
            if (ecoreModelURI != null) {
                URI resourceURI = this.getPlatformResourceURI();
                URI pluginURI = this.getPlatformPluginURI();
                URI ecorePackageResourceURI = ecoreModelURI.resolve(resourceURI);
                URI ecorePackagePluginURI = ecoreModelURI.resolve(pluginURI);
                packageRegistry.put((Object)ecorePackageResourceURI.toString(), (Object)packageDescriptor);
                packageRegistry.put((Object)ecorePackagePluginURI.toString(), (Object)packageDescriptor);
            }
        }

        @Override
        public void initializePlatformResourceMap() {
            Map platformResourceMap = EcorePlugin.getPlatformResourceMap();
            platformResourceMap.put(this.name, this.locationURI);
        }

        @Override
        public void initializeURIMap(Map<URI, URI> uriMap) {
            URI resourceURI = this.getPlatformResourceURI();
            URI pluginURI = this.getPlatformPluginURI();
            uriMap.put(resourceURI, this.locationURI);
            uriMap.put(pluginURI, this.locationURI);
        }

        public String toString() {
            return String.valueOf(this.name) + " => " + this.locationURI.toString();
        }

        @Override
        public void useModelsAndPackages(Resource ecoreResource) {
            for (EObject eObject : ecoreResource.getContents()) {
                EPackage ePackage;
                IPackageDescriptor packageDescriptor;
                if (!(eObject instanceof EPackage) || (packageDescriptor = this.getPackageDescriptor(URI.createURI((String)(ePackage = (EPackage)eObject).getNsURI()))) == null) continue;
                packageDescriptor.setUseModelAndPackage(ePackage, null);
            }
        }

        @Override
        public void usePackages(Resource ecoreResource) {
            for (EObject eObject : ecoreResource.getContents()) {
                EPackage ePackage;
                IPackageDescriptor packageDescriptor;
                if (!(eObject instanceof EPackage) || (packageDescriptor = this.getPackageDescriptor(URI.createURI((String)(ePackage = (EPackage)eObject).getNsURI()))) == null) continue;
                packageDescriptor.setUsePackage(ePackage, null);
            }
        }
    }
}

