/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRangeImpl
extends AbstractList<Value>
implements IntegerRange {
    @NonNull
    protected final IntegerValue first;
    @NonNull
    protected final IntegerValue last;
    @NonNull
    protected final IntegerValue fullSize;
    protected final Integer size;

    public IntegerRangeImpl(@NonNull IntegerValue first, @NonNull IntegerValue last) {
        IntegerValue sizeMinusOne = last.subtractInteger(first);
        this.first = first;
        this.last = last;
        if (sizeMinusOne.signum() < 0) {
            this.fullSize = ValuesUtil.ZERO_VALUE;
            this.size = 0;
        } else {
            this.fullSize = sizeMinusOne.addInteger(ValuesUtil.ONE_VALUE);
            this.size = this.fullSize.asInteger();
        }
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof IntegerValue)) {
            return false;
        }
        IntegerValue value = (IntegerValue)o;
        return this.first.compareToInteger(value) <= 0 && value.compareToInteger(this.last) <= 0;
    }

    @Override
    @NonNull
    public IntegerValue get(int index) {
        if (index < 0 || this.size == null || index >= this.size) {
            throw new NoSuchElementException();
        }
        try {
            return this.first.addInteger(ValuesUtil.integerValueOf(index));
        }
        catch (InvalidValueException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    @NonNull
    public IntegerValue getFirst() {
        return this.first;
    }

    @Override
    @NonNull
    public IntegerValue getLast() {
        return this.last;
    }

    @Override
    @NonNull
    public IntegerValue getSize() {
        return this.fullSize;
    }

    @Override
    @NonNull
    public Iterator<Value> iterator() {
        return new IntegerRangeIterator();
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size;
        }
        throw new NoSuchElementException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IntegerRangeIterator
    implements Iterator<Value> {
        private IntegerValue curr = null;

        IntegerRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.curr == null) {
                return IntegerRangeImpl.this.first.compareToInteger(IntegerRangeImpl.this.last) <= 0;
            }
            return !IntegerRangeImpl.this.last.equals(this.curr);
        }

        @Override
        public IntegerValue next() {
            if (this.curr == null) {
                this.curr = IntegerRangeImpl.this.first;
            } else if (this.curr.compareToInteger(IntegerRangeImpl.this.last) < 0) {
                try {
                    this.curr = this.curr.addInteger(ValuesUtil.ONE_VALUE);
                }
                catch (InvalidValueException e) {
                    throw new NoSuchElementException();
                }
            } else {
                throw new NoSuchElementException();
            }
            return this.curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.curr);
        }
    }
}

