/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelProducer;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ModeledViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.QVTDiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.naming.gen.GenNamingMediatorImpl;
import org.eclipse.gmf.internal.bridge.transform.GenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.ITransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.StaleGenModelDetector;
import org.eclipse.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.gmf.internal.bridge.transform.ValidationHelper;
import org.eclipse.gmf.internal.bridge.transform.VisualIdentifierDispenserProvider;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.codegen.util.GMFGenConfig;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.gmf.internal.common.reconcile.Reconciler;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformToGenModelOperation
implements ITransformToGenModelOperation {
    private URI myGMFGenModelURI;
    private TransformOptions myOptions;
    private Mapping myMapping;
    private GenModelDetector myGMDetector;
    private GenModel myGenModel;
    private Diagnostic myMapmodelValidationResult = Diagnostic.CANCEL_INSTANCE;
    private Diagnostic myGMFGenValidationResult = Diagnostic.CANCEL_INSTANCE;
    private IStatus myStaleGenmodelStatus = Status.CANCEL_STATUS;
    private final ResourceSet myResourceSet;

    public TransformToGenModelOperation(ResourceSet rs) {
        assert (rs != null);
        this.myResourceSet = rs;
        this.myOptions = new TransformOptions();
    }

    @Override
    public TransformOptions getOptions() {
        return this.myOptions;
    }

    public URI getGenURI() {
        return this.myGMFGenModelURI;
    }

    @Override
    public void setGenURI(URI gmfGen) {
        this.myGMFGenModelURI = gmfGen;
    }

    public GenModel getGenModel() {
        return this.myGenModel;
    }

    @Override
    public final ResourceSet getResourceSet() {
        return this.myResourceSet;
    }

    Mapping getMapping() {
        return this.myMapping;
    }

    private void setMapping(Mapping m, Diagnostic validationResult) {
        this.myMapping = m;
        this.myMapmodelValidationResult = validationResult;
        this.myGMDetector = m != null ? new GenModelDetector(m) : null;
        this.myGenModel = null;
    }

    private void setGMFGenValidationResult(Diagnostic validationResult) {
        this.myGMFGenValidationResult = validationResult;
    }

    @Override
    public GenModelDetector getGenModelDetector() {
        return this.myGMDetector;
    }

    @Override
    public Diagnostic getGMFGenValidationResult() {
        return this.myGMFGenValidationResult;
    }

    @Override
    public Diagnostic getMapmodelValidationResult() {
        return this.myMapmodelValidationResult;
    }

    @Override
    public IStatus getStaleGenmodelStatus() {
        return this.myStaleGenmodelStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Mapping loadMappingModel(URI uri, IProgressMonitor pm) throws CoreException {
        Mapping mapping;
        block10: {
            Mapping content = null;
            Diagnostic validation = Diagnostic.CANCEL_INSTANCE;
            SubProgressMonitor monitor = null;
            try {
                if (uri == null) {
                    throw new IllegalArgumentException(Messages.TransformToGenModelOperation_e_null_map_uri);
                }
                monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
                String cancelMessage = Messages.TransformToGenModelOperation_e_map_load_cancelled;
                monitor.beginTask("", 100);
                TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 0, Messages.TransformToGenModelOperation_task_load, cancelMessage);
                ModelLoadHelper loadHelper = new ModelLoadHelper(this.getResourceSet(), uri);
                if (!loadHelper.isOK()) {
                    throw new CoreException(loadHelper.getStatus());
                }
                TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 20, Messages.TransformToGenModelOperation_task_validate, cancelMessage);
                content = this.findMappingFromMappingModelRoot(loadHelper.getContentsRoot());
                if (content == null) {
                    String msg = MessageFormat.format(Messages.TransformToGenModelOperation_e_wrong_root_element, loadHelper.getContentsRoot().getClass().getName());
                    throw new CoreException(Plugin.createError(msg, null));
                }
                validation = ValidationHelper.validate((EObject)content, true, (IProgressMonitor)monitor);
                monitor.worked(60);
                if (8 == validation.getSeverity()) {
                    throw new CoreException(Plugin.createCancel(cancelMessage));
                }
                mapping = content;
                this.setMapping(content, validation);
                if (monitor == null) break block10;
            }
            catch (CoreException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_load_mapping_model, e2);
                        throw new CoreException(error);
                    }
                }
                catch (Throwable throwable) {
                    this.setMapping(content, validation);
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw throwable;
                }
            }
            monitor.done();
        }
        return mapping;
    }

    protected Mapping findMappingFromMappingModelRoot(EObject mappingModelRoot) {
        return mappingModelRoot instanceof Mapping ? (Mapping)mappingModelRoot : null;
    }

    @Override
    public GenModel findGenmodel() throws CoreException {
        IStatus detect;
        try {
            this.checkMapping();
            GenModelDetector gmd = this.getGenModelDetector();
            detect = gmd.detect();
            if (detect.isOK()) {
                GenModel genModel;
                this.myGenModel = genModel = gmd.get(this.getResourceSet());
                return genModel;
            }
        }
        catch (Exception e) {
            IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_mapping_invalid, e);
            throw new CoreException(error);
        }
        throw new CoreException(detect);
    }

    @Override
    public GenModel loadGenModel(URI uri, IProgressMonitor pm) throws CoreException {
        SubProgressMonitor monitor = null;
        try {
            this.checkMapping();
            monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
            String cancelMessage = Messages.TransformToGenModelOperation_e_genmodel_load_cancelled;
            monitor.beginTask("", 100);
            monitor.subTask(Messages.TransformToGenModelOperation_task_detect);
            GenModelDetector gmd = this.getGenModelDetector();
            IStatus status = Status.OK_STATUS;
            status = uri == null ? gmd.detect() : gmd.advise(uri);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 30, Messages.TransformToGenModelOperation_task_load, cancelMessage);
            GenModel genModel = gmd.get(this.getResourceSet());
            if (genModel == null) {
                if (uri == null) {
                    this.myStaleGenmodelStatus = Status.CANCEL_STATUS;
                    this.myGenModel = null;
                    return null;
                }
                IStatus notFound = Plugin.createError(Messages.GenModelDetector_e_not_found, null);
                throw new CoreException(notFound);
            }
            TransformToGenModelOperation.subTask((IProgressMonitor)monitor, 40, Messages.TransformToGenModelOperation_task_validate, cancelMessage);
            StaleGenModelDetector staleDetector = new StaleGenModelDetector(genModel);
            IStatus stale = staleDetector.detect();
            this.myGenModel = genModel;
            this.myStaleGenmodelStatus = stale;
            GenModel genModel2 = genModel;
            return genModel2;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            IStatus error = Plugin.createError(Messages.TransformToGenModelOperation_e_genmodel_load, e);
            throw new CoreException(error);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IStatus executeTransformation(IProgressMonitor pm) {
        SubProgressMonitor monitor = null;
        Diagnostic validation = Diagnostic.CANCEL_INSTANCE;
        try {
            if (this.getGenURI() == null) {
                throw new IllegalStateException(Messages.TransformToGenModelOperation_e_null_gmfgen_uri);
            }
            this.checkMapping();
            monitor = pm != null ? new SubProgressMonitor(pm, 1, 4) : new NullProgressMonitor();
            monitor.beginTask("", 100);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            VisualIdentifierDispenserProvider idDispenser = this.getVisualIdDispenser();
            idDispenser.acquire();
            GenModelProducer t = this.createGenModelProducer(idDispenser);
            monitor.subTask(Messages.TransformToGenModelOperation_task_generate);
            GenEditorGenerator genEditor = t.process(this.getMapping(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 20));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_reconcile);
            if (Plugin.needsReconcile()) {
                this.handlePreReconcileHooks(genEditor);
                this.reconcile(genEditor);
                this.handlePostReconcileHooks(genEditor);
            }
            if (this.hasExtensionTransformation(this.getMapping().eResource().getURI())) {
                this.executeExtensionTransformation(this.getMapping().eResource().getURI(), genEditor);
            }
            GenNamingMediatorImpl namer = new GenNamingMediatorImpl();
            namer.setMode(GenNamingMediatorImpl.Mode.COLLECT_NAMES);
            namer.traverse(genEditor);
            namer.setMode(GenNamingMediatorImpl.Mode.DISPENSE_NAMES);
            namer.traverse(genEditor);
            monitor.worked(20);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_save);
            this.save(genEditor);
            monitor.worked(20);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(Messages.TransformToGenModelOperation_task_validate);
            try {
                validation = ValidationHelper.validate((EObject)genEditor, true, (IProgressMonitor)monitor);
            }
            catch (RuntimeException re) {
                validation = BasicDiagnostic.toDiagnostic((Throwable)re);
            }
            if (8 != validation.getSeverity()) {
                idDispenser.release();
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException ex) {
            IStatus iStatus = ex.getStatus();
            return iStatus;
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message == null) {
                message = Messages.TransformToGenModelOperation_e_generator_creation;
            }
            IStatus iStatus = Plugin.createError(message, ex);
            return iStatus;
        }
        finally {
            this.setGMFGenValidationResult(validation);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected boolean hasExtensionTransformation(URI uri) {
        URI transfURI = uri.trimFileExtension().appendFileExtension("qvto");
        TransformationExecutor executor = new TransformationExecutor(transfURI);
        Diagnostic diag = executor.loadTransformation();
        return diag.getCode() == 0;
    }

    protected void executeExtensionTransformation(URI uri, GenEditorGenerator result) {
        URI transfURI = uri.trimFileExtension().appendFileExtension("qvto");
        TransformationExecutor executor = new TransformationExecutor(transfURI);
        ExecutionContextImpl context = new ExecutionContextImpl();
        executor.execute((ExecutionContext)context, new ModelExtent[]{new BasicModelExtent(Arrays.asList(result))});
    }

    protected void handlePreReconcileHooks(GenEditorGenerator result) {
        if (this.getOptions().getPreReconcileTransform() != null) {
            URI transfURI = URI.createURI((String)this.getOptions().getPreReconcileTransform().toExternalForm());
            TransformationExecutor executor = new TransformationExecutor(transfURI);
            ExecutionContextImpl context = new ExecutionContextImpl();
            executor.execute((ExecutionContext)context, new ModelExtent[]{new BasicModelExtent(Arrays.asList(result))});
        }
    }

    protected void handlePostReconcileHooks(GenEditorGenerator result) {
        if (this.getOptions().getPostReconcileTransform() != null) {
            URI transfURI = URI.createURI((String)this.getOptions().getPostReconcileTransform().toExternalForm());
            TransformationExecutor executor = new TransformationExecutor(transfURI);
            ExecutionContextImpl context = new ExecutionContextImpl();
            executor.execute((ExecutionContext)context, new ModelExtent[]{new BasicModelExtent(Arrays.asList(result))});
        }
    }

    private void checkMapping() {
        if (this.getMapping() == null) {
            throw new IllegalStateException(Messages.TransformToGenModelOperation_e_null_mapping);
        }
    }

    static IStatus getFirst(Diagnostic d) {
        if (d == null) {
            return Status.OK_STATUS;
        }
        List children = d.getChildren();
        if (children.isEmpty()) {
            return BasicDiagnostic.toIStatus((Diagnostic)d);
        }
        return BasicDiagnostic.toIStatus((Diagnostic)((Diagnostic)children.get(0)));
    }

    private DiagramRunTimeModelHelper detectRunTimeModel() {
        return new BasicDiagramRunTimeModelHelper();
    }

    private ViewmapProducer detectTransformationOptions() {
        URL[] uRLArray;
        boolean useModeledViewmaps;
        boolean bl = useModeledViewmaps = !this.getOptions().getUseInTransformationCodeGen();
        if (useModeledViewmaps) {
            return new ModeledViewmapProducer();
        }
        String runtimeToken = this.getOptions().getUseRuntimeFigures() ? "full" : "lite";
        MapModeCodeGenStrategy mmStrategy = this.getOptions().getUseMapMode() ? MapModeCodeGenStrategy.DYNAMIC : MapModeCodeGenStrategy.STATIC;
        URL dynamicFigureTemplates = this.getOptions().getFigureTemplatesPath();
        if (dynamicFigureTemplates == null) {
            uRLArray = null;
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = dynamicFigureTemplates;
        }
        return new InnerClassViewmapProducer(runtimeToken, mmStrategy, uRLArray);
    }

    private VisualIdentifierDispenserProvider getVisualIdDispenser() {
        return new VisualIdentifierDispenserProvider(this.getGenURI());
    }

    private GenModelProducer createGenModelProducer(VisualIdentifierDispenserProvider idDespenser) {
        if (this.getOptions().getMainTransformation() != null) {
            final ExecutionContextImpl context = new ExecutionContextImpl();
            context.setConfigProperty("rcp", (Object)this.getOptions().getGenerateRCP());
            context.setConfigProperty("useMapMode", (Object)this.getOptions().getUseMapMode());
            context.setConfigProperty("useFullRunTime", (Object)this.getOptions().getUseRuntimeFigures());
            context.setConfigProperty("useInTransformationCodeGen", (Object)this.getOptions().getUseInTransformationCodeGen());
            final QVTDiagramGenModelTransformer transformer = new QVTDiagramGenModelTransformer(this.getResourceSet(), idDespenser.get());
            transformer.setTransformationL(this.getOptions().getMainTransformation());
            return new GenModelProducer(){

                public GenEditorGenerator process(Mapping mapping, IProgressMonitor progress) throws CoreException {
                    progress.beginTask(null, 1);
                    try {
                        BasicModelExtent output = new BasicModelExtent();
                        ExecutionDiagnostic result = transformer.transform(mapping, TransformToGenModelOperation.this.getGenModel(), (ModelExtent)output, (ExecutionContext)context);
                        if (Plugin.printTransformationConsole()) {
                            System.err.println(result.getMessage());
                        }
                        if (result.getSeverity() == 0) {
                            List outObjects = output.getContents();
                            GenEditorGenerator genEditorGenerator = outObjects.get(0) instanceof GenEditorGenerator ? (GenEditorGenerator)outObjects.get(0) : null;
                            return genEditorGenerator;
                        }
                        throw new CoreException((IStatus)new Status(4, Plugin.getPluginID(), "Transformation has no out parameter of GenEditorGenerator type"));
                    }
                    finally {
                        progress.done();
                    }
                }
            };
        }
        DiagramRunTimeModelHelper drtModelHelper = this.detectRunTimeModel();
        ViewmapProducer viewmapProducer = this.detectTransformationOptions();
        DiagramGenModelTransformer.Parameters opts = new DiagramGenModelTransformer.Parameters(drtModelHelper, viewmapProducer, idDespenser.get(), this.getOptions().getGenerateRCP());
        final DiagramGenModelTransformer t = new DiagramGenModelTransformer(opts);
        if (this.getGenModel() != null) {
            t.setEMFGenModel(this.getGenModel());
        }
        return new GenModelProducer(){

            public GenEditorGenerator process(Mapping mapping, IProgressMonitor progress) {
                progress.beginTask(null, 1);
                try {
                    t.transform(mapping);
                    GenEditorGenerator genEditorGenerator = t.getResult();
                    return genEditorGenerator;
                }
                finally {
                    progress.done();
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reconcile(GenEditorGenerator genBurdern) {
        GenEditorGenerator old = null;
        Resource resource = null;
        try {
            try {
                EList contents;
                resource = this.getResourceSet().getResource(this.getGenURI(), false);
                if (resource == null) {
                    resource = this.getResourceSet().createResource(this.getGenURI(), "");
                    resource.load(this.getResourceSet().getLoadOptions());
                }
                if (!(contents = resource.getContents()).isEmpty() && contents.get(0) instanceof GenEditorGenerator) {
                    old = (GenEditorGenerator)contents.get(0);
                }
                if (old == null) return;
                new Reconciler((ReconcilerConfig)new GMFGenConfig()).reconcileTree((EObject)genBurdern, (EObject)old);
                return;
            }
            catch (IOException iOException) {
                if (resource == null) return;
                if (resource.isLoaded()) {
                    resource.unload();
                }
                this.getResourceSet().getResources().remove((Object)resource);
                return;
            }
            catch (RuntimeException e) {
                Plugin.log(e);
                old = null;
                if (resource == null) return;
                if (resource.isLoaded()) {
                    resource.unload();
                }
                this.getResourceSet().getResources().remove((Object)resource);
                return;
            }
        }
        finally {
            if (resource != null) {
                if (resource.isLoaded()) {
                    resource.unload();
                }
                this.getResourceSet().getResources().remove((Object)resource);
            }
        }
    }

    private void save(GenEditorGenerator genBurdern) throws IOException {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        Resource gmfgenRes = this.getResourceSet().getResource(this.getGenURI(), false);
        try {
            if (gmfgenRes == null) {
                gmfgenRes = this.getResourceSet().createResource(this.getGenURI(), "org.eclipse.gmf.gen");
                gmfgenRes.load(this.getResourceSet().getLoadOptions());
            }
            TransformToGenModelOperation.updateExistingResource(gmfgenRes, genBurdern);
            if (gmfgenRes.getContents().size() > 1 && Plugin.ignoreDanglingHrefOnSave()) {
                saveOptions.put("PROCESS_DANGLING_HREF", "RECORD");
            }
            gmfgenRes.save(saveOptions);
        }
        catch (IOException iOException) {
            gmfgenRes.getContents().add((Object)genBurdern);
            gmfgenRes.save(saveOptions);
        }
        catch (RuntimeException ex) {
            Plugin.log(ex);
            gmfgenRes.getContents().add((Object)genBurdern);
            gmfgenRes.save(saveOptions);
        }
    }

    private static void updateExistingResource(Resource gmfgenRes, GenEditorGenerator genBurden) {
        boolean editorGenFound = false;
        int i = 0;
        while (!editorGenFound && i < gmfgenRes.getContents().size()) {
            if (gmfgenRes.getContents().get(i) instanceof GenEditorGenerator) {
                if (gmfgenRes.getContents().size() > 1) {
                    LinkedList<EObject> rest = new LinkedList<EObject>((Collection<EObject>)gmfgenRes.getContents());
                    GenEditorGenerator oldEditorGenerator = (GenEditorGenerator)rest.remove(i);
                    TransformToGenModelOperation.updateExternalReferences(genBurden, oldEditorGenerator, rest);
                }
                gmfgenRes.getContents().set(i, (Object)genBurden);
                editorGenFound = true;
            }
            ++i;
        }
        if (!editorGenFound) {
            gmfgenRes.getContents().add((Object)genBurden);
        }
    }

    private static void updateExternalReferences(GenEditorGenerator newEditorGenerator, final GenEditorGenerator oldEditorGenerator, List<EObject> allContentButOldGenerator) {
        final Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences = new EcoreUtil.ExternalCrossReferencer(allContentButOldGenerator){
            private static final long serialVersionUID = 4383601037841211175L;

            protected boolean crossReference(EObject object, EReference reference, EObject crossReferencedEObject) {
                return super.crossReference(object, reference, crossReferencedEObject) && EcoreUtil.isAncestor((EObject)oldEditorGenerator, (EObject)crossReferencedEObject);
            }

            Map<EObject, Collection<EStructuralFeature.Setting>> find() {
                return this.findExternalCrossReferences();
            }
        }.find();
        new Reconciler((ReconcilerConfig)new GMFGenConfig()){

            protected void handleNotMatchedCurrent(EObject current) {
            }

            protected EObject handleNotMatchedOld(EObject currentParent, EObject notMatchedOld) {
                return null;
            }

            protected void reconcileVertex(EObject current, EObject old) {
                if (!crossReferences.containsKey(old)) {
                    return;
                }
                for (EStructuralFeature.Setting s : (Collection)crossReferences.get(old)) {
                    EcoreUtil.replace((EStructuralFeature.Setting)s, (Object)old, (Object)current);
                }
            }
        }.reconcileTree((EObject)newEditorGenerator, (EObject)oldEditorGenerator);
    }

    private static void subTask(IProgressMonitor monitor, int ticks, String name, String cancelMessage) throws CoreException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            IStatus cancel = Plugin.createCancel(cancelMessage);
            throw new CoreException(cancel);
        }
        if (ticks > 0) {
            monitor.worked(ticks);
        }
        if (name != null) {
            monitor.subTask(name);
        }
    }
}

