/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOPackageRegistryImpl
extends EPackageRegistryImpl
implements InternalCDOPackageRegistry {
    public static final EModelElement[] SYSTEM_ELEMENTS = new EModelElement[8];
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOPackageRegistryImpl.class);
    private static final long serialVersionUID = 1L;
    private static final boolean eagerInternalCaches = false;
    private boolean replacingDescriptors;
    private InternalCDOPackageRegistry.PackageProcessor packageProcessor;
    private InternalCDOPackageRegistry.PackageLoader packageLoader;
    private transient boolean active;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOPackageInfo[] packageInfos;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOPackageUnit[] packageUnits;
    @ReflectUtil.ExcludeFromDump
    private transient Map<EClass, List<EClass>> subTypes;
    private Map<Enumerator, EEnumLiteral> enumLiterals = new HashMap<Enumerator, EEnumLiteral>();
    private Set<CDOPackageInfo> visitedPackages = new HashSet<CDOPackageInfo>();
    private Map<EPackage, InternalCDOPackageInfo> packageInfoMap = new HashMap<EPackage, InternalCDOPackageInfo>();
    static int lockCount;

    @Override
    public boolean isReplacingDescriptors() {
        return this.replacingDescriptors;
    }

    @Override
    public void setReplacingDescriptors(boolean replacingDescriptors) {
        this.replacingDescriptors = replacingDescriptors;
    }

    @Override
    public InternalCDOPackageRegistry.PackageProcessor getPackageProcessor() {
        return this.packageProcessor;
    }

    @Override
    public void setPackageProcessor(InternalCDOPackageRegistry.PackageProcessor packageProcessor) {
        this.packageProcessor = packageProcessor;
    }

    @Override
    public InternalCDOPackageRegistry.PackageLoader getPackageLoader() {
        return this.packageLoader;
    }

    @Override
    public void setPackageLoader(InternalCDOPackageRegistry.PackageLoader packageLoader) {
        LifecycleUtil.checkInactive((Object)this);
        this.packageLoader = packageLoader;
    }

    public Object get(Object key) {
        LifecycleUtil.checkActive((Object)this);
        return super.get(key);
    }

    @Override
    public synchronized Set<String> getAllKeys() {
        LifecycleUtil.checkActive((Object)this);
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.keySet());
        if (this.delegateRegistry != null) {
            if (this.delegateRegistry instanceof InternalCDOPackageRegistry) {
                result.addAll(((InternalCDOPackageRegistry)this.delegateRegistry).getAllKeys());
            } else {
                result.addAll(this.delegateRegistry.keySet());
            }
        }
        return result;
    }

    @Override
    public synchronized Object getWithDelegation(String nsURI, boolean resolve) {
        LifecycleUtil.checkActive((Object)this);
        Object result = CDOPackageRegistryImpl.getFrom(this, nsURI, resolve);
        if (result == null && this.delegateRegistry != null) {
            result = CDOPackageRegistryImpl.getFrom(this.delegateRegistry, nsURI, resolve);
        }
        return result;
    }

    private static Object getFrom(EPackage.Registry registry, String nsURI, boolean resolve) {
        if (resolve) {
            return registry.getEPackage(nsURI);
        }
        return registry.get((Object)nsURI);
    }

    @Override
    public synchronized Object basicPut(String nsURI, Object value) {
        Object oldValue;
        LifecycleUtil.checkActive((Object)this);
        if (TRACER.isEnabled()) {
            TRACER.format("Registering {0} --> {1}", new Object[]{nsURI, value});
        }
        if (this.packageProcessor != null) {
            value = this.packageProcessor.processPackage(value);
        }
        if ((oldValue = this.get(nsURI)) instanceof InternalCDOPackageInfo && value instanceof EPackage) {
            InternalCDOPackageInfo oldPackageInfo = (InternalCDOPackageInfo)oldValue;
            EPackage newValue = (EPackage)value;
            if (oldPackageInfo.getEPackage(false) == null) {
                this.registerPackageInfo(newValue, oldPackageInfo);
                oldPackageInfo.getPackageUnit().setState(CDOPackageUnit.State.LOADED);
            }
        } else if (oldValue instanceof EPackage && value instanceof InternalCDOPackageInfo) {
            EPackage oldPackage = (EPackage)oldValue;
            InternalCDOPackageInfo oldPackageInfo = this.getPackageInfo(oldPackage);
            InternalCDOPackageInfo newPackageInfo = (InternalCDOPackageInfo)value;
            InternalCDOPackageUnit oldPackageUnit = oldPackageInfo.getPackageUnit();
            InternalCDOPackageUnit newPackageUnit = newPackageInfo.getPackageUnit();
            if (oldPackageUnit.getState() == CDOPackageUnit.State.NEW && newPackageUnit.getState() != CDOPackageUnit.State.NEW) {
                oldPackageUnit.setState(CDOPackageUnit.State.LOADED);
            }
            return null;
        }
        return super.put((Object)nsURI, value);
    }

    public synchronized Object put(String nsURI, Object value) {
        EPackage ePackage;
        InternalCDOPackageInfo packageInfo;
        LifecycleUtil.checkActive((Object)this);
        if (this.replacingDescriptors && value instanceof EPackage.Descriptor) {
            EPackage.Descriptor descriptor = (EPackage.Descriptor)value;
            value = descriptor.getEPackage();
        }
        if (value instanceof EPackage && (packageInfo = this.getPackageInfo(ePackage = (EPackage)value)) == null) {
            this.initPackageUnit(ePackage);
            return null;
        }
        return this.basicPut(nsURI, value);
    }

    @Override
    public synchronized Object putEPackage(EPackage ePackage) {
        LifecycleUtil.checkActive((Object)this);
        return this.put(ePackage.getNsURI(), (Object)ePackage);
    }

    @Override
    public synchronized void putPackageUnit(InternalCDOPackageUnit packageUnit) {
        LifecycleUtil.checkActive((Object)this);
        packageUnit.setPackageRegistry(this);
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
        int n = internalCDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage(false);
            if (ePackage != null) {
                this.registerPackageInfo(ePackage, packageInfo);
                this.basicPut(ePackage.getNsURI(), ePackage);
            } else {
                this.basicPut(packageInfo.getPackageURI(), packageInfo);
            }
            ++n2;
        }
        this.resetInternalCaches();
    }

    @Override
    public synchronized void putPackageUnits(InternalCDOPackageUnit[] packageUnits, CDOPackageUnit.State state) {
        LifecycleUtil.checkActive((Object)this);
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            if (state != null) {
                packageUnit.setState(state);
            }
            this.putPackageUnit(packageUnit);
            ++n2;
        }
    }

    @Override
    public synchronized void registerPackageInfo(EPackage ePackage, InternalCDOPackageInfo packageInfo) {
        packageInfo.setEPackage(ePackage);
        this.packageInfoMap.put(ePackage, packageInfo);
    }

    @Override
    public synchronized InternalCDOPackageInfo getPackageInfo(EPackage ePackage) {
        InternalCDOPackageInfo packageInfo;
        LifecycleUtil.checkActive((Object)this);
        Object object = this.get(ePackage.getNsURI());
        if (object instanceof InternalCDOPackageInfo && (packageInfo = (InternalCDOPackageInfo)object).getPackageUnit().getPackageRegistry() == this) {
            return packageInfo;
        }
        return this.packageInfoMap.get(ePackage);
    }

    @Override
    public synchronized InternalCDOPackageInfo[] getPackageInfos() {
        LifecycleUtil.checkActive((Object)this);
        if (this.packageInfos == null) {
            ArrayList<InternalCDOPackageInfo> result = new ArrayList<InternalCDOPackageInfo>();
            for (Object value : this.values()) {
                InternalCDOPackageInfo packageInfo;
                if (value instanceof InternalCDOPackageInfo) {
                    result.add((InternalCDOPackageInfo)value);
                    continue;
                }
                if (!(value instanceof EPackage) || (packageInfo = this.getPackageInfo((EPackage)value)) == null) continue;
                result.add(packageInfo);
            }
            this.packageInfos = result.toArray(new InternalCDOPackageInfo[result.size()]);
            Arrays.sort(this.packageInfos);
        }
        return this.packageInfos;
    }

    @Override
    public synchronized InternalCDOPackageUnit getPackageUnit(EPackage ePackage) {
        LifecycleUtil.checkActive((Object)this);
        InternalCDOPackageInfo packageInfo = this.getPackageInfo(ePackage);
        if (packageInfo == null) {
            this.putEPackage(ePackage);
            packageInfo = this.getPackageInfo(ePackage);
            if (packageInfo == null) {
                throw new ImplementationError(MessageFormat.format(Messages.getString("CDOPackageRegistryImpl.0"), ePackage));
            }
        }
        return (InternalCDOPackageUnit)packageInfo.getPackageUnit();
    }

    @Override
    public synchronized InternalCDOPackageUnit getPackageUnit(String id) {
        LifecycleUtil.checkActive((Object)this);
        for (Object value : this.values()) {
            InternalCDOPackageInfo packageInfo;
            InternalCDOPackageUnit packageUnit = null;
            if (value instanceof InternalCDOPackageInfo) {
                packageUnit = ((InternalCDOPackageInfo)value).getPackageUnit();
            } else if (value instanceof EPackage && (packageInfo = this.getPackageInfo((EPackage)value)) != null) {
                packageUnit = packageInfo.getPackageUnit();
            }
            if (packageUnit == null || !id.equals(packageUnit.getID())) continue;
            return packageUnit;
        }
        return null;
    }

    @Override
    public synchronized InternalCDOPackageUnit[] getPackageUnits(long startTime, long endTime) {
        LifecycleUtil.checkActive((Object)this);
        if (endTime == 0L) {
            endTime = Long.MAX_VALUE;
        }
        HashSet<InternalCDOPackageUnit> result = new HashSet<InternalCDOPackageUnit>();
        for (Object value : this.values()) {
            long timeStamp;
            InternalCDOPackageInfo packageInfo;
            InternalCDOPackageUnit packageUnit = null;
            if (value instanceof InternalCDOPackageInfo) {
                packageUnit = ((InternalCDOPackageInfo)value).getPackageUnit();
            } else if (value instanceof EPackage && (packageInfo = this.getPackageInfo((EPackage)value)) != null) {
                packageUnit = packageInfo.getPackageUnit();
            }
            if (packageUnit == null || startTime > (timeStamp = packageUnit.getTimeStamp()) || timeStamp > endTime) continue;
            result.add(packageUnit);
        }
        return result.toArray(new InternalCDOPackageUnit[result.size()]);
    }

    @Override
    public synchronized InternalCDOPackageUnit[] getPackageUnits(boolean withSystemPackages) {
        LifecycleUtil.checkActive((Object)this);
        return this.collectPackageUnits(withSystemPackages);
    }

    @Override
    public synchronized InternalCDOPackageUnit[] getPackageUnits() {
        LifecycleUtil.checkActive((Object)this);
        if (this.packageUnits == null) {
            this.packageUnits = this.collectPackageUnits(true);
            Arrays.sort(this.packageUnits);
        }
        return this.packageUnits;
    }

    private InternalCDOPackageUnit[] collectPackageUnits(boolean withSystemPackages) {
        HashSet<InternalCDOPackageUnit> result = new HashSet<InternalCDOPackageUnit>();
        for (Object value : this.values()) {
            InternalCDOPackageUnit packageUnit = this.collectPackageUnit(value);
            if (packageUnit == null || !withSystemPackages && packageUnit.isSystem()) continue;
            result.add(packageUnit);
        }
        return result.toArray(new InternalCDOPackageUnit[result.size()]);
    }

    private InternalCDOPackageUnit collectPackageUnit(Object value) {
        InternalCDOPackageInfo packageInfo;
        if (value instanceof InternalCDOPackageInfo) {
            return ((InternalCDOPackageInfo)value).getPackageUnit();
        }
        if (value instanceof EPackage && (packageInfo = this.getPackageInfo((EPackage)value)) != null) {
            InternalCDOPackageUnit packageUnit = packageInfo.getPackageUnit();
            return packageUnit;
        }
        return null;
    }

    @Override
    public synchronized EPackage[] getEPackages() {
        LifecycleUtil.checkActive((Object)this);
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (String packageURI : this.keySet()) {
            EPackage ePackage = this.getEPackage(packageURI);
            if (ePackage == null) continue;
            result.add(ePackage);
        }
        return result.toArray(new EPackage[result.size()]);
    }

    @Override
    public synchronized EEnumLiteral getEnumLiteralFor(Enumerator value) {
        LifecycleUtil.checkActive((Object)this);
        EEnumLiteral result = this.enumLiterals.get(value);
        if (result != null) {
            return result;
        }
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.getPackageUnits();
        int n = internalCDOPackageUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            CDOPackageInfo[] cDOPackageInfoArray = packageUnit.getPackageInfos();
            int n3 = cDOPackageInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CDOPackageInfo packageInfo = cDOPackageInfoArray[n4];
                if (this.visitedPackages.add(packageInfo) && (result = this.visitPackage(packageInfo, value)) != null) {
                    return result;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private EEnumLiteral visitPackage(CDOPackageInfo packageInfo, Enumerator value) {
        EEnumLiteral result = null;
        for (EClassifier classifier : packageInfo.getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EEnum)) continue;
            EEnum eenum = (EEnum)classifier;
            for (EEnumLiteral eEnumLiteral : eenum.getELiterals()) {
                Enumerator instance = eEnumLiteral.getInstance();
                this.enumLiterals.put(instance, eEnumLiteral);
                if (instance != value) continue;
                result = eEnumLiteral;
            }
        }
        return result;
    }

    @Override
    public synchronized Map<EClass, List<EClass>> getSubTypes() {
        LifecycleUtil.checkActive((Object)this);
        if (this.subTypes == null) {
            this.subTypes = CDOModelUtil.getSubTypes(this);
        }
        return this.subTypes;
    }

    public String toString() {
        return "PackageRegistry";
    }

    public void addListener(IListener listener) {
    }

    public void removeListener(IListener listener) {
    }

    public IListener[] getListeners() {
        return EventUtil.NO_LISTENERS;
    }

    public boolean hasListeners() {
        return false;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized LifecycleState getLifecycleState() {
        return this.active ? LifecycleState.ACTIVE : LifecycleState.INACTIVE;
    }

    public synchronized void activate() throws LifecycleException {
        if (!this.active) {
            CheckUtil.checkState((Object)this.packageLoader, (String)"packageLoader");
            this.active = true;
        }
    }

    public synchronized Exception deactivate() {
        if (this.active) {
            try {
                this.packageInfoMap.clear();
                this.disposePackageUnits();
                this.clear();
                this.active = false;
            }
            catch (RuntimeException ex) {
                return ex;
            }
        }
        return null;
    }

    protected void disposePackageUnits() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.getPackageUnits();
        int n = internalCDOPackageUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            packageUnit.dispose();
            ++n2;
        }
        this.packageInfos = null;
        this.packageUnits = null;
        this.subTypes = null;
    }

    protected void initPackageUnit(EPackage ePackage) {
        InternalCDOPackageUnit packageUnit = this.createPackageUnit();
        packageUnit.init(ePackage);
        this.resetInternalCaches();
    }

    protected void resetInternalCaches() {
        this.packageInfos = null;
        this.packageUnits = null;
        this.subTypes = null;
    }

    @Override
    public InternalCDOPackageUnit createPackageUnit() {
        InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
        packageUnit.setPackageRegistry(this);
        return packageUnit;
    }
}

