/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IPageModelFactory;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.DiContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.PageMngrImpl;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;

public class DiSashModelMngr {
    protected SashWindowsMngr sashWindowMngr;
    private PageMngrImpl pageMngr = null;
    private DiContentProvider contentProvider;
    protected ContentChangedEventProvider contentChangedEventProvider;
    private IPageModelFactory pageModelFactory;

    protected DiSashModelMngr(IPageModelFactory pageModelFactory, boolean createDefaultSashModel) {
        this.pageModelFactory = pageModelFactory;
        if (createDefaultSashModel) {
            this.sashWindowMngr = this.createDefaultSashModel();
        }
    }

    public DiSashModelMngr(IPageModelFactory pageModelFactory) {
        this.pageModelFactory = pageModelFactory;
        this.sashWindowMngr = this.createDefaultSashModel();
    }

    public DiSashModelMngr(IPageModelFactory pageModelFactory, Resource diResource) {
        this.pageModelFactory = pageModelFactory;
        this.sashWindowMngr = this.lookupSashWindowMngr(diResource);
        if (this.sashWindowMngr == null) {
            this.sashWindowMngr = this.createDefaultSashModel();
            diResource.getContents().add((Object)this.sashWindowMngr);
        }
    }

    public DiSashModelMngr(IPageModelFactory pageModelFactory, SashWindowsMngr sashModel) {
        this.pageModelFactory = pageModelFactory;
        this.sashWindowMngr = sashModel;
    }

    protected SashWindowsMngr getDiSashWindowsMngr() {
        return this.sashWindowMngr;
    }

    protected final DiContentProvider getDiContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new DiContentProvider(this.sashWindowMngr.getSashModel(), this.pageModelFactory, this.getContentChangedEventProvider());
        }
        return this.contentProvider;
    }

    protected final PageMngrImpl getPageMngrImpl() {
        if (this.pageMngr == null) {
            this.pageMngr = new PageMngrImpl(this.sashWindowMngr, this.getContentChangedEventProvider());
        }
        return this.pageMngr;
    }

    protected final ContentChangedEventProvider getContentChangedEventProvider() {
        if (this.contentChangedEventProvider == null) {
            this.contentChangedEventProvider = new ContentChangedEventProvider(this.sashWindowMngr);
        }
        return this.contentChangedEventProvider;
    }

    public IPageMngr getIPageMngr() {
        return this.getPageMngrImpl();
    }

    public ISashWindowsContentProvider getISashWindowsContentProvider() {
        return this.getDiContentProvider();
    }

    public IContentChangedProvider getSashModelContentChangedProvider() {
        return this.getContentChangedEventProvider();
    }

    protected SashWindowsMngr createDefaultSashModel() {
        return DiUtils.createDefaultSashWindowsMngr();
    }

    protected SashWindowsMngr lookupSashWindowMngr(Resource diResource) {
        return DiUtils.lookupSashWindowsMngr(diResource);
    }

    public static IPageMngr createIPageMngr(Resource diResource) {
        return new DiSashModelMngr(null, diResource).getIPageMngr();
    }
}

