/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client.rest;

import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PermissionLabel;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccountInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.LabelInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RevisionInfo;

public class ChangeInfo {
    private String kind;
    private String id;
    private String project;
    private String branch;
    private String change_id;
    private String subject;
    private Change.Status status;
    private Timestamp created;
    private Timestamp updated;
    private boolean reviewed;
    private boolean mergeable;
    private AccountInfo owner;
    private Map<String, LabelInfo> labels;
    private String current_revision;
    private Map<String, RevisionInfo> revisions;
    private Map<String, String[]> permitted_labels;
    private String _sortkey;
    private int _number;

    public String getKind() {
        return this.kind;
    }

    public String getId() {
        return this.id;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getChangeId() {
        return this.change_id;
    }

    public String getSubject() {
        return this.subject;
    }

    public Change.Status getStatus() {
        return this.status;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public boolean isReviewed() {
        return this.reviewed;
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public AccountInfo getOwner() {
        return this.owner;
    }

    public Map<String, LabelInfo> getLabels() {
        return this.labels;
    }

    public String getCurrentRevision() {
        return this.current_revision;
    }

    public Map<String, RevisionInfo> getRevisions() {
        return this.revisions;
    }

    public Map<String, String[]> getPermittedLabels() {
        return this.permitted_labels;
    }

    private PatchSet.Id getCurrentPatchSetId() {
        Change.Id changeId = new Change.Id(this._number);
        int patchSetId = this.revisions.get(this.current_revision).getNumber();
        return new PatchSet.Id(changeId, patchSetId);
    }

    public Set<ApprovalDetail> convertToApprovalDetails() {
        if (this.labels == null) {
            return Collections.emptySet();
        }
        HashSet<ApprovalDetail> result = new HashSet<ApprovalDetail>();
        for (Map.Entry<String, LabelInfo> entry : this.labels.entrySet()) {
            ApprovalCategory.Id approvalCategoryId;
            List<ApprovalInfo> all = entry.getValue().getAll();
            if (all == null || (approvalCategoryId = ApprovalUtil.findCategoryIdByNameWithDash(entry.getKey())) == null) continue;
            for (ApprovalInfo approvalInfo : all) {
                Account.Id accountId = new Account.Id(approvalInfo.getId());
                ApprovalDetail approvalDetail = new ApprovalDetail(accountId);
                approvalDetail.add(new PatchSetApproval(new PatchSetApproval.Key(this.getCurrentPatchSetId(), accountId, approvalCategoryId), approvalInfo.getValue()));
                result.add(approvalDetail);
            }
        }
        return result;
    }

    public Set<ApprovalType> convertToApprovalTypes() {
        if (this.labels == null) {
            return null;
        }
        HashSet<ApprovalType> result = new HashSet<ApprovalType>();
        for (Map.Entry<String, LabelInfo> entry : this.labels.entrySet()) {
            ApprovalCategory approvalCategory = ApprovalUtil.findCategoryByNameWithDash(entry.getKey());
            ArrayList<ApprovalCategoryValue> valueList = new ArrayList<ApprovalCategoryValue>();
            for (Map.Entry<String, String> valueEntry : entry.getValue().getValues().entrySet()) {
                valueList.add(new ApprovalCategoryValue(new ApprovalCategoryValue.Id(approvalCategory.getId(), ApprovalUtil.parseShort(valueEntry.getKey())), valueEntry.getValue()));
            }
            ApprovalType approvalType = new ApprovalType(approvalCategory, valueList);
            result.add(approvalType);
        }
        return result;
    }

    public List<PermissionLabel> convertToPermissionLabels() {
        if (this.permitted_labels == null) {
            return null;
        }
        ArrayList<PermissionLabel> result = new ArrayList<PermissionLabel>(this.permitted_labels.size());
        for (Map.Entry<String, String[]> entry : this.permitted_labels.entrySet()) {
            ArrayList<Short> values = new ArrayList<Short>(entry.getValue().length);
            String[] stringArray = entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                values.add(ApprovalUtil.parseShort(value));
                ++n2;
            }
            PermissionLabel label = new PermissionLabel();
            label.setName(PermissionLabel.toLabelName(entry.getKey()));
            label.setMin(((Short)Collections.min(values)).shortValue());
            label.setMax(((Short)Collections.max(values)).shortValue());
            result.add(label);
        }
        return result;
    }
}

