/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.model.queries;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetStyleSheets
implements IJavaModelQuery<Element, Collection<StyleSheet>> {
    public Collection<StyleSheet> evaluate(Element context, ParameterValueList args) throws ModelQueryExecutionException {
        ResourceSet resourceSet = context.eResource().getResourceSet();
        if (resourceSet == null) {
            return this.findStyleSheets(context.eResource());
        }
        LinkedList<StyleSheet> result = new LinkedList<StyleSheet>();
        for (Resource resource : context.eResource().getResourceSet().getResources()) {
            result.addAll(this.findStyleSheets(resource));
        }
        return result;
    }

    private Collection<StyleSheet> findStyleSheets(Resource eResource) {
        LinkedList<StyleSheet> result = new LinkedList<StyleSheet>();
        for (EObject rootElement : eResource.getContents()) {
            if (!(rootElement instanceof StyleSheet)) continue;
            result.add((StyleSheet)rootElement);
        }
        return result;
    }
}

