/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.actions.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.uml.diagram.common.actions.AbstractShowHideAction;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractShowHideHandler
extends AbstractHandler {
    private AbstractShowHideAction action = null;
    private final String editpolicy;
    private final List<IGraphicalEditPart> selection = new ArrayList<IGraphicalEditPart>();

    public AbstractShowHideHandler(AbstractShowHideAction action, String key) {
        this.action = action;
        this.editpolicy = key;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.selection.isEmpty()) {
            this.action.setSelection(this.selection);
            this.action.run(null);
        }
        return null;
    }

    public boolean isEnabled() {
        this.buildSelection();
        return !this.selection.isEmpty();
    }

    protected void buildSelection() {
        this.selection.clear();
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selectionTmp = selectionService.getSelection();
        if (selectionTmp != null && !selectionTmp.isEmpty() && selectionTmp instanceof StructuredSelection) {
            for (Object current : (StructuredSelection)selectionTmp) {
                EditPolicy editpolicy;
                if (!(current instanceof IGraphicalEditPart) || (editpolicy = ((IGraphicalEditPart)current).getEditPolicy((Object)this.editpolicy)) == null) continue;
                this.selection.add((IGraphicalEditPart)current);
            }
        }
    }
}

