/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ApplyStereotypeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.HTMLCornerBentFigure;
import org.eclipse.papyrus.uml.diagram.common.service.ApplyStereotypeRequest;
import org.eclipse.swt.graphics.Color;

public class AbstractCommentEditPart
extends NodeEditPart {
    public AbstractCommentEditPart(View view) {
        super(view);
    }

    public IPapyrusNodeFigure getPrimaryShape() {
        return new HTMLCornerBentFigure();
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshFontColor();
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy(ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST, (EditPolicy)new ApplyStereotypeEditPolicy());
    }

    protected void refreshTransparency() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style.getGradient() != null) {
            this.setTransparency(style.getTransparency());
        } else {
            this.setTransparency(0);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFontColor();
    }

    protected void refreshFontColor() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
        if (style != null) {
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getFontColor())));
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void setForegroundColor(Color color) {
        this.getPrimaryShape().setBorderColor(color);
    }
}

