/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CornerBentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.HTMLCommentParser;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.uml.diagram.common.parser.HTMLCleaner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLCornerBentFigure
extends CornerBentFigure
implements ILabelFigure,
IMultilineEditableFigure {
    protected boolean useLocalCoordinates = false;
    static final Color THIS_BACK = new Color(null, 248, 249, 214);
    static final Font FCORNERBENTCONTENTLABEL_FONT = new Font((Device)Display.getCurrent(), "Arial", 8, 0);
    private static final String FONT_NAME = "face";
    private static final String FONT_SIZE = "size";
    protected FlowPage page;
    protected Stack<Styles> textProperties = new Stack();
    private FontData currentFontData;
    private String text = "";
    private Set<FontData> cachedFontDatas = new HashSet<FontData>();

    public HTMLCornerBentFigure() {
        this.setBackgroundColor(THIS_BACK);
        this.createContents();
    }

    public Label getIconLabel() {
        return this.iconLabel;
    }

    protected void createContents() {
        this.page = new FlowPage();
        this.page.setForegroundColor(this.getForegroundColor());
        this.add((IFigure)this.page);
    }

    protected boolean useLocalCoordinates() {
        return this.useLocalCoordinates;
    }

    public HTMLCornerBentFigure getCornerBentFigure() {
        return this;
    }

    public Image getIcon() {
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(Image icon) {
    }

    public void setText(String text) {
        if (HTMLCornerBentFigure.equals(text, this.text)) {
            return;
        }
        this.text = text;
        this.page.removeAll();
        this.currentFontData = new FontData("Wingdings", 8, 0);
        this.generateBlockForText(text, this.page);
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2.equals(s1);
    }

    protected void generateBlockForText(String text, FlowPage page) {
        NodeList nodeList = this.generateNodeList("<body>" + text + "</body>");
        if (nodeList.getLength() > 0) {
            this.generateBlocksFromNodeList(nodeList, (BlockFlow)page);
        } else {
            TextFlowEx textFlow = new TextFlowEx(text);
            page.add((IFigure)textFlow);
        }
    }

    protected void generateBlocksFromNodeList(NodeList nodeList, BlockFlow parentFlow) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            short nodeType = node.getNodeType();
            if (nodeType == 3) {
                this.generateTextFromTextNode(node, parentFlow);
            } else {
                switch (HTMLTags.valueOf(nodeName)) {
                    case body: {
                        this.generateBlocksFromBodyNode(node, parentFlow);
                        break;
                    }
                    case h3: {
                        this.generateBlocksFromH3Node(node, parentFlow);
                        break;
                    }
                    case h4: {
                        this.generateBlocksFromH4Node(node, parentFlow);
                        break;
                    }
                    case h5: {
                        this.generateBlocksFromH5Node(node, parentFlow);
                        break;
                    }
                    case strong: {
                        this.generateBlocksFromStrongNode(node, parentFlow);
                        break;
                    }
                    case em: {
                        this.generateBlocksFromItalicNode(node, parentFlow);
                        break;
                    }
                    case u: {
                        this.generateBlocksFromUnderlineNode(node, parentFlow);
                        break;
                    }
                    case sub: {
                        break;
                    }
                    case sup: {
                        break;
                    }
                    case blockquote: {
                        break;
                    }
                    case table: {
                        break;
                    }
                    case p: {
                        this.generateBlocksFromParagraphNode(node, parentFlow);
                        break;
                    }
                    case br: {
                        this.generateBlocksFromBRNode(node, parentFlow);
                        break;
                    }
                    case font: {
                        this.generateBlocksForFontNode(node, parentFlow);
                    }
                }
            }
            ++i;
        }
    }

    protected void generateBlocksFromUnderlineNode(Node node, BlockFlow parentFlow) {
        NodeList childrenNodes = node.getChildNodes();
        this.textProperties.push(Styles.underline);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow);
        this.textProperties.pop();
    }

    protected void generateTextFromTextNode(Node node, BlockFlow parentFlow) {
        FontData fontData;
        String text = HTMLCleaner.cleanHTMLTags(node.getNodeValue());
        TextFlowEx textFlow = new TextFlowEx(text);
        textFlow.setTextUnderline(false);
        boolean italic = false;
        boolean strong = false;
        boolean quote = false;
        boolean codeSample = false;
        String fontName = "Arial";
        int fontSize = 2;
        for (Styles style : this.textProperties) {
            switch (style) {
                case italic: {
                    italic = true;
                    break;
                }
                case strong: {
                    strong = true;
                    break;
                }
                case underline: {
                    textFlow.setTextUnderline(true);
                    break;
                }
                case quote: {
                    quote = true;
                    break;
                }
                case code: {
                    codeSample = true;
                    break;
                }
                case font: {
                    fontName = Styles.font.getData().get(FONT_NAME) != null ? (String)Styles.font.getData().get(FONT_NAME) : "Arial";
                    fontSize = Styles.font.getData().get(FONT_SIZE) != null ? (Integer)Styles.font.getData().get(FONT_SIZE) : 2;
                    break;
                }
            }
        }
        int style = 0;
        if (italic) {
            style |= 2;
        }
        if (strong) {
            style |= 1;
        }
        if (codeSample) {
            fontData = new FontData("Lucida Console", 8, style);
        } else if (quote) {
            fontData = new FontData("Monotype Corsiva", 10, style);
            textFlow.setBackgroundColor(DisplayUtils.getDisplay().getSystemColor(3));
        } else {
            fontData = new FontData(fontName, 2 * fontSize + 4, style);
        }
        Font font = (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)fontData));
        textFlow.setFont(font);
        parentFlow.add((IFigure)textFlow);
    }

    protected void generateBlocksFromStrongNode(Node node, BlockFlow parentFlow) {
        NodeList childrenNodes = node.getChildNodes();
        this.textProperties.push(Styles.strong);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow);
        this.textProperties.pop();
    }

    protected void generateBlocksFromItalicNode(Node node, BlockFlow parentFlow) {
        NodeList childrenNodes = node.getChildNodes();
        this.textProperties.push(Styles.italic);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow);
        this.textProperties.pop();
    }

    protected void generateBlocksForFontNode(Node node, BlockFlow parentFlow) {
        Node fontNameNode = node.getAttributes().getNamedItem(FONT_NAME);
        Node fontSizeNode = node.getAttributes().getNamedItem(FONT_SIZE);
        String oldFont = "";
        int oldSize = 8;
        if (fontNameNode != null) {
            String fontName = fontNameNode.getNodeValue();
            oldFont = Styles.font.getData().get(FONT_NAME) != null ? (String)Styles.font.getData().get(FONT_NAME) : "Arial";
            Styles.font.getData().put(FONT_NAME, fontName);
            this.textProperties.push(Styles.font);
        }
        if (fontSizeNode != null) {
            int fontSize = Integer.parseInt(fontSizeNode.getNodeValue());
            oldSize = Styles.font.getData().get(FONT_SIZE) != null ? (Integer)Styles.font.getData().get(FONT_SIZE) : 2;
            Styles.font.getData().put(FONT_SIZE, fontSize);
            this.textProperties.push(Styles.font);
        }
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, parentFlow);
        if (fontNameNode != null) {
            Styles.font.getData().put(FONT_NAME, oldFont);
            this.textProperties.pop();
        }
        if (fontSizeNode != null) {
            Styles.font.getData().put(FONT_SIZE, oldSize);
            this.textProperties.pop();
        }
    }

    protected void generateBlocksFromH3Node(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        this.textProperties.push(Styles.header3);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow);
        this.textProperties.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromH4Node(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        this.textProperties.push(Styles.header4);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow);
        this.textProperties.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromH5Node(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        this.textProperties.push(Styles.header5);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow);
        this.textProperties.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    private void debug(NodeList childNodes) {
        int i = 0;
        while (i < childNodes.getLength()) {
            System.err.println("[" + i + "] " + childNodes.item(i).getNodeName());
            ++i;
        }
    }

    protected void generateBlocksFromBodyNode(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, blockFlow);
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromParagraphNode(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        NamedNodeMap attributes = node.getAttributes();
        Node classNode = attributes.getNamedItem("class");
        boolean hasToPop = false;
        if (classNode != null) {
            String classNodeValue = classNode.getNodeValue();
            if ("codeSample".equals(classNodeValue)) {
                hasToPop = true;
                this.textProperties.push(Styles.code);
            } else if ("quote".equals(classNodeValue)) {
                this.textProperties.push(Styles.quote);
                hasToPop = true;
            }
        }
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, blockFlow);
        if (hasToPop) {
            this.textProperties.pop();
        }
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromBRNode(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        parentFlow.add((IFigure)blockFlow);
    }

    protected NodeList generateNodeList(String text) {
        return HTMLCommentParser.parse(text);
    }

    public Point getEditionLocation() {
        return this.getBounds().getTopLeft();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HTMLTags {
        body(""),
        h3(""),
        h4(""),
        h5(""),
        strong(""),
        em(""),
        u(""),
        sub(""),
        sup(""),
        blockquote(""),
        table(""),
        p(""),
        br(""),
        font("");

        protected String data;

        private HTMLTags(String data) {
            this.data = data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getData() {
            return this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Styles {
        strong,
        header3,
        header4,
        header5,
        underline,
        italic,
        code,
        subscript,
        supscript,
        quote,
        font(new HashMap<String, Object>());

        private Map<String, Object> data;

        private Styles() {
            this.data = null;
        }

        private Styles(Map<String, Object> data) {
            this.data = data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

