/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurationObservationHelper {
    private static final String DURATION_OBSERVATION_LABEL_FORMAT = "&%s";

    public static List<DurationObservation> getDurationObservationsBetween(NamedElement element1, NamedElement element2) {
        List<DurationObservation> referencing1 = DurationObservationHelper.getDurationObservationsOn(element1);
        List<DurationObservation> referencing2 = DurationObservationHelper.getDurationObservationsOn(element2);
        referencing1.retainAll(referencing2);
        return referencing1;
    }

    public static List<DurationObservation> getDurationObservationsOn(NamedElement element) {
        Collection inverseReferences = EMFHelper.getUsages((EObject)element);
        LinkedList<DurationObservation> referencing1 = new LinkedList<DurationObservation>();
        for (EStructuralFeature.Setting ref : inverseReferences) {
            if (!UMLPackage.eINSTANCE.getDurationObservation_Event().equals(ref.getEStructuralFeature()) || ref.getEObject().eContainer() == null) continue;
            referencing1.add((DurationObservation)ref.getEObject());
        }
        return referencing1;
    }

    public static String getLabelString(DurationObservation observation) {
        return String.format(DURATION_OBSERVATION_LABEL_FORMAT, observation.getName());
    }

    public static boolean endsOfSameMessage(OccurrenceSpecification occurrence, OccurrenceSpecification occurrence2) {
        return DurationConstraintHelper.endsOfSameMessage(occurrence, occurrence2);
    }
}

