/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.listeners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DropTargetListener
extends DiagramDropTargetListener {
    public static final String EVENT_DETAIL = "EVENT_DETAIL";

    public DropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    protected Request createTargetRequest() {
        Request r = super.createTargetRequest();
        if (r != null && r.getExtendedData() != null) {
            r.getExtendedData().put(EVENT_DETAIL, this.getCurrentEvent().detail);
        }
        return r;
    }

    protected abstract Object getJavaObject(TransferData var1);

    protected List<EObject> getObjectsBeingDropped() {
        TransferData data = this.getCurrentEvent().currentDataType;
        ArrayList<URI> uris = new ArrayList<URI>();
        Object transferedObject = this.getJavaObject(data);
        if (transferedObject instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)transferedObject;
            for (Object nextSelectedObject : selection) {
                if (nextSelectedObject instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)nextSelectedObject;
                    nextSelectedObject = adaptable.getAdapter(EObject.class);
                }
                if (!(nextSelectedObject instanceof EObject)) continue;
                EObject modelElement = (EObject)nextSelectedObject;
                Resource modelElementResource = modelElement.eResource();
                uris.add(modelElementResource.getURI().appendFragment(modelElementResource.getURIFragment(modelElement)));
            }
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (URI uri : uris) {
            EObject modelObject = this.getTransactionalEditingDomain().getResourceSet().getEObject(uri, true);
            result.add(modelObject);
        }
        return result;
    }

    protected abstract TransactionalEditingDomain getTransactionalEditingDomain();
}

