/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.part;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.papyrus.uml.diagram.common.part.CachedResourcesDocumentProvider;
import org.eclipse.papyrus.uml.diagram.common.part.CachedResourcesEditorInput;
import org.eclipse.papyrus.uml.diagram.common.part.EditingDomainRegistry;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.papyrus.uml.diagram.common.util.PathsUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public abstract class CachedResourcesDiagramEditor
extends DiagramDocumentEditor {
    public CachedResourcesDiagramEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    protected CachedResourcesDocumentProvider getCachedResourcesDocumentProvider() {
        if (this.getDocumentProvider() != null && this.getDocumentProvider() instanceof CachedResourcesDocumentProvider) {
            return (CachedResourcesDocumentProvider)this.getDocumentProvider();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.getPage().addPartListener((IPartListener2)EditingDomainRegistry.getInstance());
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        String filePath;
        String diagramFragment;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null && (diagramFragment = MDTUtil.getLastOpenedDiagramProperty(filePath = PathsUtil.getRelativeWorkspaceFromEditorInput(input))) != null) {
            URI uri = URI.createURI((String)filePath).appendFragment(diagramFragment);
            input = MDTUtil.copyEditorInputButUri(input, uri);
        }
        if (this.checkSameEditorInput((IEditorInput)input, editorInput)) {
            return;
        }
        CachedResourcesDocumentProvider documentProvider = this.getCachedResourcesDocumentProvider();
        if (documentProvider != null) {
            if (input instanceof CachedResourcesEditorInput) {
                if (((CachedResourcesEditorInput)((Object)input)).isUnload()) {
                    documentProvider.setUnloadOnDispose(true);
                    this.removeEditingDomainFromRegistry();
                } else {
                    documentProvider.setUnloadOnDispose(false);
                }
            } else {
                documentProvider.setUnloadOnDispose(true);
                this.removeEditingDomainFromRegistry();
            }
        }
        super.doSetInput(input, releaseEditorContents);
    }

    protected boolean checkSameEditorInput(IEditorInput input1, IEditorInput input2) {
        String uri1 = "";
        String uri2 = "";
        if (input1 instanceof FileEditorInput) {
            uri1 = ((FileEditorInput)input1).getURI().toString();
        }
        if (input1 instanceof URIEditorInput) {
            uri1 = ((URIEditorInput)input1).getURI().toString();
        }
        if (input2 instanceof FileEditorInput) {
            uri2 = ((FileEditorInput)input2).getURI().toString();
        }
        if (input2 instanceof URIEditorInput) {
            uri2 = ((URIEditorInput)input2).getURI().toString();
        }
        return uri1.equals(uri2);
    }

    protected void removeEditingDomainFromRegistry() {
        CachedResourcesDocumentProvider documentProvider = this.getCachedResourcesDocumentProvider();
        if (documentProvider != null) {
            EditingDomainRegistry.getInstance().remove(documentProvider.getEditingDomainID());
        }
    }

    public void close(boolean save) {
        CachedResourcesDocumentProvider documentProvider = this.getCachedResourcesDocumentProvider();
        if (documentProvider != null) {
            documentProvider.setUnloadOnDispose(false);
        }
        super.close(save);
    }

    public void closeButUnload(boolean save) {
        CachedResourcesDocumentProvider documentProvider = this.getCachedResourcesDocumentProvider();
        if (documentProvider != null) {
            documentProvider.setUnloadOnDispose(false);
        }
        super.close(save);
    }

    public abstract String getEditorID();

    public void setUnloadOnDispose(boolean unload) {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof CachedResourcesDocumentProvider) {
            ((CachedResourcesDocumentProvider)documentProvider).setUnloadOnDispose(unload);
        }
    }
}

