/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.service.IProfileDependantPaletteProvider;
import org.eclipse.papyrus.uml.diagram.common.service.LocalPaletteProvider;
import org.eclipse.papyrus.uml.diagram.common.service.XMLDefinitionPaletteParser;
import org.eclipse.papyrus.uml.diagram.common.service.XMLRequiredProfileFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPaletteProvider
extends LocalPaletteProvider
implements IProfileDependantPaletteProvider {
    private String providerID;
    protected Collection<String> requiredProfiles;

    protected String getProviderID() {
        return this.providerID;
    }

    @Override
    public InputStream getXmlFile(String path) throws IOException {
        Bundle bundle = Platform.getBundle((String)this.getProviderID());
        if (bundle != null) {
            String filePath;
            URL urlFile = bundle.getEntry(path);
            urlFile = FileLocator.resolve((URL)urlFile);
            if ("file".equals((urlFile = FileLocator.toFileURL((URL)urlFile)).getProtocol())) {
                return new FileInputStream(urlFile.getFile());
            }
            if ("jar".equals(urlFile.getProtocol()) && (filePath = urlFile.getPath()).startsWith("file:")) {
                int jarPathEndIndex = filePath.indexOf("!/");
                if (jarPathEndIndex < 0) {
                    Activator.log.error("Impossible to find the jar path end", null);
                    return null;
                }
                String jarPath = filePath.substring("file:".length(), jarPathEndIndex);
                ZipFile zipFile = new ZipFile(jarPath);
                filePath = filePath.substring(jarPathEndIndex + 2, filePath.length());
                ZipEntry entry = zipFile.getEntry(filePath);
                return zipFile.getInputStream(entry);
            }
        }
        return null;
    }

    @Override
    public void setContributions(IConfigurationElement configElement) {
        this.providerID = configElement.getContributor().getName();
        this.readXMLDocument(configElement.getAttribute("path"));
    }

    @Override
    public Collection<String> getRequiredProfiles() {
        if (this.requiredProfiles == null) {
            this.requiredProfiles = new HashSet<String>();
            try {
                XMLDefinitionPaletteParser profileParser = new XMLDefinitionPaletteParser(new XMLRequiredProfileFactory(this.requiredProfiles));
                int i = 0;
                while (i < this.contributions.getLength()) {
                    Node node = this.contributions.item(i);
                    if ("paletteDefinition".equals(node.getNodeName())) {
                        profileParser.parsePaletteDefinition(node);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Activator.log.error(e);
            }
        }
        return this.requiredProfiles;
    }
}

