/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import org.eclipse.papyrus.uml.diagram.common.service.AbstractXMLDefinitionPaletteFactory;
import org.eclipse.papyrus.uml.diagram.common.service.IPapyrusPaletteConstant;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDefinitionPaletteParser
implements IPapyrusPaletteConstant {
    protected final AbstractXMLDefinitionPaletteFactory factory;

    public XMLDefinitionPaletteParser(AbstractXMLDefinitionPaletteFactory factory) {
        this.factory = factory;
    }

    public void parsePaletteDefinition(Node paletteDefinitionNode) {
        NodeList nodes = paletteDefinitionNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if ("content".equals(node.getNodeName())) {
                this.factory.traverseContentNode(node);
                this.parsePaletteContent(node);
            }
            ++i;
        }
    }

    public void parsePaletteContent(Node paletteContentNode) {
        NodeList nodes = paletteContentNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if ("drawer".equals(name)) {
                this.parserDrawerNode(node);
            } else if ("stack".equals(name)) {
                this.parserStackNode(node);
            } else if ("separator".equals(name)) {
                this.parseSeparatorNode(node);
            } else if ("tool".equals(name)) {
                this.parseToolNode(node);
            } else if ("aspectTool".equals(name)) {
                this.parseAspectToolNode(node);
            }
            ++i;
        }
    }

    public void parseAspectToolNode(Node node) {
        this.factory.traverseAspectToolEntryNode(node);
    }

    public void parserDrawerNode(Node node) {
        this.factory.traverseDrawerNode(node);
        if (node.getChildNodes().getLength() > 0) {
            this.parsePaletteContent(node);
        }
    }

    public void parserStackNode(Node node) {
        this.factory.traverseStackNode(node);
        if (node.getChildNodes().getLength() > 0) {
            this.parsePaletteContent(node);
        }
    }

    public void parseToolNode(Node node) {
        this.factory.traverseToolEntryNode(node);
        if (node.getChildNodes().getLength() > 0) {
            this.parsePaletteContent(node);
        }
    }

    public void parseSeparatorNode(Node node) {
        this.factory.traverseSeparatorNode(node);
        if (node.getChildNodes().getLength() > 0) {
            this.parsePaletteContent(node);
        }
    }
}

