/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CompartmentTitleRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompartmentUtils {
    private CompartmentUtils() {
    }

    public static List<IResizableCompartmentEditPart> getAllCompartmentsEditPart(EditPart editpart, boolean includeTitleCompartment) {
        ArrayList<IResizableCompartmentEditPart> compartments = new ArrayList<IResizableCompartmentEditPart>();
        List localChildren = editpart.getChildren();
        for (Object current : localChildren) {
            if (!(current instanceof IResizableCompartmentEditPart)) continue;
            if (includeTitleCompartment) {
                compartments.add((IResizableCompartmentEditPart)current);
                continue;
            }
            if (current instanceof ITextAwareEditPart) continue;
            compartments.add((IResizableCompartmentEditPart)current);
        }
        return compartments;
    }

    public static List<View> getAllCompartments(EditPart editpart, boolean includeTitleCompartment) {
        ArrayList<View> compartments = new ArrayList<View>();
        View notationView = ((GraphicalEditPart)editpart).getNotationView();
        EList graphicalChildren = notationView.getChildren();
        String type = notationView.getType();
        for (Object child : graphicalChildren) {
            if (child instanceof View && ((View)child).getType().equals(type)) continue;
            if (child instanceof BasicCompartment) {
                if (includeTitleCompartment) {
                    compartments.add((View)child);
                    continue;
                }
                if (CompartmentUtils.isCompartmentName(editpart, (View)child)) continue;
                compartments.add((View)child);
                continue;
            }
            if (!(child instanceof DecorationNode)) continue;
            if (includeTitleCompartment) {
                compartments.add((View)child);
                continue;
            }
            if (CompartmentUtils.isCompartmentName(editpart, (View)child)) continue;
            compartments.add((View)child);
        }
        return compartments;
    }

    public static List<View> getAllVisibleCompartments(EditPart editpart, boolean includeTitleCompartment) {
        ArrayList<View> visibleCompartments = new ArrayList<View>();
        List localChildren = editpart.getChildren();
        for (Object current : localChildren) {
            if (!(current instanceof CompartmentEditPart)) continue;
            if (includeTitleCompartment) {
                visibleCompartments.add((View)((CompartmentEditPart)current).getModel());
                continue;
            }
            if (current instanceof ITextAwareEditPart) continue;
            visibleCompartments.add((View)((CompartmentEditPart)current).getModel());
        }
        return visibleCompartments;
    }

    public static boolean isCompartmentName(EditPart editpart, View view) {
        IGraphicalEditPart gep = EditPartService.getInstance().createGraphicEditPart(view);
        return gep instanceof ITextAwareEditPart;
    }

    public static List<CompartmentTitleRepresentation> getAllVisibleCompartmentName(EditPart editpart) {
        List<View> allCompartments = CompartmentUtils.getAllCompartments(editpart, false);
        ArrayList<CompartmentTitleRepresentation> visibleTitle = new ArrayList<CompartmentTitleRepresentation>();
        for (View current : allCompartments) {
            if (!CompartmentUtils.isCompartmentTitleVisible(current)) continue;
            visibleTitle.add(new CompartmentTitleRepresentation(editpart, current));
        }
        return visibleTitle;
    }

    public static boolean isCompartmentTitleVisible(View compartmentView) {
        TitleStyle style = (TitleStyle)compartmentView.getStyle(NotationPackage.eINSTANCE.getTitleStyle());
        return style != null && style.isShowTitle();
    }

    public static CompartmentTitleRepresentation getCompartmentTitleRepresentation(List<CompartmentTitleRepresentation> representations, View view) {
        for (CompartmentTitleRepresentation current : representations) {
            if (!current.getRealObject().equals(view)) continue;
            return current;
        }
        return null;
    }
}

