/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.javaconstraint;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class JavaDirectEditorConfiguration
extends DefaultDirectEditorConfiguration {
    public String getTextToEdit(Object editedObject) {
        Constraint umlConstraint = (Constraint)editedObject;
        String value = "";
        if (umlConstraint.getSpecification() != null) {
            if (umlConstraint.getSpecification() instanceof LiteralString) {
                if (((LiteralString)umlConstraint.getSpecification()).getValue() != null) {
                    value = String.valueOf(value) + ((LiteralString)umlConstraint.getSpecification()).getValue();
                }
            } else if (umlConstraint.getSpecification() instanceof OpaqueExpression) {
                int indexOfOCLBody = -1;
                OpaqueExpression opaqueExpression = (OpaqueExpression)umlConstraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("JAVA")) {
                        value = String.valueOf(value) + (String)opaqueExpression.getBodies().get(i);
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
        }
        return value;
    }

    public Object postEditAction(Object objectToEdit, String newText) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)((Constraint)objectToEdit));
        UpdateConstraintCommand updateCommand = new UpdateConstraintCommand(editingDomain, (Constraint)objectToEdit, newText);
        editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)updateCommand));
        return updateCommand;
    }

    protected class UpdateConstraintCommand
    extends AbstractTransactionalCommand {
        protected final Constraint constraint;
        protected final String newTextualRepresentation;

        public UpdateConstraintCommand(TransactionalEditingDomain editingDomain, Constraint constraint, String newTextualRepresentation) {
            super(editingDomain, "Constraint Update", UpdateConstraintCommand.getWorkspaceFiles((EObject)constraint));
            this.constraint = constraint;
            this.newTextualRepresentation = newTextualRepresentation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            OpaqueExpression opaqueExpression = null;
            int indexOfOCLBody = -1;
            if (this.constraint.getSpecification() == null || !(this.constraint.getSpecification() instanceof OpaqueExpression)) {
                opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            } else {
                opaqueExpression = (OpaqueExpression)this.constraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("JAVA")) {
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
            if (indexOfOCLBody == -1) {
                opaqueExpression.getLanguages().add((Object)"JAVA");
                opaqueExpression.getBodies().add((Object)this.newTextualRepresentation);
            } else {
                opaqueExpression.getBodies().remove(indexOfOCLBody);
                opaqueExpression.getBodies().add(indexOfOCLBody, (Object)this.newTextualRepresentation);
            }
            this.constraint.setSpecification((ValueSpecification)opaqueExpression);
            return CommandResult.newOKCommandResult((Object)this.constraint);
        }
    }
}

