/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentCombinedFragmentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.MessageAnchorRepairer;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperandBoundsComputeHelper {
    public static final int DEFAULT_INTERACTION_OPERAND_HEIGHT = 61;
    public static final int MIN_INTERACTION_OPERAND_HEIGHT = 10;
    public static final int DEFAULT_INTERACTION_OPERAND_WIDTH = 210;
    public static final int COMBINED_FRAGMENT_FIGURE_BORDER = 1;
    private static final int EXECUTION_VERTICAL_MARGIN = 3;

    public static InteractionOperandEditPart findFirstIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP) {
        InteractionOperandEditPart firstIOEP = null;
        List children = compartEP.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                firstIOEP = (InteractionOperandEditPart)((Object)children.get(i));
                break;
            }
            ++i;
        }
        return firstIOEP;
    }

    public static InteractionOperandEditPart findLastIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP) {
        InteractionOperandEditPart lastIOEP = null;
        List children = compartEP.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                lastIOEP = (InteractionOperandEditPart)((Object)children.get(i));
                break;
            }
            --i;
        }
        return lastIOEP;
    }

    public static InteractionOperandEditPart findPreviousIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP, InteractionOperandEditPart currentIOEP) {
        InteractionOperandEditPart previousIOEP = null;
        List children = compartEP.getChildren();
        int i = 0;
        while (i < children.size() - 1) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                if (children.get(i) == currentIOEP) break;
                previousIOEP = (InteractionOperandEditPart)((Object)children.get(i));
            }
            ++i;
        }
        return previousIOEP;
    }

    public static InteractionOperandEditPart findLatterIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP, InteractionOperandEditPart currentIOEP) {
        InteractionOperandEditPart latterIOEP = null;
        List children = compartEP.getChildren();
        int i = children.size() - 1;
        while (i > 0) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                if (children.get(i) == currentIOEP) break;
                latterIOEP = (InteractionOperandEditPart)((Object)children.get(i));
            }
            --i;
        }
        return latterIOEP;
    }

    public static void updateEditPartBounds(GraphicalEditPart editpart, Rectangle rect) {
        Node node;
        if (editpart.getModel() instanceof Node && (node = (Node)editpart.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            OperandBoundsComputeHelper.updateBounds(bounds, rect, editpart.getEditingDomain());
        }
    }

    public static ICommand createUpdateEditPartBoundsCommand(final GraphicalEditPart editpart, final Rectangle rect) {
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editpart.getEditingDomain(), "Update Operand Bounds", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Node node;
                if (editpart.getModel() instanceof Node && (node = (Node)editpart.getModel()).getLayoutConstraint() instanceof Bounds) {
                    Bounds bounds = (Bounds)node.getLayoutConstraint();
                    OperandBoundsComputeHelper.fillBounds(bounds, rect);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        return cmd;
    }

    public static ICommand createUpdateCFAndIOBoundsForCFCreationCommand(final EditPart editPart, final CreateViewRequest request) {
        if (!(editPart instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(graphicalEditPart.getEditingDomain(), "Create update operand bounds command", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                OperandBoundsComputeHelper.updateCFAndIOBoundsForCFCreation((GraphicalEditPart)editPart, request);
                return CommandResult.newOKCommandResult();
            }
        };
        return cmd;
    }

    private static void updateCFAndIOBoundsForCFCreation(GraphicalEditPart parent, CreateViewRequest request) {
        Object subEditPart = null;
        if (parent instanceof InteractionInteractionCompartmentEditPart) {
            InteractionInteractionCompartmentEditPart interactionInteractionCompartmentEditPart = (InteractionInteractionCompartmentEditPart)parent;
            subEditPart = interactionInteractionCompartmentEditPart.getChildren().get(interactionInteractionCompartmentEditPart.getChildren().size() - 1);
        } else if (parent instanceof InteractionOperandEditPart) {
            InteractionOperandEditPart interactionOperandEditPart = (InteractionOperandEditPart)parent;
            subEditPart = interactionOperandEditPart.getChildren().get(interactionOperandEditPart.getChildren().size() - 1);
        }
        if (subEditPart != null && subEditPart instanceof CombinedFragmentEditPart) {
            InteractionOperandEditPart lastOperand;
            Shape shape;
            CombinedFragmentEditPart combinedFragmentEditPart = subEditPart;
            Rectangle cfEPAbsoluteRect = null;
            int labelContainerHeight = OperandBoundsComputeHelper.computeCombinedFragementHeaderHeight(combinedFragmentEditPart);
            Shape cfEPShape = (Shape)combinedFragmentEditPart.getModel();
            if (cfEPShape.getLayoutConstraint() instanceof Bounds) {
                if (request.getSize() == null) {
                    Dimension cfEPDefaultSize = new Dimension();
                    cfEPDefaultSize.setWidth(212);
                    cfEPDefaultSize.setHeight(61 + labelContainerHeight + 2);
                    cfEPAbsoluteRect = new Rectangle(request.getLocation(), cfEPDefaultSize);
                } else {
                    cfEPAbsoluteRect = new Rectangle(request.getLocation(), request.getSize());
                }
                Rectangle cfEPRelativeRect = cfEPAbsoluteRect.getCopy();
                combinedFragmentEditPart.getFigure().translateToRelative((Translatable)cfEPRelativeRect);
                Bounds cfEPBounds = (Bounds)cfEPShape.getLayoutConstraint();
                OperandBoundsComputeHelper.fillBounds(cfEPBounds, cfEPRelativeRect);
            }
            if ((shape = (Shape)(lastOperand = OperandBoundsComputeHelper.findLastIOEP((CombinedFragmentCombinedFragmentCompartmentEditPart)combinedFragmentEditPart.getChildBySemanticHint(UMLVisualIDRegistry.getType(7004)))).getModel()).getLayoutConstraint() instanceof Bounds) {
                Bounds bounds = (Bounds)shape.getLayoutConstraint();
                Rectangle rect = new Rectangle(bounds.getX(), bounds.getY(), cfEPAbsoluteRect.width() - 2, cfEPAbsoluteRect.height() - labelContainerHeight - 2);
                OperandBoundsComputeHelper.fillBounds(bounds, rect);
            }
        }
    }

    public static org.eclipse.gef.commands.Command createUpdateIOBoundsForCFResizeCommand(CompoundCommand compoundCmd, ChangeBoundsRequest request, CombinedFragmentEditPart combinedFragmentEditPart) {
        Node node;
        if (combinedFragmentEditPart.getChildren().size() > 0 && combinedFragmentEditPart.getChildren().get(0) instanceof CombinedFragmentCombinedFragmentCompartmentEditPart) {
            CombinedFragmentCombinedFragmentCompartmentEditPart compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)((Object)combinedFragmentEditPart.getChildren().get(0));
            CombinedFragment cf = (CombinedFragment)combinedFragmentEditPart.resolveSemanticElement();
            InteractionOperandEditPart targetIOEP = null;
            if ((request.getResizeDirection() & 1) != 0) {
                targetIOEP = OperandBoundsComputeHelper.findFirstIOEP(compartment);
            } else if ((request.getResizeDirection() & 4) != 0) {
                targetIOEP = OperandBoundsComputeHelper.findLastIOEP(compartment);
            }
            OperandBoundsComputeHelper.updateIOBoundsForCFResize(request, compoundCmd, compartment.getChildren(), cf, targetIOEP != null ? (InteractionOperand)targetIOEP.resolveSemanticElement() : null, request.getSizeDelta(), request.getResizeDirection());
            if (targetIOEP != null && request.getSizeDelta().height != 0) {
                int heightDelta;
                int movedY = heightDelta = request.getSizeDelta().height;
                Bounds bounds = OperandBoundsComputeHelper.getInteractionOperandEPBounds((GraphicalEditPart)targetIOEP);
                Rectangle currentIOEPRect = OperandBoundsComputeHelper.fillRectangle(bounds);
                if ((request.getResizeDirection() & 1) != 0) {
                    movedY = -heightDelta;
                    currentIOEPRect.setY(currentIOEPRect.y() - heightDelta);
                } else {
                    request.getResizeDirection();
                }
                currentIOEPRect.setHeight(bounds.getHeight() + heightDelta);
                int minHeight = OperandBoundsComputeHelper.getMinimumHeightFor(targetIOEP);
                if (currentIOEPRect.height < minHeight) {
                    compoundCmd.add((org.eclipse.gef.commands.Command)UnexecutableCommand.INSTANCE);
                    return UnexecutableCommand.INSTANCE;
                }
                org.eclipse.gef.commands.Command shiftEnclosedExecutions = OperandBoundsComputeHelper.getShiftEnclosedFragmentsCommand(targetIOEP, currentIOEPRect, movedY);
                if (shiftEnclosedExecutions != null) {
                    compoundCmd.add(shiftEnclosedExecutions);
                }
            }
        }
        Point moveDelta = request.getMoveDelta();
        Dimension sizeDelta = request.getSizeDelta();
        if ((moveDelta.y > 0 || sizeDelta.height > 0) && combinedFragmentEditPart.getModel() instanceof Node && (node = (Node)combinedFragmentEditPart.getModel()).getLayoutConstraint() instanceof Bounds) {
            Rectangle newBounds;
            ICommand command;
            Bounds containerBounds = (Bounds)node.getLayoutConstraint();
            Dimension preferredSize = combinedFragmentEditPart.getFigure().getPreferredSize();
            int width = containerBounds.getWidth() != -1 ? containerBounds.getWidth() : preferredSize.width();
            int height = containerBounds.getHeight() != -1 ? containerBounds.getHeight() : preferredSize.height();
            int x = containerBounds.getX();
            int y = containerBounds.getY();
            if (moveDelta.y > 0) {
                y += moveDelta.y;
            }
            if (sizeDelta.height > 0) {
                height += sizeDelta.height;
            }
            if ((command = OperandBoundsComputeHelper.getExpandCoveredsCommand(combinedFragmentEditPart, newBounds = new Rectangle(x, y, width, height))) != null && command.canExecute()) {
                compoundCmd.add((org.eclipse.gef.commands.Command)new ICommandProxy(command));
            }
        }
        return compoundCmd;
    }

    private static void updateIOBoundsForCFResize(ChangeBoundsRequest request, CompoundCommand compoundCmd, List<EditPart> combinedFragmentChildrenEditParts, CombinedFragment cf, InteractionOperand targetOperand, Dimension sizeDelta, int direction) {
        InteractionOperandEditPart targetOperandEditPart = OperandBoundsComputeHelper.findTargetOperandEditPart(cf, targetOperand, combinedFragmentChildrenEditParts);
        for (EditPart ep : combinedFragmentChildrenEditParts) {
            Shape ioEPShape;
            InteractionOperandEditPart ioEP;
            Object ioEPModel;
            if (!(ep instanceof InteractionOperandEditPart) || !((ioEPModel = (ioEP = (InteractionOperandEditPart)ep).getModel()) instanceof Shape) || !((ioEPShape = (Shape)ioEPModel).getLayoutConstraint() instanceof Bounds)) continue;
            Bounds ioEPOriginalBounds = (Bounds)ioEPShape.getLayoutConstraint();
            UpdateIOBoundsForCFResizeCommand cmd = new UpdateIOBoundsForCFResizeCommand(ioEP.getEditingDomain(), "Update operand bounds interaction command", ioEPOriginalBounds, request, sizeDelta, ioEP == targetOperandEditPart, direction);
            compoundCmd.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)cmd));
        }
    }

    public static void updateBounds(final Bounds bounds, final Rectangle rect, TransactionalEditingDomain transactionalEditingDomain) {
        if (bounds != null) {
            final Rectangle originalBounds = new Rectangle();
            originalBounds.setX(bounds.getX());
            originalBounds.setY(bounds.getY());
            originalBounds.setWidth(bounds.getWidth());
            originalBounds.setHeight(bounds.getHeight());
            AbstractCommand cmd = new AbstractCommand(){

                public boolean canExecute() {
                    return true;
                }

                public void execute() {
                    this.exec(rect);
                }

                public void redo() {
                    this.execute();
                }

                public void undo() {
                    this.exec(originalBounds);
                }

                public void exec(Rectangle rect2) {
                    OperandBoundsComputeHelper.fillBounds(bounds, rect2);
                }

                public boolean canUndo() {
                    return true;
                }
            };
            CommandHelper.executeCommandWithoutHistory((EditingDomain)transactionalEditingDomain, (Command)cmd, true);
        }
    }

    public static InteractionOperandEditPart findTargetOperandEditPart(CombinedFragment cf, InteractionOperand targetOperand, List<EditPart> combinedFragmentChildrenEditParts) {
        if (targetOperand == null) {
            return null;
        }
        for (EditPart ep : combinedFragmentChildrenEditParts) {
            if (!(ep instanceof InteractionOperandEditPart)) continue;
            InteractionOperandEditPart ioEP = (InteractionOperandEditPart)ep;
            EObject io = ioEP.resolveSemanticElement();
            if (!cf.getOperands().contains((Object)io) || !targetOperand.equals(io)) continue;
            return ioEP;
        }
        return null;
    }

    public static Bounds getEditPartBounds(GraphicalEditPart editPart) {
        Node node;
        if (editPart.getModel() instanceof Node && (node = (Node)editPart.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            return bounds;
        }
        return null;
    }

    public static Rectangle fillRectangle(Bounds source) {
        if (source == null) {
            return null;
        }
        Rectangle target = new Rectangle();
        target.setX(source.getX());
        target.setY(source.getY());
        target.setWidth(source.getWidth());
        target.setHeight(source.getHeight());
        return target;
    }

    public static Bounds fillBounds(Bounds bounds, Rectangle source) {
        if (bounds == null || source == null) {
            return null;
        }
        bounds.setX(source.x());
        bounds.setY(source.y());
        bounds.setWidth(source.width());
        bounds.setHeight(source.height());
        return bounds;
    }

    public static Bounds getInteractionOperandEPBounds(GraphicalEditPart operandEP) {
        Shape lastOperandShape;
        Object lastChildModel = operandEP.getModel();
        if (lastChildModel instanceof Shape && (lastOperandShape = (Shape)lastChildModel).getLayoutConstraint() instanceof Bounds) {
            return (Bounds)lastOperandShape.getLayoutConstraint();
        }
        return null;
    }

    public static org.eclipse.gef.commands.Command createIOEPResizeCommand(InteractionOperandEditPart currentIOEP, int heightDelta, CombinedFragmentCombinedFragmentCompartmentEditPart compartEP, int direction) {
        Bounds currentIOEPBounds = OperandBoundsComputeHelper.getEditPartBounds((GraphicalEditPart)currentIOEP);
        if (currentIOEPBounds == null) {
            return null;
        }
        InteractionOperandEditPart targetIOEP = null;
        if ((direction & 1) != 0) {
            targetIOEP = OperandBoundsComputeHelper.findPreviousIOEP(compartEP, currentIOEP);
        } else if ((direction & 4) != 0) {
            targetIOEP = OperandBoundsComputeHelper.findLatterIOEP(compartEP, currentIOEP);
        }
        CompositeCommand compositeCommand = new CompositeCommand("Resize Operand");
        if (targetIOEP == null) {
            Node node;
            CombinedFragmentEditPart parent;
            if (heightDelta < 0 && currentIOEPBounds.getHeight() - Math.abs(heightDelta) < 10) {
                return null;
            }
            Rectangle currentIOEPRect = OperandBoundsComputeHelper.fillRectangle(currentIOEPBounds);
            currentIOEPRect.setHeight(currentIOEPBounds.getHeight() + heightDelta);
            int minHeight = OperandBoundsComputeHelper.getMinimumHeightFor(currentIOEP);
            if (currentIOEPRect.height < minHeight) {
                return UnexecutableCommand.INSTANCE;
            }
            ICommand currentIOEPCommand = OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)currentIOEP, currentIOEPRect);
            compositeCommand.add((IUndoableOperation)currentIOEPCommand);
            org.eclipse.gef.commands.Command shiftPreviousExecutions = OperandBoundsComputeHelper.getShiftEnclosedFragmentsCommand(currentIOEP, currentIOEPRect, heightDelta);
            if (shiftPreviousExecutions != null) {
                compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)new GEFtoEMFCommandWrapper(shiftPreviousExecutions)));
            }
            if (compartEP.getParent() instanceof CombinedFragmentEditPart && (parent = (CombinedFragmentEditPart)compartEP.getParent()).getModel() instanceof Node && (node = (Node)parent.getModel()).getLayoutConstraint() instanceof Bounds) {
                ICommand expandCoveredsCommand;
                Bounds containerBounds = (Bounds)node.getLayoutConstraint();
                Dimension preferredSize = parent.getFigure().getPreferredSize();
                int width = containerBounds.getWidth() != -1 ? containerBounds.getWidth() : preferredSize.width();
                int height = containerBounds.getHeight() != -1 ? containerBounds.getHeight() : preferredSize.height();
                Rectangle containerRect = new Rectangle(containerBounds.getX(), containerBounds.getY(), width, height += heightDelta);
                compositeCommand.add((IUndoableOperation)OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)parent, containerRect));
                ICommand preserveMessageAnchorsCommand = MessageAnchorRepairer.createPreserveMessageAnchorsCommand(parent, heightDelta);
                if (preserveMessageAnchorsCommand != null && preserveMessageAnchorsCommand.canExecute()) {
                    compositeCommand.add((IUndoableOperation)preserveMessageAnchorsCommand);
                }
                if ((expandCoveredsCommand = OperandBoundsComputeHelper.getExpandCoveredsCommand((CombinedFragmentEditPart)compartEP.getParent(), containerRect)) != null) {
                    compositeCommand.add((IUndoableOperation)expandCoveredsCommand);
                }
            }
        } else {
            org.eclipse.gef.commands.Command shiftCurrentExecutions;
            int minHeughtOfCurrentOperand;
            org.eclipse.gef.commands.Command shiftPreviousExecutions;
            Bounds targetIOEPBounds = OperandBoundsComputeHelper.getEditPartBounds((GraphicalEditPart)targetIOEP);
            if (targetIOEPBounds == null) {
                return null;
            }
            if (heightDelta > 0 ? targetIOEPBounds.getHeight() - heightDelta < 10 : currentIOEPBounds.getHeight() - Math.abs(heightDelta) < 10) {
                return null;
            }
            Rectangle targetIOEPRect = OperandBoundsComputeHelper.fillRectangle(targetIOEPBounds);
            Rectangle currentIOEPRect = OperandBoundsComputeHelper.fillRectangle(currentIOEPBounds);
            targetIOEPRect.setHeight(targetIOEPBounds.getHeight() - heightDelta);
            currentIOEPRect.setHeight(currentIOEPBounds.getHeight() + heightDelta);
            int shiftY = 0;
            if ((direction & 1) != 0) {
                currentIOEPRect.setY(currentIOEPRect.y() - heightDelta);
                shiftY = -heightDelta;
            } else if ((direction & 4) != 0) {
                targetIOEPRect.setY(targetIOEPRect.y() + heightDelta);
                shiftY = heightDelta;
            }
            int minHeightOfTargetOperand = OperandBoundsComputeHelper.getMinimumHeightFor(targetIOEP);
            if (targetIOEPRect.height < minHeightOfTargetOperand) {
                return null;
            }
            ICommand previousIOEPCommand = OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)targetIOEP, targetIOEPRect);
            compositeCommand.add((IUndoableOperation)previousIOEPCommand);
            if ((shiftY < 0 && targetIOEPRect.y < currentIOEPRect.y || shiftY > 0 && targetIOEPRect.y > currentIOEPRect.y) && (shiftPreviousExecutions = OperandBoundsComputeHelper.getShiftEnclosedFragmentsCommand(targetIOEP, targetIOEPRect, shiftY)) != null) {
                compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)new GEFtoEMFCommandWrapper(shiftPreviousExecutions)));
            }
            if (currentIOEPRect.height < (minHeughtOfCurrentOperand = OperandBoundsComputeHelper.getMinimumHeightFor(currentIOEP))) {
                return null;
            }
            ICommand currentIOEPCommand = OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)currentIOEP, currentIOEPRect);
            compositeCommand.add((IUndoableOperation)currentIOEPCommand);
            if ((shiftY < 0 && currentIOEPRect.y < targetIOEPRect.y || shiftY > 0 && currentIOEPRect.y > targetIOEPRect.y) && (shiftCurrentExecutions = OperandBoundsComputeHelper.getShiftEnclosedFragmentsCommand(currentIOEP, currentIOEPRect, shiftY)) != null) {
                compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)new GEFtoEMFCommandWrapper(shiftCurrentExecutions)));
            }
        }
        return new ICommandProxy((ICommand)compositeCommand);
    }

    private static int getMinimumHeightFor(InteractionOperandEditPart operand) {
        if (operand == null) {
            return 10;
        }
        List<OperandBlock> operandBlocks = OperandBoundsComputeHelper.getOperandBlocks(operand);
        if (!operandBlocks.isEmpty()) {
            Collections.sort(operandBlocks, new Comparator<OperandBlock>(){

                @Override
                public int compare(OperandBlock o1, OperandBlock o2) {
                    Rectangle r1 = o1.getBounds();
                    Rectangle r2 = o2.getBounds();
                    if (r1.y < r2.y) {
                        return -1;
                    }
                    if (r1.y > r2.y) {
                        return 1;
                    }
                    return 0;
                }
            });
            Rectangle maxArea = null;
            for (OperandBlock blk : operandBlocks) {
                Rectangle r = blk.getBounds();
                if (maxArea == null) {
                    maxArea = r;
                    continue;
                }
                maxArea.union(r);
            }
            HashMap<OperandBlock, Rectangle> constraints = new HashMap<OperandBlock, Rectangle>();
            OperandBlock topBlock = operandBlocks.get(0);
            Rectangle minArea = new Rectangle(topBlock.getBounds());
            minArea.height += 3;
            int i = 1;
            while (i < operandBlocks.size()) {
                Rectangle newBounds;
                OperandBlock nextBlock = operandBlocks.get(i);
                Rectangle r = nextBlock.getBounds();
                if (!minArea.touches(r) && r.y > maxArea.y) {
                    int y = r.y;
                    while (y >= maxArea.y) {
                        Rectangle movedRect = new Rectangle(r).setY(y);
                        if (minArea.touches(movedRect)) break;
                        constraints.put(nextBlock, movedRect);
                        --y;
                    }
                }
                if ((newBounds = (Rectangle)constraints.get(nextBlock)) == null) {
                    newBounds = r;
                }
                minArea.union(newBounds);
                minArea.height += 3;
                ++i;
            }
            return minArea.height;
        }
        return 10;
    }

    protected static Rectangle getExecutionGroupBounds(IGraphicalEditPart currentExecutionPart, List<ExecutionSpecification> toCheckExecutions) {
        Rectangle groupRect = SequenceUtil.getAbsoluteBounds(currentExecutionPart);
        if (toCheckExecutions.isEmpty()) {
            return groupRect;
        }
        ArrayList connections = new ArrayList();
        connections.addAll(currentExecutionPart.getSourceConnections());
        connections.addAll(currentExecutionPart.getTargetConnections());
        for (Object object : connections) {
            IGraphicalEditPart source = (IGraphicalEditPart)object;
            View model = (View)source.getModel();
            EObject element = model.getElement();
            if (!toCheckExecutions.contains(element)) continue;
            ArrayList<ExecutionSpecification> myCheckingList = new ArrayList<ExecutionSpecification>(toCheckExecutions);
            myCheckingList.remove(element);
            Rectangle rect = OperandBoundsComputeHelper.getExecutionGroupBounds(source, myCheckingList);
            groupRect.union(rect);
        }
        List<ShapeNodeEditPart> affixedExecutionSpecificationEditParts = LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts((ShapeNodeEditPart)currentExecutionPart);
        for (ShapeNodeEditPart shapeNodeEditPart : affixedExecutionSpecificationEditParts) {
            ArrayList<ExecutionSpecification> myCheckingList = new ArrayList<ExecutionSpecification>(toCheckExecutions);
            myCheckingList.remove(shapeNodeEditPart);
            Rectangle rect = OperandBoundsComputeHelper.getExecutionGroupBounds((IGraphicalEditPart)shapeNodeEditPart, myCheckingList);
            groupRect.union(rect);
        }
        return groupRect;
    }

    private static org.eclipse.gef.commands.Command getShiftEnclosedFragmentsCommand(InteractionOperandEditPart editPart, Rectangle newBounds, int movedY) {
        if (editPart == null || newBounds == null || movedY == 0) {
            return null;
        }
        List<OperandBlock> operandBlocks = OperandBoundsComputeHelper.getOperandBlocks(editPart);
        if (operandBlocks.isEmpty()) {
            return null;
        }
        OperandBlockLayout layout = new OperandBlockLayout(operandBlocks);
        IFigure figure = editPart.getFigure();
        Rectangle newArea = newBounds.getCopy();
        figure.getParent().translateToAbsolute((Translatable)newArea);
        newArea.translate(figure.getParent().getBounds().getLocation());
        layout.layout(newArea, movedY > 0);
        HashMap<OperandBlock, Integer> blockToMove = new HashMap<OperandBlock, Integer>();
        for (OperandBlock blk : operandBlocks) {
            int moveDelta = layout.getMoveDelta(blk);
            if (moveDelta == 0) continue;
            blockToMove.put(blk, moveDelta);
        }
        if (blockToMove.isEmpty()) {
            return null;
        }
        return new ICommandProxy((ICommand)new MoveOperandBlockCommand(editPart.getEditingDomain(), blockToMove));
    }

    private static ICommand getMoveAnchorCommand(int yDelta, Rectangle figureBounds, IdentityAnchor gmfAnchor) {
        String oldTerminal = gmfAnchor.getId();
        PrecisionPoint pp = BaseSlidableAnchor.parseTerminalString((String)oldTerminal);
        int yPos = (int)Math.round((double)figureBounds.height * pp.preciseY);
        pp.preciseY = (double)(yPos += yDelta) / (double)figureBounds.height;
        if (pp.preciseY > 1.0) {
            pp.preciseY = 1.0;
        } else if (pp.preciseY < 0.0) {
            pp.preciseY = 0.0;
        }
        String newTerminal = new BaseSlidableAnchor(null, pp).getTerminal();
        return new SetValueCommand(new SetRequest((EObject)gmfAnchor, (EStructuralFeature)NotationPackage.Literals.IDENTITY_ANCHOR__ID, (Object)newTerminal));
    }

    public static int computeCombinedFragementHeaderHeight(CombinedFragmentEditPart combinedFragmentEditPart) {
        int headerHeight = 0;
        IFigure labelContainer = combinedFragmentEditPart.getPrimaryShape().getHeaderLabel().getParent();
        if (labelContainer != null) {
            headerHeight = labelContainer.getPreferredSize().height();
        }
        return headerHeight;
    }

    public static boolean checkRedistrictOnCFResize(ChangeBoundsRequest request, EditPart child) {
        CombinedFragmentEditPart combinedFragmentEditPart;
        if (child instanceof CombinedFragmentEditPart && (request.getResizeDirection() & 5) != 0 && (combinedFragmentEditPart = (CombinedFragmentEditPart)child).getChildren().size() > 0 && combinedFragmentEditPart.getChildren().get(0) instanceof CombinedFragmentCombinedFragmentCompartmentEditPart) {
            int height;
            CombinedFragmentCombinedFragmentCompartmentEditPart compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)((Object)combinedFragmentEditPart.getChildren().get(0));
            List combinedFragmentChildrenEditParts = compartment.getChildren();
            CombinedFragment cf = (CombinedFragment)combinedFragmentEditPart.resolveSemanticElement();
            InteractionOperand targetOperand = null;
            if ((request.getResizeDirection() & 1) != 0) {
                targetOperand = (InteractionOperand)cf.getOperands().get(0);
            } else if ((request.getResizeDirection() & 4) != 0) {
                targetOperand = (InteractionOperand)cf.getOperands().get(cf.getOperands().size() - 1);
            }
            InteractionOperandEditPart targetOperandEditPart = OperandBoundsComputeHelper.findTargetOperandEditPart(cf, targetOperand, combinedFragmentChildrenEditParts);
            int heightDelta = request.getSizeDelta().height();
            if (targetOperandEditPart != null && heightDelta < 0 && (height = targetOperandEditPart.getFigure().getBounds().height()) - Math.abs(heightDelta) < 10) {
                return false;
            }
        }
        return true;
    }

    public static void addUpdateBoundsCommandForOperandDelelete(EditPart editPart, ICompositeCommand cmd) {
        CombinedFragmentCombinedFragmentCompartmentEditPart compartment;
        if (editPart instanceof InteractionOperandEditPart && editPart.getParent() instanceof CombinedFragmentCombinedFragmentCompartmentEditPart && (compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)editPart.getParent()).getParent() instanceof CombinedFragmentEditPart) {
            Shape latterIOEPShape;
            Object latterIOEPModel;
            List combinedFragmentChildrenEditParts = compartment.getChildren();
            InteractionOperandEditPart previousIOEP = null;
            InteractionOperandEditPart latterIOEP = null;
            boolean isFirstOperand = false;
            InteractionOperandEditPart currentioEP = (InteractionOperandEditPart)editPart;
            final Rectangle currentioEPBounds = currentioEP.getFigure().getBounds();
            int i = 0;
            while (i < combinedFragmentChildrenEditParts.size()) {
                EditPart ep = (EditPart)combinedFragmentChildrenEditParts.get(i);
                if (ep instanceof InteractionOperandEditPart) {
                    InteractionOperandEditPart ioEP = (InteractionOperandEditPart)ep;
                    if (currentioEP == ioEP) {
                        if (previousIOEP != null) {
                            Shape previousIOEPShape;
                            Object previousIOEPModel = previousIOEP.getModel();
                            if (!(previousIOEPModel instanceof Shape) || !((previousIOEPShape = (Shape)previousIOEPModel).getLayoutConstraint() instanceof Bounds)) break;
                            final Bounds previousIOEPOriginalBounds = (Bounds)previousIOEPShape.getLayoutConstraint();
                            AbstractTransactionalCommand command = new AbstractTransactionalCommand(previousIOEP.getEditingDomain(), "Merge operand bounds command", null){

                                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                    previousIOEPOriginalBounds.setHeight(previousIOEPOriginalBounds.getHeight() + currentioEPBounds.height());
                                    return CommandResult.newOKCommandResult();
                                }
                            };
                            cmd.add((IUndoableOperation)command);
                            break;
                        }
                        isFirstOperand = true;
                    } else {
                        previousIOEP = ioEP;
                        if (isFirstOperand) {
                            latterIOEP = ioEP;
                            break;
                        }
                    }
                }
                ++i;
            }
            if (isFirstOperand && latterIOEP != null && (latterIOEPModel = latterIOEP.getModel()) instanceof Shape && (latterIOEPShape = (Shape)latterIOEPModel).getLayoutConstraint() instanceof Bounds) {
                final Bounds latterIOEPOriginalBounds = (Bounds)latterIOEPShape.getLayoutConstraint();
                AbstractTransactionalCommand command = new AbstractTransactionalCommand(previousIOEP.getEditingDomain(), "Merge operand bounds command", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        latterIOEPOriginalBounds.setY(0);
                        latterIOEPOriginalBounds.setHeight(latterIOEPOriginalBounds.getHeight() + currentioEPBounds.height());
                        return CommandResult.newOKCommandResult();
                    }
                };
                cmd.add((IUndoableOperation)command);
            }
        }
    }

    public static void addUpdateBoundsForIOCreationCommand(CombinedFragmentCombinedFragmentCompartmentEditPart compartment, CreateViewRequest.ViewDescriptor viewDescriptor, CompositeCommand command) {
        Node node;
        CombinedFragmentEditPart parent;
        List children = compartment.getChildren();
        if (children != null && children.size() > 0) {
            Bounds lastOperandBounds;
            InteractionOperandEditPart lastOperandEP = OperandBoundsComputeHelper.findLastIOEP(compartment);
            if (lastOperandEP != null && (lastOperandBounds = OperandBoundsComputeHelper.getInteractionOperandEPBounds((GraphicalEditPart)lastOperandEP)) != null) {
                Node node2;
                CombinedFragmentEditPart parent2;
                Rectangle rect = new Rectangle(lastOperandBounds.getX(), lastOperandBounds.getY() + lastOperandBounds.getHeight(), lastOperandBounds.getWidth(), 61);
                if (compartment.getParent() instanceof CombinedFragmentEditPart && (parent2 = (CombinedFragmentEditPart)compartment.getParent()).getModel() instanceof Node && (node2 = (Node)parent2.getModel()).getLayoutConstraint() instanceof Bounds) {
                    ICommand cmd;
                    CombinedFragment combinedFragment;
                    Bounds containerBounds = (Bounds)node2.getLayoutConstraint();
                    Dimension preferredSize = parent2.getFigure().getPreferredSize();
                    int width = containerBounds.getWidth() != -1 ? containerBounds.getWidth() : preferredSize.width();
                    int height = containerBounds.getHeight() != -1 ? containerBounds.getHeight() : preferredSize.height();
                    View shapeView = (View)parent2.getModel();
                    Rectangle newBounds = new Rectangle(containerBounds.getX(), containerBounds.getY(), width, height += 61);
                    SetBoundsCommand setParentBoundsCmd = new SetBoundsCommand(compartment.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)shapeView), newBounds);
                    command.add((IUndoableOperation)setParentBoundsCmd);
                    ICommand preserveMessageAnchorsCommand = MessageAnchorRepairer.createPreserveMessageAnchorsCommand(parent2, 61);
                    if (preserveMessageAnchorsCommand != null && preserveMessageAnchorsCommand.canExecute()) {
                        command.add((IUndoableOperation)preserveMessageAnchorsCommand);
                    }
                    if (!(combinedFragment = (CombinedFragment)parent2.resolveSemanticElement()).getCovereds().isEmpty() && (cmd = OperandBoundsComputeHelper.getExpandCoveredsCommand(parent2, newBounds)) != null) {
                        command.add((IUndoableOperation)cmd);
                    }
                }
                command.add((IUndoableOperation)new SetBoundsCommand(compartment.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, rect));
            }
        } else if (compartment.getParent() instanceof CombinedFragmentEditPart && (parent = (CombinedFragmentEditPart)compartment.getParent()).getModel() instanceof Node && (node = (Node)parent.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds containerBounds = (Bounds)node.getLayoutConstraint();
            Dimension preferredSize = parent.getFigure().getPreferredSize();
            int width = containerBounds.getWidth() != -1 ? containerBounds.getWidth() : preferredSize.width();
            int height = containerBounds.getHeight() != -1 ? containerBounds.getHeight() : preferredSize.height();
            command.add((IUndoableOperation)new SetBoundsCommand(compartment.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, new Rectangle(0, 0, width - 2, (height -= OperandBoundsComputeHelper.computeCombinedFragementHeaderHeight(parent)) - 2)));
        }
    }

    private static ICommand getExpandCoveredsCommand(CombinedFragmentEditPart parent, Rectangle newBounds) {
        CombinedFragment combinedFragment = (CombinedFragment)parent.resolveSemanticElement();
        CompositeCommand command = new CompositeCommand("Expand covered Lifeline by CombinedFragment");
        EList covereds = combinedFragment.getCovereds();
        block0: for (Lifeline lifeline : covereds) {
            Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)lifeline);
            for (EStructuralFeature.Setting ref : settings) {
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature())) continue;
                View view = (View)ref.getEObject();
                EditPart part = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)parent);
                if (!(view instanceof Node) || !(part instanceof LifelineEditPart)) continue;
                Bounds bounds = (Bounds)((Node)view).getLayoutConstraint();
                Rectangle rect = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                int height = newBounds.bottom() - rect.y;
                if (rect.height == -1) {
                    rect.height = ((LifelineEditPart)part).getFigure().getPreferredSize().height;
                }
                if (height <= rect.height) continue block0;
                int heightDelta = height - rect.height;
                rect.height = height;
                command.add((IUndoableOperation)new SetBoundsCommand(parent.getEditingDomain(), "Expand covered Lifeline by CombinedFragment", (IAdaptable)new EObjectAdapter((EObject)view), rect));
                command.add((IUndoableOperation)MessageAnchorRepairer.createPreserveMessageAnchorsCommand((ShapeNodeEditPart)((LifelineEditPart)part), heightDelta));
                continue block0;
            }
        }
        return command.isEmpty() ? null : command;
    }

    public static boolean isDerivedCombinedFragment(String hint) {
        if (((IHintedType)UMLElementTypes.CombinedFragment_3004).getSemanticHint().equals(hint)) {
            return true;
        }
        return ((IHintedType)UMLElementTypes.ConsiderIgnoreFragment_3007).getSemanticHint().equals(hint);
    }

    private static List<OperandBlock> getOperandBlocks(InteractionOperandEditPart editPart) {
        ArrayList<OperandBlock> blocks = new ArrayList<OperandBlock>();
        if (editPart != null) {
            ShapeNodeEditPart child;
            Object object;
            List existingViews;
            InteractionOperand interactionOperand = (InteractionOperand)editPart.resolveSemanticElement();
            HashSet<ExecutionSpecification> executions = new HashSet<ExecutionSpecification>();
            HashSet<Message> messages = new HashSet<Message>();
            EList fragments = interactionOperand.getFragments();
            for (InteractionFragment fragment : fragments) {
                Message message;
                if (fragment instanceof ExecutionSpecification) {
                    executions.add((ExecutionSpecification)fragment);
                    continue;
                }
                if (fragment instanceof ExecutionOccurrenceSpecification) {
                    ExecutionSpecification execution = ((ExecutionOccurrenceSpecification)fragment).getExecution();
                    if (execution == null) continue;
                    executions.add(execution);
                    continue;
                }
                if (!(fragment instanceof MessageOccurrenceSpecification) || (message = ((MessageOccurrenceSpecification)fragment).getMessage()) == null) continue;
                messages.add(message);
            }
            EditPartViewer viewer = editPart.getViewer();
            if (!executions.isEmpty()) {
                block1: for (ExecutionSpecification execution : executions) {
                    existingViews = DiagramEditPartsUtil.findViews((EObject)execution, (EditPartViewer)viewer);
                    if (existingViews.isEmpty()) continue;
                    for (View view : existingViews) {
                        object = viewer.getEditPartRegistry().get(view);
                        if (!(object instanceof ShapeNodeEditPart)) continue;
                        child = (ShapeNodeEditPart)object;
                        boolean visited = false;
                        for (OperandBlock blk : blocks) {
                            if (!blk.contains((EditPart)child)) continue;
                            visited = true;
                            break;
                        }
                        if (visited) continue block1;
                        ExecutionOperandBlock newBlock = new ExecutionOperandBlock(child, executions);
                        blocks.add(newBlock);
                    }
                }
            }
            if (!messages.isEmpty()) {
                block4: for (Message msg : messages) {
                    existingViews = DiagramEditPartsUtil.findViews((EObject)msg, (EditPartViewer)viewer);
                    if (existingViews.isEmpty()) continue;
                    for (View view : existingViews) {
                        EditPart target;
                        EditPart source;
                        object = viewer.getEditPartRegistry().get(view);
                        if (!(object instanceof ConnectionNodeEditPart) || (source = (child = (ConnectionNodeEditPart)object).getSource()) instanceof AbstractExecutionSpecificationEditPart && executions.contains(((AbstractExecutionSpecificationEditPart)source).resolveSemanticElement()) || (target = child.getTarget()) instanceof AbstractExecutionSpecificationEditPart && executions.contains(((AbstractExecutionSpecificationEditPart)target).resolveSemanticElement())) continue;
                        boolean visited = false;
                        for (OperandBlock blk : blocks) {
                            if (!blk.contains((EditPart)child)) continue;
                            visited = true;
                            break;
                        }
                        if (visited) continue block4;
                        MessageOperandBlock newBlock = new MessageOperandBlock((ConnectionNodeEditPart)child);
                        blocks.add(newBlock);
                    }
                }
            }
        }
        return blocks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutionOperandBlock
    extends OperandBlock {
        public ExecutionOperandBlock(ShapeNodeEditPart child, Set<ExecutionSpecification> executions) {
            this.fillWith(child, executions);
        }

        private void fillWith(ShapeNodeEditPart child, Set<ExecutionSpecification> executions) {
            if (this.children.contains(child) || child == null || executions == null || executions.isEmpty()) {
                return;
            }
            this.children.add(child);
            ArrayList<ExecutionSpecification> toCheckExecutions = new ArrayList<ExecutionSpecification>(executions);
            toCheckExecutions.remove(child.resolveSemanticElement());
            Set<ShapeNodeEditPart> executionGroups = this.getExecutionGroups(child, toCheckExecutions);
            if (executionGroups != null && !executionGroups.isEmpty()) {
                for (ShapeNodeEditPart group : executionGroups) {
                    this.fillWith(group, executions);
                }
            }
            LifelineEditPart parent = (LifelineEditPart)child.getParent();
            List<ShapeNodeEditPart> childShapeNodeEditPart = LifelineEditPartUtil.getChildShapeNodeEditPart(parent);
            childShapeNodeEditPart.remove(child);
            ShapeNodeEditPart parentNode = LifelineXYLayoutEditPolicy.getParent(parent, child.getFigure().getBounds().getCopy(), childShapeNodeEditPart);
            if (parentNode != null) {
                this.fillWith(parentNode, executions);
            }
            List<ShapeNodeEditPart> affixedEditParts = LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(child);
            for (ShapeNodeEditPart affixedChild : affixedEditParts) {
                if (!executions.contains(affixedChild.resolveSemanticElement())) continue;
                this.fillWith(affixedChild, executions);
            }
        }

        @Override
        protected Rectangle computeBounds() {
            Rectangle bounds = null;
            for (EditPart child : this.children) {
                Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)child);
                if (bounds == null) {
                    bounds = rect;
                    continue;
                }
                bounds.union(rect);
            }
            return bounds;
        }

        private Set<ShapeNodeEditPart> getExecutionGroups(ShapeNodeEditPart executionEditPart, List<ExecutionSpecification> toCheckExecutions) {
            if (toCheckExecutions == null || toCheckExecutions.isEmpty()) {
                return null;
            }
            HashSet<ShapeNodeEditPart> executionGroups = new HashSet<ShapeNodeEditPart>();
            ArrayList connections = new ArrayList();
            connections.addAll(executionEditPart.getSourceConnections());
            connections.addAll(executionEditPart.getTargetConnections());
            for (Object object : connections) {
                View model;
                EObject element;
                ConnectionEditPart conn = (ConnectionEditPart)object;
                IGraphicalEditPart source = (IGraphicalEditPart)conn.getSource();
                if (executionEditPart == conn.getSource()) {
                    source = (IGraphicalEditPart)conn.getTarget();
                }
                if (!toCheckExecutions.contains(element = (model = (View)source.getModel()).getElement())) continue;
                executionGroups.add((ShapeNodeEditPart)source);
                ArrayList<ExecutionSpecification> myCheckingList = new ArrayList<ExecutionSpecification>(toCheckExecutions);
                myCheckingList.remove(element);
                Set<ShapeNodeEditPart> myGroups = this.getExecutionGroups((ShapeNodeEditPart)source, myCheckingList);
                if (myGroups == null) continue;
                executionGroups.addAll(myGroups);
            }
            return executionGroups;
        }

        public List<ShapeNodeEditPart> getShapeNodeChildren() {
            ArrayList<ShapeNodeEditPart> shapes = new ArrayList<ShapeNodeEditPart>();
            List<EditPart> children = this.getChildren();
            for (EditPart editPart : children) {
                if (!(editPart instanceof ShapeNodeEditPart)) continue;
                shapes.add((ShapeNodeEditPart)editPart);
            }
            return shapes;
        }
    }

    private static class MessageOperandBlock
    extends OperandBlock {
        public MessageOperandBlock(ConnectionNodeEditPart child) {
            this.children.add(child);
        }

        protected Rectangle computeBounds() {
            ConnectionNodeEditPart message = this.getMessageChild();
            if (message == null) {
                return null;
            }
            Point start = SequenceUtil.getAbsoluteEdgeExtremity(message, true);
            Point end = SequenceUtil.getAbsoluteEdgeExtremity(message, false);
            Rectangle bounds = new Rectangle(start, end);
            if (message.getSource() instanceof GateEditPart || message.getTarget() instanceof GateEditPart) {
                bounds.expand(0.0, (double)Math.round((double)(GateEditPart.DEFAULT_SIZE.height - bounds.height) / 2.0));
            }
            if (bounds.height < 3) {
                bounds.height = 3;
            }
            return bounds;
        }

        public ConnectionNodeEditPart getMessageChild() {
            return (ConnectionNodeEditPart)(this.children.isEmpty() ? null : (EditPart)this.children.get(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveOperandBlockCommand
    extends AbstractTransactionalCommand {
        private Map<OperandBlock, Integer> blockToMove;

        public MoveOperandBlockCommand(TransactionalEditingDomain domain, Map<OperandBlock, Integer> blockToMove) {
            super(domain, "move operand blocks", null);
            this.blockToMove = blockToMove;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ArrayList<OperandBlock> blocks = new ArrayList<OperandBlock>(this.blockToMove.keySet());
            Collections.sort(blocks, new Comparator<OperandBlock>(){

                @Override
                public int compare(OperandBlock o1, OperandBlock o2) {
                    int m2;
                    int m1 = Math.abs((Integer)MoveOperandBlockCommand.this.blockToMove.get(o1));
                    if (m1 < (m2 = Math.abs((Integer)MoveOperandBlockCommand.this.blockToMove.get(o2)))) {
                        return -1;
                    }
                    if (m1 > m2) {
                        return 1;
                    }
                    if (m1 == m2 && m1 > 0) {
                        int y1 = o1.getBounds().y;
                        int y2 = o2.getBounds().y;
                        if (y1 > y2) {
                            return -1;
                        }
                        if (y1 < y2) {
                            return 1;
                        }
                    }
                    return 0;
                }
            });
            int i = 0;
            while (i < blocks.size()) {
                int moveDelta;
                OperandBlock block = (OperandBlock)blocks.get(i);
                org.eclipse.gef.commands.Command command = this.getMoveOperandBlockCommand(block, moveDelta = this.blockToMove.get(block).intValue());
                if (command != null && command.canExecute()) {
                    command.execute();
                }
                ++i;
            }
            this.blockToMove = null;
            return CommandResult.newOKCommandResult();
        }

        private org.eclipse.gef.commands.Command getMoveOperandBlockCommand(OperandBlock block, int moveDelta) {
            ConnectionNodeEditPart message;
            if (block == null || moveDelta == 0) {
                return null;
            }
            CompoundCommand commands = new CompoundCommand();
            if (block instanceof ExecutionOperandBlock) {
                List<ShapeNodeEditPart> children = ((ExecutionOperandBlock)block).getShapeNodeChildren();
                for (ShapeNodeEditPart child : children) {
                    Bounds bounds = OperandBoundsComputeHelper.getInteractionOperandEPBounds((GraphicalEditPart)child);
                    Rectangle newBounds = OperandBoundsComputeHelper.fillRectangle(bounds);
                    newBounds.y += moveDelta;
                    CompoundCommand moveCommand = new CompoundCommand();
                    SetBoundsCommand cmd = new SetBoundsCommand(this.getEditingDomain(), this.getLabel(), (IAdaptable)child, newBounds);
                    moveCommand.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)cmd));
                    moveCommand = OccurrenceSpecificationMoveHelper.completeMoveExecutionSpecificationCommand(moveCommand, child, newBounds, new ChangeBoundsRequest());
                    List targetConnections = child.getTargetConnections();
                    for (Object object : targetConnections) {
                        ICommand moveAnchorCommand;
                        AbstractMessageEditPart conn;
                        EditPart source;
                        if (!(object instanceof AbstractMessageEditPart) || (source = (conn = (AbstractMessageEditPart)((Object)object)).getSource()) instanceof AbstractExecutionSpecificationEditPart) continue;
                        Edge edge = (Edge)conn.getNotationView();
                        Connection connectionFigure = conn.getConnectionFigure();
                        ConnectionAnchor sourceAnchor = connectionFigure.getSourceAnchor();
                        Rectangle figureBounds = sourceAnchor.getOwner().getBounds();
                        Anchor gmfTargetAnchor = edge.getSourceAnchor();
                        if (!(gmfTargetAnchor instanceof IdentityAnchor) || (moveAnchorCommand = OperandBoundsComputeHelper.getMoveAnchorCommand(moveDelta, figureBounds, (IdentityAnchor)gmfTargetAnchor)) == null || !moveAnchorCommand.canExecute()) continue;
                        commands.add((org.eclipse.gef.commands.Command)new ICommandProxy(moveAnchorCommand));
                    }
                    List sourceConnections = child.getSourceConnections();
                    for (Object object : sourceConnections) {
                        ICommand moveAnchorCommand;
                        AbstractMessageEditPart conn;
                        EditPart target;
                        if (!(object instanceof AbstractMessageEditPart) || (target = (conn = (AbstractMessageEditPart)((Object)object)).getTarget()) instanceof AbstractExecutionSpecificationEditPart) continue;
                        Edge edge = (Edge)conn.getNotationView();
                        Connection connectionFigure = conn.getConnectionFigure();
                        ConnectionAnchor targetAnchor = connectionFigure.getTargetAnchor();
                        Rectangle figureBounds = targetAnchor.getOwner().getBounds();
                        Anchor gmfTargetAnchor = edge.getTargetAnchor();
                        if (!(gmfTargetAnchor instanceof IdentityAnchor) || (moveAnchorCommand = OperandBoundsComputeHelper.getMoveAnchorCommand(moveDelta, figureBounds, (IdentityAnchor)gmfTargetAnchor)) == null || !moveAnchorCommand.canExecute()) continue;
                        commands.add((org.eclipse.gef.commands.Command)new ICommandProxy(moveAnchorCommand));
                    }
                    commands.add((org.eclipse.gef.commands.Command)moveCommand);
                }
            } else if (block instanceof MessageOperandBlock && (message = ((MessageOperandBlock)block).getMessageChild()) != null) {
                Rectangle figureBounds;
                SetBoundsCommand command;
                Point location;
                Location layout;
                GateEditPart gate;
                Edge edge = (Edge)message.getModel();
                Connection msgFigure = message.getConnectionFigure();
                if (message.getSource() instanceof GateEditPart) {
                    gate = (GateEditPart)message.getSource();
                    layout = (Location)((Shape)gate.getNotationView()).getLayoutConstraint();
                    location = new Point(layout.getX(), layout.getY());
                    location.y += moveDelta;
                    command = new SetBoundsCommand(this.getEditingDomain(), "", (IAdaptable)gate, location);
                    commands.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)command));
                } else {
                    ConnectionAnchor sourceAnchor = msgFigure.getSourceAnchor();
                    IdentityAnchor gmfSourceAnchor = (IdentityAnchor)edge.getSourceAnchor();
                    figureBounds = sourceAnchor.getOwner().getBounds();
                    if (gmfSourceAnchor != null) {
                        commands.add((org.eclipse.gef.commands.Command)new ICommandProxy(OperandBoundsComputeHelper.getMoveAnchorCommand(moveDelta, figureBounds, gmfSourceAnchor)));
                    }
                }
                if (message.getTarget() instanceof GateEditPart) {
                    gate = (GateEditPart)message.getTarget();
                    layout = (Location)((Shape)gate.getNotationView()).getLayoutConstraint();
                    location = new Point(layout.getX(), layout.getY());
                    location.y += moveDelta;
                    command = new SetBoundsCommand(this.getEditingDomain(), "", (IAdaptable)gate, location);
                    commands.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)command));
                } else {
                    IdentityAnchor gmfTargetAnchor = (IdentityAnchor)edge.getTargetAnchor();
                    ConnectionAnchor targetAnchor = msgFigure.getTargetAnchor();
                    figureBounds = targetAnchor.getOwner().getBounds();
                    if (gmfTargetAnchor != null) {
                        commands.add((org.eclipse.gef.commands.Command)new ICommandProxy(OperandBoundsComputeHelper.getMoveAnchorCommand(moveDelta, figureBounds, gmfTargetAnchor)));
                    }
                }
            }
            return commands.unwrap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class OperandBlock {
        protected List<EditPart> children = new ArrayList<EditPart>();

        private OperandBlock() {
        }

        public boolean contains(EditPart child) {
            return this.children.contains(child);
        }

        public Rectangle getBounds() {
            return this.computeBounds();
        }

        public List<EditPart> getChildren() {
            return new ArrayList<EditPart>(this.children);
        }

        protected abstract Rectangle computeBounds();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OperandBlockLayout {
        private Map<OperandBlock, Rectangle> constraints = new HashMap<OperandBlock, Rectangle>();
        private List<OperandBlock> fBlocks = new ArrayList<OperandBlock>();
        private List<Rectangle> validBlocks = new ArrayList<Rectangle>();

        public OperandBlockLayout(List<OperandBlock> blocks) {
            if (blocks != null) {
                for (OperandBlock blk : blocks) {
                    if (blk.getBounds() == null) continue;
                    this.fBlocks.add(blk);
                }
            }
        }

        private void sortBlocks() {
            Collections.sort(this.fBlocks, new Comparator<OperandBlock>(){

                @Override
                public int compare(OperandBlock o1, OperandBlock o2) {
                    Rectangle r1 = o1.getBounds();
                    Rectangle r2 = o2.getBounds();
                    if (r1.y < r2.y) {
                        return -1;
                    }
                    if (r1.y > r2.y) {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        public void layout(Rectangle newArea, boolean moveDown) {
            this.constraints.clear();
            this.validBlocks.clear();
            this.sortBlocks();
            if (!moveDown) {
                Collections.reverse(this.fBlocks);
            }
            this.doLayout(newArea, this.fBlocks, moveDown);
        }

        public int getMoveDelta(OperandBlock block) {
            Rectangle rect = this.constraints.get(block);
            if (rect == null) {
                return 0;
            }
            Rectangle bounds = block.getBounds();
            return rect.y - bounds.y;
        }

        private Rectangle getConstraint(OperandBlock blk) {
            Rectangle rect = this.constraints.get(blk);
            if (rect == null) {
                rect = blk.getBounds();
            }
            return rect;
        }

        private boolean doLayout(Rectangle area, List<OperandBlock> blocks, boolean moveDown) {
            int start;
            if (blocks.isEmpty()) {
                return false;
            }
            OperandBlock invalidBlock = blocks.get(0);
            if (this.isValidBlock(area, invalidBlock)) {
                return false;
            }
            if (invalidBlock == null) {
                return false;
            }
            Rectangle rect = invalidBlock.getBounds();
            Rectangle newRect = new Rectangle(rect);
            if (moveDown) {
                int y = start = rect.y > area.y ? rect.y : area.y;
                while (y < area.bottom() - rect.height) {
                    newRect.setY(y);
                    if (!this.isValidBlock(area, newRect.getExpanded(0, 3))) {
                        ++y;
                        continue;
                    }
                    break;
                }
            } else {
                int y = start = rect.bottom() < area.bottom() ? rect.y : area.bottom() - rect.height;
                while (y > area.y) {
                    newRect.setY(y);
                    if (!this.isValidBlock(area, newRect.getExpanded(0, 3))) {
                        --y;
                        continue;
                    }
                    break;
                }
            }
            this.constraints.put(invalidBlock, newRect);
            this.validBlocks.add(newRect);
            ArrayList<OperandBlock> remainBlocks = new ArrayList<OperandBlock>(blocks);
            remainBlocks.remove(invalidBlock);
            return this.doLayout(area, remainBlocks, moveDown);
        }

        private boolean isValidBlock(Rectangle area, OperandBlock blk) {
            Rectangle rect = this.getConstraint(blk);
            return this.isValidBlock(area, rect);
        }

        private boolean isValidBlock(Rectangle area, Rectangle block) {
            if (area.y > block.y || area.bottom() < block.bottom()) {
                return false;
            }
            for (Rectangle validRect : this.validBlocks) {
                if (!block.intersects(validRect)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class UpdateIOBoundsForCFResizeCommand
    extends AbstractTransactionalCommand {
        private final Bounds ioEPOriginalBounds;
        private final ChangeBoundsRequest request;
        private final Dimension sizeDelta;
        private boolean updateHeight = false;
        private int direction;

        private UpdateIOBoundsForCFResizeCommand(TransactionalEditingDomain domain, String label, Bounds ioEPOriginalBounds, ChangeBoundsRequest request, Dimension sizeDelta, boolean updateHeight, int direction) {
            super(domain, label, null);
            this.ioEPOriginalBounds = ioEPOriginalBounds;
            this.request = request;
            this.sizeDelta = sizeDelta;
            this.updateHeight = updateHeight;
            this.direction = direction;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.updateHeight) {
                this.ioEPOriginalBounds.setHeight(this.ioEPOriginalBounds.getHeight() + this.sizeDelta.height());
            } else if ((this.direction & 1) != 0) {
                this.ioEPOriginalBounds.setY(this.ioEPOriginalBounds.getY() + this.sizeDelta.height());
            }
            if ((this.request.getResizeDirection() & 0x18) != 0) {
                this.ioEPOriginalBounds.setWidth(this.ioEPOriginalBounds.getWidth() + this.sizeDelta.width());
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

