/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.pr;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.util.UrlUtils;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.github.core.GitHub;

public abstract class PullRequestUtils {
    public static final String HEAD_SOURCE = "+refs/heads/*";

    public static String getDesintationRef(RemoteConfig remote) {
        return "refs/remotes/" + remote.getName() + "/*";
    }

    public static String getBranchName(PullRequest request) {
        return "pull-request-" + request.getNumber();
    }

    public static org.eclipse.jgit.lib.Repository getRepository(PullRequest request) {
        Repository remoteRepo = request.getBase().getRepo();
        String id = String.valueOf(remoteRepo.getOwner().getLogin()) + '/' + remoteRepo.getName() + ".git";
        RepositoryCache cache = Activator.getDefault().getRepositoryCache();
        for (String path : Activator.getDefault().getRepositoryUtil().getConfiguredRepositories()) {
            try {
                org.eclipse.jgit.lib.Repository repo = cache.lookupRepository(new File(path));
                RemoteConfig rc = new RemoteConfig((Config)repo.getConfig(), "origin");
                for (URIish uri : rc.getURIs()) {
                    if (!uri.toString().endsWith(id)) continue;
                    return repo;
                }
            }
            catch (IOException e) {
                GitHub.logError(e);
            }
            catch (URISyntaxException e) {
                GitHub.logError(e);
            }
        }
        return null;
    }

    public static void configureTopicBranch(org.eclipse.jgit.lib.Repository repo, PullRequest request) throws IOException {
        String branch = PullRequestUtils.getBranchName(request);
        String remote = request.getHead().getRepo().getOwner().getLogin();
        StoredConfig config = repo.getConfig();
        config.setString("branch", branch, "merge", PullRequestUtils.getHeadBranch(request));
        config.setString("branch", branch, "remote", remote);
        config.save();
    }

    public static String getOwner(PullRequestMarker marker) {
        if (marker == null) {
            return null;
        }
        Repository repo = marker.getRepo();
        if (repo == null) {
            return null;
        }
        User owner = repo.getOwner();
        return owner != null ? owner.getLogin() : null;
    }

    public static boolean isFromSameRepository(PullRequest request) {
        if (request == null) {
            return false;
        }
        String headLogin = PullRequestUtils.getOwner(request.getHead());
        if (headLogin == null) {
            return false;
        }
        return headLogin.equals(PullRequestUtils.getOwner(request.getBase()));
    }

    public static RemoteConfig getRemote(org.eclipse.jgit.lib.Repository repo, PullRequest request) throws URISyntaxException {
        if (PullRequestUtils.isFromSameRepository(request)) {
            return PullRequestUtils.getRemoteConfig(repo, "origin");
        }
        return PullRequestUtils.getRemoteConfig(repo, PullRequestUtils.getOwner(request.getHead()));
    }

    public static RemoteConfig getRemoteConfig(org.eclipse.jgit.lib.Repository repo, String name) throws URISyntaxException {
        for (RemoteConfig candidate : RemoteConfig.getAllRemoteConfigs((Config)repo.getConfig())) {
            if (!name.equals(candidate.getName())) continue;
            return candidate;
        }
        return null;
    }

    public static RemoteConfig addRemote(org.eclipse.jgit.lib.Repository repo, PullRequest request) throws IOException, URISyntaxException {
        RemoteConfig remote = PullRequestUtils.getRemote(repo, request);
        if (remote != null) {
            return remote;
        }
        StoredConfig config = repo.getConfig();
        Repository head = request.getHead().getRepo();
        remote = new RemoteConfig((Config)config, head.getOwner().getLogin());
        if (head.isPrivate()) {
            remote.addURI(new URIish(UrlUtils.createRemoteSshUrl((IRepositoryIdProvider)head)));
        } else {
            remote.addURI(new URIish(UrlUtils.createRemoteReadOnlyUrl((IRepositoryIdProvider)head)));
        }
        remote.addFetchRefSpec(new RefSpec("+refs/heads/*:" + PullRequestUtils.getDesintationRef(remote)));
        remote.update((Config)config);
        config.save();
        return remote;
    }

    public static boolean isCurrentBranch(String name, org.eclipse.jgit.lib.Repository repo) {
        try {
            return name.equals(org.eclipse.jgit.lib.Repository.shortenRefName((String)repo.getFullBranch()));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getHeadBranch(PullRequest request) {
        PullRequestMarker head = request.getHead();
        return "refs/remotes/" + head.getRepo().getOwner().getLogin() + "/" + head.getRef();
    }
}

