/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.bundle;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.server.bundle.CDOServerApplication;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.CDOServerImporter;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;

public class CDOCommandProvider
implements CommandProvider {
    private static final String NEW_LINE = "\r\n";
    private static final String INDENT = "   ";

    public CDOCommandProvider(BundleContext bundleContext) {
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---CDO commands---\r\n");
        buffer.append("   cdo list - list all active repositories\r\n");
        buffer.append("   cdo start - start repositories from a config file\r\n");
        buffer.append("   cdo stop - stop a repository\r\n");
        buffer.append("   cdo export - export the contents of a repository to an XML file\r\n");
        buffer.append("   cdo import - import the contents of a repository from an XML file\r\n");
        buffer.append("   cdo sessions - dump the sessions of a repository\r\n");
        buffer.append("   cdo packages - dump the packages of a repository\r\n");
        buffer.append("   cdo branches - dump the branches of a repository\r\n");
        buffer.append("   cdo locks - dump the durable locking areas of a repository\r\n");
        buffer.append("   cdo deletelocks - delete a durable locking area of a repository\r\n");
        return buffer.toString();
    }

    public Object _cdo(CommandInterpreter interpreter) {
        block22: {
            String cmd;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                cmd = interpreter.nextArgument();
                                                if (!"list".equals(cmd)) break block13;
                                                this.list(interpreter);
                                                return null;
                                            }
                                            if (!"start".equals(cmd)) break block14;
                                            this.start(interpreter);
                                            return null;
                                        }
                                        if (!"stop".equals(cmd)) break block15;
                                        this.stop(interpreter);
                                        return null;
                                    }
                                    if (!"export".equals(cmd)) break block16;
                                    this.exportXML(interpreter);
                                    return null;
                                }
                                if (!"import".equals(cmd)) break block17;
                                this.importXML(interpreter);
                                return null;
                            }
                            if (!"sessions".equals(cmd)) break block18;
                            this.sessions(interpreter);
                            return null;
                        }
                        if (!"packages".equals(cmd)) break block19;
                        this.packages(interpreter);
                        return null;
                    }
                    if (!"branches".equals(cmd)) break block20;
                    this.branches(interpreter);
                    return null;
                }
                if (!"locks".equals(cmd)) break block21;
                this.locks(interpreter);
                return null;
            }
            if (!"deletelocks".equals(cmd)) break block22;
            this.deleteLocks(interpreter);
            return null;
        }
        try {
            interpreter.println((Object)this.getHelp());
        }
        catch (CommandException ex) {
            interpreter.println((Object)ex.getMessage());
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    protected void list(CommandInterpreter interpreter) throws Exception {
        IManagedContainer container = CDOServerApplication.getContainer();
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof InternalRepository) {
                InternalRepository repository = (InternalRepository)element;
                interpreter.println((Object)repository.getName());
            }
            ++n2;
        }
    }

    protected void start(CommandInterpreter interpreter) throws Exception {
        String configFile = this.nextArgument(interpreter, "Syntax: cdo start <config-file>");
        IManagedContainer container = CDOServerApplication.getContainer();
        RepositoryConfigurator repositoryConfigurator = new RepositoryConfigurator(container);
        IRepository[] repositories = repositoryConfigurator.configure(new File(configFile));
        interpreter.println((Object)"Repositories started:");
        if (repositories != null) {
            IRepository[] iRepositoryArray = repositories;
            int n = repositories.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository repository = iRepositoryArray[n2];
                interpreter.println((Object)repository.getName());
                ++n2;
            }
        }
    }

    protected void stop(CommandInterpreter interpreter) throws Exception {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo stop <repository-name>");
        LifecycleUtil.deactivate((Object)repository);
        interpreter.println((Object)"Repository stopped");
    }

    protected void exportXML(CommandInterpreter interpreter) throws Exception {
        String syntax = "Syntax: cdo export <repository-name> <export-file>";
        InternalRepository repository = this.getRepository(interpreter, syntax);
        String exportFile = this.nextArgument(interpreter, syntax);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(exportFile);
            CDOServerExporter.XML exporter = new CDOServerExporter.XML(repository);
            exporter.exportRepository(out);
            interpreter.println((Object)"Repository exported");
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Closeable)out);
    }

    protected void importXML(CommandInterpreter interpreter) throws Exception {
        String syntax = "Syntax: cdo import <repository-name> <import-file>";
        InternalRepository repository = this.getRepository(interpreter, syntax);
        String importFile = this.nextArgument(interpreter, syntax);
        FileInputStream in = null;
        try {
            in = new FileInputStream(importFile);
            LifecycleUtil.deactivate((Object)repository);
            CDOServerImporter.XML importer = new CDOServerImporter.XML(repository);
            importer.importRepository(in);
            IManagedContainer container = CDOServerApplication.getContainer();
            CDOServerUtil.addRepository(container, repository);
            interpreter.println((Object)"Repository imported");
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    protected void sessions(CommandInterpreter interpreter) {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo sessions <repository-name>");
        InternalSessionManager sessionManager = repository.getSessionManager();
        InternalSession[] internalSessionArray = sessionManager.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            interpreter.println((Object)session);
            InternalView[] internalViewArray = session.getViews();
            int n3 = internalViewArray.length;
            int n4 = 0;
            while (n4 < n3) {
                InternalView view = internalViewArray[n4];
                interpreter.println((Object)(INDENT + view));
                ++n4;
            }
            ++n2;
        }
    }

    protected void packages(CommandInterpreter interpreter) {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo packages <repository-name>");
        InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageRegistry.getPackageUnits();
        int n = internalCDOPackageUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            interpreter.println((Object)packageUnit);
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
            int n3 = internalCDOPackageInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                interpreter.println((Object)(INDENT + packageInfo));
                ++n4;
            }
            ++n2;
        }
    }

    protected void branches(CommandInterpreter interpreter) {
        InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo branches <repository-name>");
        this.branches(interpreter, repository.getBranchManager().getMainBranch(), "");
    }

    protected void locks(final CommandInterpreter interpreter) {
        final InternalRepository repository = this.getRepository(interpreter, "Syntax: cdo locks <repository-name> [<username-prefix>]");
        final String userIDPrefix = this.nextArgument(interpreter, null);
        new WithAccessor(){

            protected void doExecute(IStoreAccessor accessor) {
                repository.getLockingManager().getLockAreas(userIDPrefix, new IDurableLockingManager.LockArea.Handler(){

                    public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                        interpreter.println((Object)area.getDurableLockingID());
                        interpreter.println((Object)("   userID = " + area.getUserID()));
                        interpreter.println((Object)("   branch = " + area.getBranch()));
                        interpreter.println((Object)("   timeStamp = " + CDOCommonUtil.formatTimeStamp((long)area.getTimeStamp())));
                        interpreter.println((Object)("   readOnly = " + area.isReadOnly()));
                        interpreter.println((Object)("   locks = " + area.getLocks()));
                        return true;
                    }
                });
            }
        }.execute(repository);
    }

    protected void deleteLocks(CommandInterpreter interpreter) {
        String syntax = "Syntax: cdo deletelocks <repository-name> <area-id>";
        final InternalRepository repository = this.getRepository(interpreter, syntax);
        final String durableLockingID = this.nextArgument(interpreter, syntax);
        new WithAccessor(){

            protected void doExecute(IStoreAccessor accessor) {
                repository.getLockingManager().deleteLockArea(durableLockingID);
            }
        }.execute(repository);
    }

    private void branches(CommandInterpreter interpreter, InternalCDOBranch branch, String prefix) {
        interpreter.println((Object)(String.valueOf(prefix) + branch));
        prefix = String.valueOf(prefix) + INDENT;
        InternalCDOBranch[] internalCDOBranchArray = branch.getBranches();
        int n = internalCDOBranchArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOBranch child = internalCDOBranchArray[n2];
            this.branches(interpreter, child, prefix);
            ++n2;
        }
    }

    private String nextArgument(CommandInterpreter interpreter, String syntax) {
        String argument = interpreter.nextArgument();
        if (argument == null && syntax != null) {
            throw new CommandException(syntax);
        }
        return argument;
    }

    private InternalRepository getRepository(CommandInterpreter interpreter, String syntax) {
        String repositoryName = this.nextArgument(interpreter, syntax);
        InternalRepository repository = this.getRepository(repositoryName);
        if (repository == null) {
            throw new CommandException("Repository not found: " + repositoryName);
        }
        return repository;
    }

    private InternalRepository getRepository(String name) {
        IManagedContainer container = CDOServerApplication.getContainer();
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalRepository repository;
            Object element = objectArray[n2];
            if (element instanceof InternalRepository && (repository = (InternalRepository)element).getName().equals(name)) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    private static final class CommandException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CommandException(String message) {
            super(message);
        }
    }

    protected static abstract class WithAccessor {
        protected WithAccessor() {
        }

        public void execute(InternalRepository repository) {
            IStoreAccessor accessor = repository.getStore().getReader(null);
            StoreThreadLocal.setAccessor(accessor);
            try {
                this.doExecute(accessor);
            }
            finally {
                StoreThreadLocal.release();
            }
        }

        protected abstract void doExecute(IStoreAccessor var1);
    }
}

