/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lob.CDOLobUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.AsyncOutputStream;
import org.eclipse.net4j.util.io.AsyncWriter;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class CDOServerImporter {
    private InternalRepository repository;

    public CDOServerImporter(IRepository repository) {
        this.repository = (InternalRepository)repository;
        this.init();
    }

    private void init() {
        LifecycleUtil.checkInactive((Object)this.repository);
        this.repository.setSkipInitialization(true);
        this.repository.getStore().setDropAllDataOnActivate(true);
        LifecycleUtil.activate((Object)this.repository);
    }

    protected final InternalRepository getRepository() {
        return this.repository;
    }

    public void importRepository(InputStream in) throws Exception {
        try {
            FlushHandler handler = new FlushHandler();
            this.importAll(in, handler);
            handler.flush();
        }
        finally {
            StoreThreadLocal.release();
            this.repository = null;
        }
    }

    protected abstract void importAll(InputStream var1, Handler var2) throws Exception;

    private final class FlushHandler
    implements Handler {
        private OMMonitor monitor = new Monitor();
        private IStoreAccessor.Raw accessor;
        private Map<String, String> models = new HashMap<String, String>();
        private LinkedList<InternalCDOPackageUnit> packageUnits = new LinkedList();
        private List<InternalCDOPackageInfo> packageInfos;
        private InternalCDOPackageRegistry packageRegistry;

        public FlushHandler() {
            this.packageRegistry = CDOServerImporter.this.getRepository().getPackageRegistry(false);
        }

        public void handleRepository(String name, String uuid, CDOID root, long created, long committed) {
            CDOServerImporter.this.repository.getStore().setCreationTime(created);
            CDOServerImporter.this.repository.getStore().setLastCommitTime(committed);
            InternalCDOBranchManager branchManager = CDOServerImporter.this.repository.getBranchManager();
            CDOServerImporter.this.repository.initMainBranch(branchManager, created);
            LifecycleUtil.activate((Object)branchManager);
            CDOServerImporter.this.repository.initSystemPackages();
            CDOServerImporter.this.repository.setRootResourceID(root);
            this.accessor = (IStoreAccessor.Raw)CDOServerImporter.this.repository.getStore().getWriter(null);
            StoreThreadLocal.setAccessor(this.accessor);
        }

        public InternalCDOPackageUnit handlePackageUnit(String id, CDOPackageUnit.Type type, long time, String data) {
            this.collectPackageInfos();
            InternalCDOPackageUnit packageUnit = this.packageRegistry.createPackageUnit();
            packageUnit.setOriginalType(type);
            packageUnit.setTimeStamp(time);
            this.models.put(id, data);
            this.packageUnits.add(packageUnit);
            this.packageInfos = new ArrayList<InternalCDOPackageInfo>();
            return packageUnit;
        }

        public InternalCDOPackageInfo handlePackageInfo(String packageURI) {
            InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
            packageInfo.setPackageURI(packageURI);
            this.packageInfos.add(packageInfo);
            return packageInfo;
        }

        public InternalCDOPackageRegistry handleModels() {
            this.collectPackageInfos();
            InternalCDOPackageUnit[] array = this.packageUnits.toArray(new InternalCDOPackageUnit[this.packageUnits.size()]);
            this.packageUnits = null;
            final EMFUtil.ExtResourceSet resourceSet = EMFUtil.createExtResourceSet((InternalCDOPackageRegistry)this.packageRegistry, (boolean)false, (boolean)false);
            InternalCDOPackageRegistry.PackageLoader loader = new InternalCDOPackageRegistry.PackageLoader(){

                public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
                    String id = packageUnit.getID();
                    String data = (String)FlushHandler.this.models.get(id);
                    EPackage ePackage = EMFUtil.createEPackage((String)id, (byte[])data.getBytes(), (boolean)false, (ResourceSet)resourceSet, (boolean)true);
                    return EMFUtil.getAllPackages((EPackage)ePackage);
                }
            };
            this.packageRegistry.putPackageUnits(array, CDOPackageUnit.State.PROXY);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                packageUnit.load(loader, false);
                ++n2;
            }
            resourceSet.setDelegating(true);
            EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            this.accessor.rawStore(array, this.monitor);
            return this.packageRegistry;
        }

        public InternalCDOBranch handleBranch(int id, String name, long time, int parentID) {
            InternalCDOBranchManager branchManager = CDOServerImporter.this.repository.getBranchManager();
            if (id == 0) {
                return branchManager.getMainBranch();
            }
            InternalCDOBranch parent = branchManager.getBranch(parentID);
            return branchManager.createBranch(id, name, parent, time);
        }

        public boolean handleRevision(CDORevision revision) {
            this.accessor.rawStore((InternalCDORevision)revision, this.monitor);
            return true;
        }

        public OutputStream handleBlob(final byte[] id, final long size) throws IOException {
            return new AsyncOutputStream(){

                protected void asyncWrite(InputStream in) throws IOException {
                    FlushHandler.this.accessor.rawStore(id, size, in);
                }
            };
        }

        public Writer handleClob(final byte[] id, final long size) throws IOException {
            return new AsyncWriter(){

                protected void asyncWrite(Reader in) throws IOException {
                    FlushHandler.this.accessor.rawStore(id, size, in);
                }
            };
        }

        public void handleCommitInfo(long time, long previous, int branchID, String user, String comment) {
            InternalCDOBranch branch = CDOServerImporter.this.repository.getBranchManager().getBranch(branchID);
            this.accessor.rawStore((CDOBranch)branch, time, previous, user, comment, this.monitor);
        }

        public void flush() {
            this.accessor.rawCommit(1.0, this.monitor);
        }

        private void collectPackageInfos() {
            if (this.packageInfos != null) {
                InternalCDOPackageUnit packageUnit = this.packageUnits.getLast();
                packageUnit.setPackageInfos(this.packageInfos.toArray(new InternalCDOPackageInfo[this.packageInfos.size()]));
                this.packageInfos = null;
            }
        }
    }

    public static interface Handler
    extends CDORevisionHandler,
    CDOLobHandler {
        public void handleRepository(String var1, String var2, CDOID var3, long var4, long var6);

        public InternalCDOPackageUnit handlePackageUnit(String var1, CDOPackageUnit.Type var2, long var3, String var5);

        public InternalCDOPackageInfo handlePackageInfo(String var1);

        public InternalCDOPackageRegistry handleModels();

        public InternalCDOBranch handleBranch(int var1, String var2, long var3, int var5);

        public void handleCommitInfo(long var1, long var3, int var5, String var6, String var7);

        public void flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XML
    extends CDOServerImporter
    implements CDOServerExporter.XMLConstants {
        public XML(IRepository repository) {
            super(repository);
        }

        @Override
        protected void importAll(InputStream in, Handler handler) throws Exception {
            XMLHandler xmlHandler = new XMLHandler(handler);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)xmlHandler);
        }

        private static final class XMLHandler
        extends DefaultHandler {
            private Handler handler;
            private InternalCDOPackageRegistry packageRegistry;
            private InternalCDOBranch branch;
            private InternalCDORevision revision;
            private Character blobChar;
            private OutputStream blob;
            private Writer clob;

            private XMLHandler(Handler handler) {
                this.handler = handler;
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("repository".equals(qName)) {
                    String name = attributes.getValue("name");
                    String uuid = attributes.getValue("uuid");
                    CDOID root = this.id(attributes.getValue("root"));
                    long created = Long.parseLong(attributes.getValue("created"));
                    long committed = Long.parseLong(attributes.getValue("committed"));
                    this.handler.handleRepository(name, uuid, root, created, committed);
                } else if ("packageUnit".equals(qName)) {
                    String id = attributes.getValue("id");
                    CDOPackageUnit.Type type = CDOPackageUnit.Type.valueOf((String)attributes.getValue("type"));
                    long time = Long.parseLong(attributes.getValue("time"));
                    String data = attributes.getValue("data");
                    this.handler.handlePackageUnit(id, type, time, data);
                } else if ("packageInfo".equals(qName)) {
                    String packageURI = attributes.getValue("uri");
                    this.handler.handlePackageInfo(packageURI);
                } else if ("branch".equals(qName)) {
                    int id = Integer.parseInt(attributes.getValue("id"));
                    String name = attributes.getValue("name");
                    long time = Long.parseLong(attributes.getValue("time"));
                    String parent = attributes.getValue("parent");
                    int parentID = parent == null ? 0 : Integer.parseInt(parent);
                    this.branch = this.handler.handleBranch(id, name, time, parentID);
                } else if ("revision".equals(qName)) {
                    String featureID;
                    String containerID;
                    String resourceID;
                    CDOClassifierRef classifierRef = new CDOClassifierRef(attributes.getValue("class"));
                    EClass eClass = (EClass)classifierRef.resolve((EPackage.Registry)this.packageRegistry);
                    this.revision = (InternalCDORevision)CDORevisionFactory.DEFAULT.createRevision(eClass);
                    this.revision.setID(this.id(attributes.getValue("id")));
                    this.revision.setBranchPoint(this.branch.getPoint(Long.parseLong(attributes.getValue("time"))));
                    this.revision.setVersion(Integer.parseInt(attributes.getValue("version")));
                    String revised = attributes.getValue("revised");
                    if (revised != null) {
                        this.revision.setRevised(Long.parseLong(revised));
                    }
                    if ((resourceID = attributes.getValue("resource")) != null) {
                        this.revision.setResourceID(this.id(resourceID));
                    }
                    if ((containerID = attributes.getValue("container")) != null) {
                        this.revision.setContainerID((Object)this.id(containerID));
                    }
                    if ((featureID = attributes.getValue("feature")) != null) {
                        this.revision.setContainingFeatureID(Integer.parseInt(featureID));
                    }
                } else if ("feature".equals(qName)) {
                    String name = attributes.getValue("name");
                    Object value = this.value(attributes);
                    EClass eClass = this.revision.getEClass();
                    EStructuralFeature feature = eClass.getEStructuralFeature(name);
                    if (feature == null) {
                        throw new IllegalStateException("Feature " + name + " not found in class " + eClass.getName());
                    }
                    if (feature.isMany()) {
                        CDOList list = this.revision.getList(feature);
                        list.add(value);
                    } else if (value != null) {
                        this.revision.setValue(feature, value);
                    }
                } else if ("blob".equals(qName)) {
                    try {
                        byte[] id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                        long size = Long.parseLong(attributes.getValue("size"));
                        this.blob = this.handler.handleBlob(id, size);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                } else if ("clob".equals(qName)) {
                    try {
                        byte[] id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                        long size = Long.parseLong(attributes.getValue("size"));
                        this.clob = this.handler.handleClob(id, size);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                } else if ("commit".equals(qName)) {
                    long time = Long.parseLong(attributes.getValue("time"));
                    String value = attributes.getValue("previous");
                    long previous = value == null ? 0L : Long.parseLong(value);
                    value = attributes.getValue("branch");
                    int branch = value == null ? 0 : Integer.parseInt(value);
                    String user = attributes.getValue("user");
                    String comment = attributes.getValue("comment");
                    this.handler.handleCommitInfo(time, previous, branch, user, comment);
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.blob != null) {
                    try {
                        if (this.blobChar != null) {
                            char[] firstChars = new char[]{this.blobChar.charValue(), ch[start]};
                            this.blobChar = null;
                            byte[] firstByte = HexUtil.hexToBytes((String)new String(firstChars));
                            this.blob.write(firstByte, 0, 1);
                            ++start;
                            --length;
                        }
                        if ((length & 1) == 1) {
                            this.blobChar = Character.valueOf(ch[--length]);
                        }
                        if (start != 0 || length != ch.length) {
                            char[] tmp = new char[length];
                            System.arraycopy(ch, start, tmp, 0, length);
                            ch = tmp;
                        }
                        byte[] buf = HexUtil.hexToBytes((String)new String(ch));
                        this.blob.write(buf);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
                if (this.clob != null) {
                    try {
                        this.clob.write(ch, start, length);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if ("models".equals(qName)) {
                    this.packageRegistry = this.handler.handleModels();
                } else if ("branch".equals(qName)) {
                    this.branch = null;
                } else if ("revision".equals(qName)) {
                    this.handler.handleRevision((CDORevision)this.revision);
                    this.revision = null;
                } else if ("blob".equals(qName)) {
                    IOUtil.close((Closeable)this.blob);
                    this.blob = null;
                } else if ("clob".equals(qName)) {
                    IOUtil.close((Closeable)this.clob);
                    this.clob = null;
                }
            }

            protected final CDOID id(String str) {
                return CDOIDUtil.read((String)str);
            }

            protected Object value(Attributes attributes) {
                String type = attributes.getValue("type");
                if ("Blob".equals(type)) {
                    byte[] id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                    long size = Long.parseLong(attributes.getValue("size"));
                    return CDOLobUtil.createBlob((byte[])id, (long)size);
                }
                if ("Clob".equals(type)) {
                    byte[] id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                    long size = Long.parseLong(attributes.getValue("size"));
                    return CDOLobUtil.createClob((byte[])id, (long)size);
                }
                if ("FeatureMap".equals(type)) {
                    String innerFeatureName = attributes.getValue("innerFeature");
                    EStructuralFeature innerFeature = this.revision.getEClass().getEStructuralFeature(innerFeatureName);
                    String innerType = attributes.getValue("innerType");
                    Object innerValue = this.value(attributes, innerType);
                    return CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)innerFeature, (Object)innerValue);
                }
                return this.value(attributes, type);
            }

            protected Object value(Attributes attributes, String type) {
                String str = attributes.getValue("value");
                if (str == null) {
                    return null;
                }
                if (type == null || String.class.getSimpleName().equals(type)) {
                    return str;
                }
                if (Object.class.getSimpleName().equals(type)) {
                    return this.id(str);
                }
                if (Boolean.class.getSimpleName().equals(type)) {
                    return Boolean.valueOf(str);
                }
                if (Character.class.getSimpleName().equals(type)) {
                    return Character.valueOf(str.charAt(0));
                }
                if (Byte.class.getSimpleName().equals(type)) {
                    return Byte.valueOf(str);
                }
                if (Short.class.getSimpleName().equals(type)) {
                    return Short.valueOf(str);
                }
                if (Integer.class.getSimpleName().equals(type)) {
                    return Integer.valueOf(str);
                }
                if (Long.class.getSimpleName().equals(type)) {
                    return Long.valueOf(str);
                }
                if (Float.class.getSimpleName().equals(type)) {
                    return Float.valueOf(str);
                }
                if (Double.class.getSimpleName().equals(type)) {
                    return Double.valueOf(str);
                }
                if (Date.class.getSimpleName().equals(type)) {
                    return new Date(Long.valueOf(str));
                }
                if (BigDecimal.class.getSimpleName().equals(type)) {
                    return new BigDecimal(str);
                }
                if (BigInteger.class.getSimpleName().equals(type)) {
                    return new BigInteger(str);
                }
                throw new IllegalArgumentException("Invalid type: " + type);
            }
        }
    }
}

