/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.exception.SashEditorException;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeSashCommand
extends AbstractControlCommand {
    public InitializeSashCommand(ControlModeRequest request) {
        super("Initialize sash model", null, request);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Collection<EObject> openables = this.getMovedOpenablesFromRequest();
        try {
            SashWindowsMngr sashMng = this.createSashWindowsMngr(openables);
            Resource diResource = this.getDiResource();
            if (diResource == null) {
                return CommandResult.newErrorCommandResult((String)"Unable to find DI resource");
            }
            diResource.getContents().add((Object)sashMng);
        }
        catch (SashEditorException e) {
            e.printStackTrace();
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult();
    }

    protected Collection<EObject> getMovedOpenablesFromRequest() {
        Collection tabs = (Collection)this.getRequest().getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables");
        if (tabs == null) {
            return new ArrayList<EObject>();
        }
        return tabs;
    }

    protected Resource getDiResource() {
        return this.getRequest().getTargetResource("di");
    }

    protected SashWindowsMngr createSashWindowsMngr(Collection<EObject> openables) throws SashEditorException {
        SashWindowsMngr windowsMngr = DiUtils.createDefaultSashWindowsMngr();
        Resource diResource = SashModelUtils.getSashModel((ModelSet)this.getRequest().getModelSet()).getResource();
        for (EObject openable : openables) {
            PageRef pageRef = DiUtils.getPageRef((Resource)diResource, (EObject)openable);
            if (pageRef == null) continue;
            windowsMngr.getPageList().addPage(pageRef.getPageIdentifier());
            DiUtils.addPageToTabFolder((SashWindowsMngr)windowsMngr, (PageRef)pageRef);
        }
        return windowsMngr;
    }
}

