/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.ui;

import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CreateModelFragmentDialog
extends ResourceDialog {
    private URI uri;
    private Resource currentResource;
    private String defaultName;

    public CreateModelFragmentDialog(Shell parent, Resource theCurrentResource, String defaultName) {
        super(parent, EMFEditUIPlugin.INSTANCE.getString("_UI_ControlDialog_title"), 8192);
        this.currentResource = theCurrentResource;
        this.defaultName = defaultName;
    }

    private String computeDefaultURI() {
        String ext = this.currentResource.getURI().fileExtension();
        URI uri = this.currentResource.getURI().trimSegments(1);
        uri = uri.appendSegment(this.defaultName).appendFileExtension(ext);
        return uri.toString();
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.uriField.setText(this.computeDefaultURI());
        return result;
    }

    protected boolean processResources() {
        URI uri;
        this.uri = uri = URI.createURI((String)this.getURIText());
        return true;
    }

    public URI getURI() {
        return this.uri;
    }
}

