/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.actions.SessionAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.CreateBranchDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;

public class CreateBranchAction
extends SessionAction {
    public static final String ID = "create-branch";
    private static final String TITLE = Messages.getString("CreateBranchAction.0");
    private static final String TOOL_TIP = Messages.getString("CreateBranchAction.1");
    private String name;
    private CDOBranchPoint base;

    public CreateBranchAction(IWorkbenchPage page, CDOSession session) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, TOOL_TIP, null, session);
        this.setId(ID);
    }

    public boolean isEnabled() {
        if (this.getSession().getRepositoryInfo().getState() == CDOCommonRepository.State.INITIAL) {
            return false;
        }
        return super.isEnabled();
    }

    protected void preRun() throws Exception {
        CreateBranchDialog dialog = new CreateBranchDialog(this.getPage(), this.getSession(), null, true, null){

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(TITLE);
                this.setTitle(TITLE);
                this.setTitleImage(SharedIcons.getImage((String)"wizban/BranchBanner.gif"));
                this.setMessage("Enter the name of the new branch and compose a valid base point.\nYou may also choose a base point from existing commits, tags or views.");
                return super.createDialogArea(parent);
            }

            protected String getComposeTabTitle() {
                return "Base Point";
            }

            protected void validate() {
                CDOBranch branch;
                super.validate();
                String name = this.getName();
                if (StringUtil.isEmpty((String)name)) {
                    this.aggregator.setValidationError((Object)this.getNameText(), "Branch name is empty.");
                    return;
                }
                CDOBranchPoint branchPoint = this.getBranchPoint();
                if (branchPoint != null && (branch = branchPoint.getBranch().getBranch(name)) != null) {
                    this.aggregator.setValidationError((Object)this.getNameText(), "Branch " + branch.getPathName() + " does already exist.");
                    return;
                }
                this.aggregator.setValidationError((Object)this.getNameText(), null);
            }
        };
        if (dialog.open() == 0) {
            this.name = dialog.getName();
            this.base = dialog.getBranchPoint();
            if (StringUtil.isEmpty((String)this.name) || this.base == null) {
                this.cancel();
            }
        } else {
            this.cancel();
        }
        super.preRun();
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        long timeStamp = this.base.getTimeStamp();
        if (timeStamp == 0L || timeStamp == -1L) {
            timeStamp = this.getSession().getRepositoryInfo().getTimeStamp();
        }
        this.base.getBranch().createBranch(this.name, timeStamp);
    }
}

