/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.providers;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.Activator;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;

public class SpecificViewContentProvider
implements IHierarchicContentProvider {
    private EObject[] roots;

    private EObject[] getRoots(ServicesRegistry context) {
        try {
            IPageManager pageManager = (IPageManager)context.getService(IPageManager.class);
            LinkedList<Diagram> result = new LinkedList<Diagram>();
            for (Object page : pageManager.allPages()) {
                if (!(page instanceof Diagram)) continue;
                result.add((Diagram)page);
            }
            return (EObject[])result.toArray(new Diagram[result.size()]);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return new EObject[0];
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.roots == null && inputElement instanceof EObject) {
            try {
                ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)inputElement);
                this.roots = this.getRoots(registry);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return this.roots == null ? new Object[]{} : this.roots;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof EObject) {
            LinkedList<Object> validChildren = new LinkedList<Object>();
            for (Object childElement : ((EObject)parentElement).eContents()) {
                if (this.isValidValue(childElement)) {
                    validChildren.add(childElement);
                    continue;
                }
                validChildren.addAll(Arrays.asList(this.getChildren(childElement)));
            }
            return validChildren.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isValidValue(Object element) {
        if (element instanceof View && ((View)element).getElement() == null) {
            return false;
        }
        return element instanceof View && SemanticElementHelper.findTopView((EObject)((View)element)) == element;
    }
}

