/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XbaseEditorInputRedirector {
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private LanguageInfo languageInfo;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public IEditorInput findOriginalSourceForOuputFolderCopy(IEditorInput input) {
        try {
            IProject _project;
            IJavaProject project;
            boolean _exists;
            IPath _fullPath;
            String _fileExtension;
            boolean _isValid;
            boolean _notEquals;
            IFile resource = ResourceUtil.getFile((IEditorInput)input);
            boolean bl = _notEquals = !Objects.equal((Object)resource, null);
            if (_notEquals && (_isValid = this.fileExtensionProvider.isValid(_fileExtension = (_fullPath = resource.getFullPath()).getFileExtension())) && (_exists = (project = JavaCore.create((IProject)(_project = resource.getProject()))).exists())) {
                IPath _fullPath_1;
                IPath _outputLocation = project.getOutputLocation();
                boolean _isPrefixOf = _outputLocation.isPrefixOf(_fullPath_1 = resource.getFullPath());
                if (_isPrefixOf) {
                    IPath _fullPath_2 = resource.getFullPath();
                    IPath _outputLocation_1 = project.getOutputLocation();
                    int _segmentCount = _outputLocation_1.segmentCount();
                    IPath relative = _fullPath_2.removeFirstSegments(_segmentCount);
                    IPackageFragmentRoot[] _packageFragmentRoots = project.getPackageFragmentRoots();
                    Functions.Function1<IPackageFragmentRoot, Boolean> _function = new Functions.Function1<IPackageFragmentRoot, Boolean>(){

                        public Boolean apply(IPackageFragmentRoot it) {
                            try {
                                int _kind = it.getKind();
                                boolean _equals = _kind == 1;
                                return _equals;
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_packageFragmentRoots)), (Functions.Function1)_function);
                    for (IPackageFragmentRoot source : _filter) {
                        IResource _correspondingResource = source.getCorrespondingResource();
                        IPath _projectRelativePath = _correspondingResource.getProjectRelativePath();
                        IPath fullPath = _projectRelativePath.append(relative);
                        IProject _project_1 = resource.getProject();
                        IFile newFile = _project_1.getFile(fullPath);
                        boolean _exists_1 = newFile.exists();
                        if (!_exists_1) continue;
                        FileEditorInput _fileEditorInput = new FileEditorInput(newFile);
                        return _fileEditorInput;
                    }
                }
                IClasspathEntry[] _rawClasspath = project.getRawClasspath();
                Functions.Function1<IClasspathEntry, Boolean> _function_1 = new Functions.Function1<IClasspathEntry, Boolean>(){

                    public Boolean apply(IClasspathEntry it) {
                        int _entryKind = it.getEntryKind();
                        boolean _equals = _entryKind == 3;
                        return _equals;
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_rawClasspath)), (Functions.Function1)_function_1);
                for (IClasspathEntry sourceFolder : _filter_1) {
                    boolean _notEquals_1;
                    boolean _and = false;
                    IPath _outputLocation_2 = sourceFolder.getOutputLocation();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)_outputLocation_2, null);
                    if (!_notEquals_1) {
                        _and = false;
                    } else {
                        IPath _outputLocation_3 = sourceFolder.getOutputLocation();
                        IPath _fullPath_3 = resource.getFullPath();
                        boolean _isPrefixOf_1 = _outputLocation_3.isPrefixOf(_fullPath_3);
                        boolean bl3 = _and = _notEquals_1 && _isPrefixOf_1;
                    }
                    if (!_and) continue;
                    IPath _fullPath_4 = resource.getFullPath();
                    IPath _outputLocation_4 = sourceFolder.getOutputLocation();
                    int _segmentCount_1 = _outputLocation_4.segmentCount();
                    IPath relative_1 = _fullPath_4.removeFirstSegments(_segmentCount_1);
                    IPackageFragmentRoot[] _findPackageFragmentRoots = project.findPackageFragmentRoots(sourceFolder);
                    IPackageFragmentRoot source_1 = (IPackageFragmentRoot)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_findPackageFragmentRoots)));
                    IResource _correspondingResource = source_1.getCorrespondingResource();
                    IPath _projectRelativePath = _correspondingResource.getProjectRelativePath();
                    IPath fullPath = _projectRelativePath.append(relative_1);
                    IProject _project_1 = resource.getProject();
                    IFile newFile = _project_1.getFile(fullPath);
                    boolean _exists_1 = newFile.exists();
                    if (!_exists_1) continue;
                    FileEditorInput _fileEditorInput = new FileEditorInput(newFile);
                    return _fileEditorInput;
                }
            }
            return input;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IEditorInput findOriginalSource(IEditorInput input) {
        boolean _notEquals;
        IFile resource = ResourceUtil.getFile((IEditorInput)input);
        boolean bl = _notEquals = !Objects.equal((Object)resource, null);
        if (_notEquals) {
            boolean _tripleNotEquals;
            IEditorInput original = this.findOriginalSourceForOuputFolderCopy(input);
            boolean bl2 = _tripleNotEquals = original != input;
            if (_tripleNotEquals) {
                return original;
            }
            ITrace trace = this.traceInformation.getTraceToSource((IStorage)resource);
            boolean _equals = Objects.equal((Object)trace, null);
            if (_equals) {
                return input;
            }
            Iterable _allAssociatedLocations = trace.getAllAssociatedLocations();
            Iterator allLocations = _allAssociatedLocations.iterator();
            ILocationInResource sourceInformation = null;
            boolean _and = false;
            boolean _hasNext = allLocations.hasNext();
            if (!_hasNext) {
                _and = false;
            } else {
                boolean _equals_1 = Objects.equal(sourceInformation, null);
                _and = _hasNext && _equals_1;
            }
            boolean _while = _and;
            while (_while) {
                ILocationInResource candidate = (ILocationInResource)allLocations.next();
                LanguageInfo _language = candidate.getLanguage();
                boolean _equals_2 = this.languageInfo.equals((Object)_language);
                if (_equals_2) {
                    sourceInformation = candidate;
                }
                boolean _and_1 = false;
                boolean _hasNext_1 = allLocations.hasNext();
                if (!_hasNext_1) {
                    _and_1 = false;
                } else {
                    _equals_2 = Objects.equal((Object)sourceInformation, null);
                    _and_1 = _hasNext_1 && _equals_2;
                }
                _while = _and_1;
            }
            boolean _equals_2 = Objects.equal(sourceInformation, null);
            if (_equals_2) {
                return input;
            }
            IStorage originalStorage = sourceInformation.getStorage();
            boolean _matched = false;
            if (!_matched && originalStorage instanceof IFile) {
                IFile _iFile = (IFile)originalStorage;
                _matched = true;
                FileEditorInput _fileEditorInput = new FileEditorInput(_iFile);
                return _fileEditorInput;
            }
            XtextReadonlyEditorInput _xtextReadonlyEditorInput = new XtextReadonlyEditorInput(originalStorage);
            return _xtextReadonlyEditorInput;
        }
        return input;
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(IJavaElement element) {
        IJavaElement _parent = element.getParent();
        return this.getPackageFragmentRoot(_parent);
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(IPackageFragmentRoot element) {
        return element;
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(Void element) {
        IllegalStateException _illegalStateException = new IllegalStateException("couldn't find source package fragment root.");
        throw _illegalStateException;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        if (element instanceof IPackageFragmentRoot) {
            return this._getPackageFragmentRoot((IPackageFragmentRoot)element);
        }
        if (element != null) {
            return this._getPackageFragmentRoot(element);
        }
        if (element == null) {
            return this._getPackageFragmentRoot((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

