/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.ide.ui;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.TableViewLabelProvider;

public class MarkerViewLabelProvider
implements ITableLabelProvider,
IColorProvider,
IFontProvider {
    private final TableViewLabelProvider provider;

    public MarkerViewLabelProvider(TableViewLabelProvider provider) {
        this.provider = provider;
    }

    public Font getFont(Object element) {
        if (element instanceof ConcreteMarker) {
            String handle = ContextCore.getStructureBridge((String)((ConcreteMarker)element).getResource().getFileExtension()).getHandleForOffsetInObject(element, 0);
            IInteractionElement node = ContextCore.getContextManager().getElement(handle);
            if (node != null && node.getInterest().isLandmark() && !node.getInterest().isPropagated()) {
                return CommonFonts.BOLD;
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return this.provider.getColumnImage(element, columnIndex);
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.provider.getColumnText(element, columnIndex);
    }

    public Color getForeground(Object element) {
        if (element instanceof ConcreteMarker) {
            String handle = ContextCore.getStructureBridge((String)((ConcreteMarker)element).getResource().getFileExtension()).getHandleForOffsetInObject(element, 0);
            return ContextUi.getForeground((IInteractionElement)ContextCore.getContextManager().getElement(handle));
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.provider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.provider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

